/*
 * Decompiled with CFR 0.152.
 */
package tidegauge.controller;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import constant.ImportMode$;
import fr.aquasys.daeau.hydrometry.domain.input.HydrometryEventInput;
import fr.aquasys.daeau.hydrometry.itf.HydrometryEventDao;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.daeau.station.links.pointprel.PointPrelDao;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.JobType$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.anorms.AnormHydroChronicImportDao;
import genericImport.model.ImportOptions;
import genericImport.model.ImportOptions$;
import hydrometry.dao.HydrometryStationDao;
import hydrometry.domain.HydrometryObservationInput;
import hydrometry.domain.HydrometryStationInput;
import hydrometry.model.HydrometryStation;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.Months;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import play.api.db.Database;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import tidegauge.constant.TideGaugeConstants$;
import tidegauge.controller.OceanogramFilter;
import tidegauge.controller.OceanogramFilter$;
import tidegauge.controller.TiteGaugeFilter;
import tidegauge.controller.TiteGaugeFilter$;
import tidegauge.dao.StationsHydroMaree;
import tidegauge.dao.http.Aqua6boTideGaugeDao;
import tidegauge.model.HydroMaree;
import tidegauge.model.HydroMaree$;
import tidegauge.model.Oceanogramme;
import tidegauge.model.TideResult;
import util.DateUtil$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\t\u0015g\u0001B\u000e\u001d\u0001\u0005B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ya\f\u0005\ts\u0001\u0011\t\u0011)A\u0006u!Aa\t\u0001B\u0001B\u0003-q\t\u0003\u0005P\u0001\t\u0005\t\u0015a\u0003Q\u0011!9\u0006A!A!\u0002\u0017A\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b1B1\t\u0011)\u0004!\u0011!Q\u0001\f-D\u0001b\u001c\u0001\u0003\u0002\u0003\u0006Y\u0001\u001d\u0005\tu\u0002\u0011\t\u0011)A\u0006w\"Q\u00111\u0001\u0001\u0003\u0002\u0003\u0006Y!!\u0002\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003o\u0002A\u0011IA=\u0011\u001d\tY\n\u0001C\u0005\u0003;Cq!!)\u0001\t\u0003\t\u0019\u000bC\u0005\u0002P\u0002\t\n\u0011\"\u0001\u0002R\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\b\"CA{\u0001E\u0005I\u0011AAi\u0011\u001d\t9\u0010\u0001C\u0001\u0003sDqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003Z\u0001!\tAa\u0017\t\u000f\tE\u0004\u0001\"\u0001\u0003t!9!\u0011\u0012\u0001\u0005\u0002\t-\u0005b\u0002BQ\u0001\u0011\u0005!1\u0015\u0005\b\u0005O\u0003A\u0011\u0001BU\u0005M!\u0016\u000eZ3HCV<WmQ8oiJ|G\u000e\\3s\u0015\tib$\u0001\u0006d_:$(o\u001c7mKJT\u0011aH\u0001\ni&$WmZ1vO\u0016\u001c\u0001aE\u0002\u0001E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u0007\u0005\u0004\u0018.\u0003\u0002.U\t)Qj\u001c3fY\u0006\u0011qo\u001d\t\u0003a]j\u0011!\r\u0006\u0003]IR!a\r\u001b\u0002\t1L'm\u001d\u0006\u0003WUR\u0011AN\u0001\u0005a2\f\u00170\u0003\u00029c\tAqkU\"mS\u0016tG/A\u0004M_\u001e,F/\u001b7\u0011\u0005m\"U\"\u0001\u001f\u000b\u0005ur\u0014\u0001B;uS2T!a\u0010!\u0002\u0011I\f'MY5u[FT!!\u0011\"\u0002\u000f\u0005\fX/Y:zg*\t1)\u0001\u0002ge&\u0011Q\t\u0010\u0002\b\u0019><W\u000b^5m\u0003M\t\u0017/^17E>$\u0016\u000eZ3HCV<W\rR1p!\tAU*D\u0001J\u0015\tQ5*\u0001\u0003iiR\u0004(B\u0001'\u001f\u0003\r!\u0017m\\\u0005\u0003\u001d&\u00131#Q9vCZ\u0012w\u000eV5eK\u001e\u000bWoZ3EC>\fA\u0003[=ee>lW\r\u001e:z'R\fG/[8o\t\u0006|\u0007CA)V\u001b\u0005\u0011&B\u0001'T\u0015\u0005!\u0016A\u00035zIJ|W.\u001a;ss&\u0011aK\u0015\u0002\u0015\u0011f$'o\\7fiJL8\u000b^1uS>tG)Y8\u00025\u0005swN]7Is\u0012\u0014xn\u00115s_:L7-S7q_J$H)Y8\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016AB1o_Jl7OC\u0001^\u000359WM\\3sS\u000eLU\u000e]8si&\u0011qL\u0017\u0002\u001b\u0003:|'/\u001c%zIJ|7\t\u001b:p]&\u001c\u0017*\u001c9peR$\u0015m\\\u0001\u0013Qf$'o\\7fiJLXI^3oi\u0012\u000bw\u000e\u0005\u0002cQ6\t1M\u0003\u0002eK\u0006\u0019\u0011\u000e\u001e4\u000b\u0005Q3'BA4A\u0003\u0015!\u0017-Z1v\u0013\tI7M\u0001\nIs\u0012\u0014x.\\3uef,e/\u001a8u\t\u0006|\u0017AE:uCRLwN\\:Is\u0012\u0014x.T1sK\u0016\u0004\"\u0001\\7\u000e\u0003-K!A\\&\u0003%M#\u0018\r^5p]ND\u0015\u0010\u001a:p\u001b\u0006\u0014X-Z\u0001\r!>Lg\u000e\u001e)sK2$\u0015m\u001c\t\u0003cbl\u0011A\u001d\u0006\u0003gR\f\u0011\u0002]8j]R\u0004(/\u001a7\u000b\u0005U4\u0018!\u00027j].\u001c(BA<g\u0003\u001d\u0019H/\u0019;j_:L!!\u001f:\u0003\u0019A{\u0017N\u001c;Qe\u0016dG)Y8\u0002\u0015){'\rT8h+RLG\u000e\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f\u0001\u0006)Q\u000f^5mg&\u0019\u0011\u0011A?\u0003\u0015){'\rT8h+RLG.\u0001\u0002eEB!\u0011qAA\u0006\u001b\t\tIAC\u0002\u0002\u0004QJA!!\u0004\u0002\n\tAA)\u0019;bE\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003'!b#!\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019#!\n\u0002(\u0005%\u00121\u0006\t\u0004\u0003/\u0001Q\"\u0001\u000f\t\u000b9Z\u00019A\u0018\t\u000beZ\u00019\u0001\u001e\t\u000b\u0019[\u00019A$\t\u000b=[\u00019\u0001)\t\u000b][\u00019\u0001-\t\u000b\u0001\\\u00019A1\t\u000b)\\\u00019A6\t\u000b=\\\u00019\u00019\t\u000bi\\\u00019A>\t\u000f\u0005\r1\u0002q\u0001\u0002\u0006!\u001a1\"a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u00051\u0011N\u001c6fGRT!!!\u000f\u0002\u000b)\fg/\u0019=\n\t\u0005u\u00121\u0007\u0002\u0007\u0013:TWm\u0019;\u0002\u001b\u001d,GOU8vi&twmS3z)\t\t\u0019\u0005\u0005\u0003\u0002F\u0005Mc\u0002BA$\u0003\u001f\u00022!!\u0013%\u001b\t\tYEC\u0002\u0002N\u0001\na\u0001\u0010:p_Rt\u0014bAA)I\u00051\u0001K]3eK\u001aLA!!\u0016\u0002X\t11\u000b\u001e:j]\u001eT1!!\u0015%\u0003\u001d)\u00070Z2vi\u0016$b!!\u0018\u0002d\u0005\u001d\u0004cA\u0012\u0002`%\u0019\u0011\u0011\r\u0013\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003Kj\u0001\u0019AA\"\u0003)\u0011x.\u001e;j]\u001e\\U-\u001f\u0005\b\u0003Sj\u0001\u0019AA6\u0003\u001diWm]:bO\u0016\u0004B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004\u0003c\u0012\u0014\u0001\u00026t_:LA!!\u001e\u0002p\t9!j\u001d,bYV,\u0017a\u00035b]\u0012dW-\u0012:s_J$b!!\u0018\u0002|\u0005E\u0005bBA?\u001d\u0001\u0007\u0011qP\u0001\u0002KB!\u0011\u0011QAF\u001d\u0011\t\u0019)a\"\u000f\t\u0005%\u0013QQ\u0005\u0002K%\u0019\u0011\u0011\u0012\u0013\u0002\u000fA\f7m[1hK&!\u0011QRAH\u0005%)\u0005pY3qi&|gNC\u0002\u0002\n\u0012Bq!a%\u000f\u0001\u0004\t)*\u0001\bk_\n,\u00050Z2vi&|g.\u00133\u0011\u0007\r\n9*C\u0002\u0002\u001a\u0012\u0012A\u0001T8oO\u0006Y\u0011N\u001c;fOJ\fG/[8o)\u0011\ti&a(\t\u000f\u0005%t\u00021\u0001\u0002l\u0005\u00112\u000f^1uS>t\u0017J\u001c;fOJ\fG/[8o)!\t)+a/\u0002F\u0006%G\u0003BAT\u0003s\u0003RaIAU\u0003[K1!a+%\u0005\u0019y\u0005\u000f^5p]B!\u0011qVA[\u001b\t\t\tLC\u0002\u00024N\u000bQ!\\8eK2LA!a.\u00022\n\t\u0002*\u001f3s_6,GO]=Ti\u0006$\u0018n\u001c8\t\u000f\u0005M\u0005\u0003q\u0001\u0002\u0016\"I\u0011Q\u0018\t\u0011\u0002\u0003\u0007\u0011qX\u0001\u0003g&\u00042aIAa\u0013\r\t\u0019\r\n\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\r\u0005a\u0001\u0003\u0007\nAaY8eK\"9\u00111\u001a\tA\u0002\u00055\u0017\u0001B;tKJ\u0004RaIAU\u0003\u0007\nAd\u001d;bi&|g.\u00138uK\u001e\u0014\u0018\r^5p]\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002T*\"\u0011qXAkW\t\t9\u000e\u0005\u0003\u0002Z\u0006\rXBAAn\u0015\u0011\ti.a8\u0002\u0013Ut7\r[3dW\u0016$'bAAqI\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00181\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!E3wK:$8/\u00138uK\u001e\u0014\u0018\r^5p]RA\u00111^Ax\u0003c\f\u0019\u0010\u0006\u0003\u0002@\u00065\bbBAJ%\u0001\u000f\u0011Q\u0013\u0005\n\u0003{\u0013\u0002\u0013!a\u0001\u0003\u007fCq!a2\u0013\u0001\u0004\t\u0019\u0005C\u0004\u0002LJ\u0001\r!!4\u00027\u00154XM\u001c;t\u0013:$Xm\u001a:bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00132\u0003IiW-Y:ve\u0016Le\u000e^3he\u0006$\u0018n\u001c8\u0015\u0015\u0005m\u0018q B\u0002\u0005\u000b\u00119\u0001\u0006\u0003\u0002^\u0005u\bbBAJ)\u0001\u000f\u0011Q\u0013\u0005\b\u0005\u0003!\u0002\u0019AAg\u0003=!\u0017\r^1J]R,wM]1uS>t\u0007BB<\u0015\u0001\u0004\ti\u000bC\u0004\u0002LR\u0001\r!a\u0011\t\u000f\t%A\u00031\u0001\u0003\f\u00051a-\u001b7uKJ\u0004B!a\u0006\u0003\u000e%\u0019!q\u0002\u000f\u0003\u001fQKG/Z$bk\u001e,g)\u001b7uKJ\f1bZ3u\u001b\u0016\f7/\u001e:fgR\u0011\"Q\u0003B\r\u00057\u0011\u0019Da\u000e\u0003:\t%#1\u000bB,)\u0011\tiFa\u0006\t\u000f\u0005MU\u0003q\u0001\u0002\u0016\"1q/\u0006a\u0001\u0003[CqA!\b\u0016\u0001\u0004\u0011y\"A\u0003cK\u001eLg\u000e\u0005\u0003\u0003\"\t=RB\u0001B\u0012\u0015\u0011\u0011)Ca\n\u0002\tQLW.\u001a\u0006\u0005\u0005S\u0011Y#\u0001\u0003k_\u0012\f'B\u0001B\u0017\u0003\ry'oZ\u0005\u0005\u0005c\u0011\u0019C\u0001\u0005ECR,G+[7f\u0011\u001d\u0011)$\u0006a\u0001\u0005?\t1!\u001a8e\u0011\u001d\tY-\u0006a\u0001\u0003\u0007BqAa\u000f\u0016\u0001\u0004\u0011i$A\u0007j[B|'\u000f^(qi&|gn\u001d\t\u0006G\u0005%&q\b\t\u0005\u0005\u0003\u0012)%\u0004\u0002\u0003D)\u0019\u00111\u0017/\n\t\t\u001d#1\t\u0002\u000e\u00136\u0004xN\u001d;PaRLwN\\:\t\u000f\t-S\u00031\u0001\u0003N\u0005YQ.Z1tkJ,G+\u001f9f!\r\u0019#qJ\u0005\u0004\u0005#\"#aA%oi\"9!QK\u000bA\u0002\u0005\r\u0013aD7fCN,(/Z\"p]N$\u0018M\u001c;\t\u000f\t%Q\u00031\u0001\u0003\f\u00059q-\u001a;US\u0012,G\u0003\u0005B/\u0005C\u0012)Ga\u001a\u0003j\t-$Q\u000eB8)\u0011\tiFa\u0018\t\u000f\u0005Me\u0003q\u0001\u0002\u0016\"9!1\r\fA\u0002\t5\u0013!C:uCRLwN\\%e\u0011\u001d\t9M\u0006a\u0001\u0003\u0007BqA!\b\u0017\u0001\u0004\u0011y\u0002C\u0004\u00036Y\u0001\rAa\b\t\u000f\u0005-g\u00031\u0001\u0002D!9!1\b\fA\u0002\tu\u0002b\u0002B&-\u0001\u0007!QJ\u0001\u0012O\u0016$8+[7qYflU-Y:ve\u0016\u001cHC\u0005B;\u0005s\u0012YH! \u0003\u0000\t\u0005%1\u0011BC\u0005\u000f#B!!\u0018\u0003x!9\u00111S\fA\u0004\u0005U\u0005BB<\u0018\u0001\u0004\ti\u000bC\u0004\u0003\u001e]\u0001\rAa\b\t\u000f\tUr\u00031\u0001\u0003 !9\u00111Z\fA\u0002\u0005\r\u0003b\u0002B\u001e/\u0001\u0007!Q\b\u0005\b\u0005\u0017:\u0002\u0019\u0001B'\u0011\u001d\u0011)f\u0006a\u0001\u0003\u0007BqA!\u0003\u0018\u0001\u0004\u0011Y!A\u0007hKRd\u0015n\u001d;PM\u0012\u000bG/\u001a\u000b\u0007\u0005\u001b\u0013IJ!(\u0011\r\u0005\u0005%q\u0012BJ\u0013\u0011\u0011\t*a$\u0003\u0007M+\u0017\u000fE\u0004$\u0005+\u0013yBa\b\n\u0007\t]EE\u0001\u0004UkBdWM\r\u0005\b\u00057C\u0002\u0019\u0001B\u0010\u0003%\u0011WmZ5o\t\u0006$X\rC\u0004\u0003 b\u0001\rAa\b\u0002\u000f\u0015tG\rR1uK\u0006!rjY3oC\u001e\u0014\u0018-\\%oi\u0016<'/\u0019;j_:$B!!\u0018\u0003&\"9\u0011\u0011N\rA\u0002\u0005-\u0014\u0001H(dK\u0006twn\u001a:b[6+\u0017m];sK&sG/Z4sCRLwN\u001c\u000b\u000b\u0005W\u0013yK!-\u00034\nUF\u0003BA/\u0005[Cq!a%\u001b\u0001\b\t)\nC\u0004\u0003\u0002i\u0001\r!!4\t\r]T\u0002\u0019AA\"\u0011\u001d\tYM\u0007a\u0001\u0003\u0007BqA!\u0003\u001b\u0001\u0004\u00119\f\u0005\u0003\u0002\u0018\te\u0016b\u0001B^9\t\u0001rjY3b]><'/Y7GS2$XM\u001d\u0015\u0004\u0001\t}\u0006\u0003BA\u0019\u0005\u0003LAAa1\u00024\tI1+\u001b8hY\u0016$xN\u001c")
public class TideGaugeController
implements Model {
    private final LogUtil LogUtil;
    private final Aqua6boTideGaugeDao aqua6boTideGaugeDao;
    private final HydrometryStationDao hydrometryStationDao;
    private final AnormHydroChronicImportDao AnormHydroChronicImportDao;
    private final HydrometryEventDao hydrometryEventDao;
    private final StationsHydroMaree stationsHydroMaree;
    private final PointPrelDao PointPrelDao;
    private final JobLogUtil JobLogUtil;
    private final Database db;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        TideGaugeController tideGaugeController = this;
        synchronized (tideGaugeController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        TideGaugeController tideGaugeController = this;
        synchronized (tideGaugeController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.INTEGRATION_TIDEGAUGE();
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_TIDEGAUGE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.integration(message);
            return;
        }
        String string4 = IntegrationEngineRouting$.MODULE$.INTEGRATION_OCEANOGRAM();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            this.OcenagramIntegration(message);
            return;
        }
        if (string != null) {
            String string6 = string;
            this.LogUtil.info(new StringBuilder(19).append("Bad routing key => ").append(string6).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    private void integration(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            this.LogUtil.error(new StringBuilder(21).append("Fail to parse json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), this.LogUtil.error$default$2());
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)parameters -> {
            TideGaugeController.$anonfun$integration$2(this, parameters);
            return BoxedUnit.UNIT;
        });
    }

    public Option<HydrometryStation> stationIntegration(boolean si, String code, Option<String> user, long jobExecutionId) {
        Option<HydrometryStation> option = this.hydrometryStationDao.get(code);
        if (option instanceof Some) {
            Some some = (Some)option;
            HydrometryStation station = (HydrometryStation)some.value();
            if (si) {
                Option<HydrometryStationInput> option2 = this.aqua6boTideGaugeDao.getStation(code, jobExecutionId);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    HydrometryStationInput s = (HydrometryStationInput)some2.value();
                    Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
                    Some x$2 = new Some((Object)BoxesRunTime.boxToInteger((int)4));
                    Some x$3 = new Some((Object)DateTime.now());
                    Option<String> x$4 = s.copy$default$1();
                    Option<String> x$5 = s.copy$default$2();
                    Option<String> x$6 = s.copy$default$3();
                    Option<String> x$7 = s.copy$default$4();
                    Option<Object> x$8 = s.copy$default$5();
                    Option<Object> x$9 = s.copy$default$6();
                    Option<Object> x$10 = s.copy$default$7();
                    Option<Object> x$11 = s.copy$default$8();
                    Option<Object> x$12 = s.copy$default$9();
                    Option<Object> x$13 = s.copy$default$10();
                    Option<String> x$14 = s.copy$default$11();
                    Option<Object> x$15 = s.copy$default$12();
                    Option<Object> x$16 = s.copy$default$13();
                    Option<String> x$17 = s.copy$default$14();
                    Option<String> x$18 = s.copy$default$15();
                    Option<String> x$19 = s.copy$default$16();
                    Option<String> x$20 = s.copy$default$17();
                    Option<String> x$21 = s.copy$default$18();
                    Option<String> x$22 = s.copy$default$19();
                    Option<String> x$23 = s.copy$default$20();
                    Option<String> x$24 = s.copy$default$21();
                    Option<String> x$25 = s.copy$default$22();
                    Option<String> x$26 = s.copy$default$23();
                    Option<DateTime> x$27 = s.copy$default$25();
                    Option<DateTime> x$28 = s.copy$default$26();
                    Option<DateTime> x$29 = s.copy$default$27();
                    Option<String> x$30 = s.copy$default$28();
                    Option<Object> x$31 = s.copy$default$29();
                    Option<Object> x$32 = s.copy$default$30();
                    Option<Object> x$33 = s.copy$default$31();
                    Option<Object> x$34 = s.copy$default$32();
                    Option<Object> x$35 = s.copy$default$33();
                    Option<scala.collection.immutable.Seq<String>> x$36 = s.copy$default$34();
                    Option<DateTime> x$37 = s.copy$default$35();
                    Option<DateTime> x$38 = s.copy$default$36();
                    Option<DateTime> x$39 = s.copy$default$37();
                    Option<Object> x$40 = s.copy$default$38();
                    Option<Object> x$41 = s.copy$default$39();
                    Option<String> x$42 = s.copy$default$40();
                    this.hydrometryStationDao.update((int)station.id(), s.copy(x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, (Option<DateTime>)x$3, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, (Option<Object>)x$1, (Option<Object>)x$2).toBHStation(), user, jobExecutionId);
                    return new Some((Object)station);
                }
                if (None$.MODULE$.equals(option2)) {
                    return None$.MODULE$;
                }
                throw new MatchError(option2);
            }
            return new Some((Object)station);
        }
        Option<HydrometryStationInput> option3 = this.aqua6boTideGaugeDao.getStation(code, jobExecutionId);
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            HydrometryStationInput station = (HydrometryStationInput)some.value();
            Some x$43 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
            Some x$44 = new Some((Object)BoxesRunTime.boxToInteger((int)4));
            Some x$45 = new Some((Object)DateTime.now());
            Option<String> x$46 = station.copy$default$1();
            Option<String> x$47 = station.copy$default$2();
            Option<String> x$48 = station.copy$default$3();
            Option<String> x$49 = station.copy$default$4();
            Option<Object> x$50 = station.copy$default$5();
            Option<Object> x$51 = station.copy$default$6();
            Option<Object> x$52 = station.copy$default$7();
            Option<Object> x$53 = station.copy$default$8();
            Option<Object> x$54 = station.copy$default$9();
            Option<Object> x$55 = station.copy$default$10();
            Option<String> x$56 = station.copy$default$11();
            Option<Object> x$57 = station.copy$default$12();
            Option<Object> x$58 = station.copy$default$13();
            Option<String> x$59 = station.copy$default$14();
            Option<String> x$60 = station.copy$default$15();
            Option<String> x$61 = station.copy$default$16();
            Option<String> x$62 = station.copy$default$17();
            Option<String> x$63 = station.copy$default$18();
            Option<String> x$64 = station.copy$default$19();
            Option<String> x$65 = station.copy$default$20();
            Option<String> x$66 = station.copy$default$21();
            Option<String> x$67 = station.copy$default$22();
            Option<String> x$68 = station.copy$default$23();
            Option<DateTime> x$69 = station.copy$default$25();
            Option<DateTime> x$70 = station.copy$default$26();
            Option<DateTime> x$71 = station.copy$default$27();
            Option<String> x$72 = station.copy$default$28();
            Option<Object> x$73 = station.copy$default$29();
            Option<Object> x$74 = station.copy$default$30();
            Option<Object> x$75 = station.copy$default$31();
            Option<Object> x$76 = station.copy$default$32();
            Option<Object> x$77 = station.copy$default$33();
            Option<scala.collection.immutable.Seq<String>> x$78 = station.copy$default$34();
            Option<DateTime> x$79 = station.copy$default$35();
            Option<DateTime> x$80 = station.copy$default$36();
            Option<DateTime> x$81 = station.copy$default$37();
            Option<Object> x$82 = station.copy$default$38();
            Option<Object> x$83 = station.copy$default$39();
            Option<String> x$84 = station.copy$default$40();
            this.hydrometryStationDao.insert(station.copy(x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61, x$62, x$63, x$64, x$65, x$66, x$67, x$68, (Option<DateTime>)x$45, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77, x$78, x$79, x$80, x$81, x$82, x$83, x$84, (Option<Object>)x$43, (Option<Object>)x$44).toBHStation(), user, jobExecutionId);
            return this.hydrometryStationDao.get(code);
        }
        if (None$.MODULE$.equals(option3)) {
            return None$.MODULE$;
        }
        throw new MatchError(option3);
    }

    public boolean stationIntegration$default$1() {
        return true;
    }

    public boolean eventsIntegration(boolean si, String code, Option<String> user, long jobExecutionId) {
        Option<HydrometryStation> option = this.hydrometryStationDao.get(code);
        if (option instanceof Some) {
            Some some = (Some)option;
            HydrometryStation station = (HydrometryStation)some.value();
            scala.collection.immutable.Seq<HydrometryEventInput> events = this.aqua6boTideGaugeDao.getStationEvents(code, jobExecutionId);
            BoxesRunTime.unboxToInt((Object)this.db.withConnection((Function1 & Serializable)c -> BoxesRunTime.boxToInteger((int)this.hydrometryEventDao.setHydroEventsWCForJob((scala.collection.immutable.Seq)events.map((Function1 & Serializable)x$1 -> x$1.toHydroEvent((int)station$1.id(), jobExecutionId$2)), (String)user.getOrElse((Function0 & Serializable)() -> ""), (int)station.id(), JobType$.MODULE$.TIDEGAUGE(), c))));
            return true;
        }
        return false;
    }

    public boolean eventsIntegration$default$1() {
        return true;
    }

    public void measureIntegration(Option<String> dataIntegration, HydrometryStation station, String user, TiteGaugeFilter filter, long jobExecutionId) {
        Option<String> x$1 = dataIntegration;
        Option<Object> x$22 = ImportOptions$.MODULE$.$lessinit$greater$default$1();
        Option<Object> x$32 = ImportOptions$.MODULE$.$lessinit$greater$default$3();
        Option<String> x$42 = ImportOptions$.MODULE$.$lessinit$greater$default$4();
        Option<Object> x$5 = ImportOptions$.MODULE$.$lessinit$greater$default$5();
        Option<scala.collection.immutable.Seq<Object>> x$6 = ImportOptions$.MODULE$.$lessinit$greater$default$6();
        Option<Object> x$7 = ImportOptions$.MODULE$.$lessinit$greater$default$7();
        Some importOptions = new Some((Object)new ImportOptions(x$22, x$1, x$32, x$42, x$5, x$6, x$7));
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Start measure integration", (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
        if (filter.height().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            Option<DateTime> lastadate1 = this.AnormHydroChronicImportDao.getLastDateConnect((int)station.id(), 4, this.AnormHydroChronicImportDao.getLastDateConnect$default$3());
            if (lastadate1.isDefined()) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(28).append("Last Date in bdd ").append(lastadate1.get()).append(" for type 4").toString(), (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
            }
            DateTime startDate = (DateTime)lastadate1.getOrElse((Function0 & Serializable)() -> DateUtil$.MODULE$.BEGIN_DATE_1940());
            DateTime endDate = DateTime.now();
            int startYear = startDate.getYear();
            int endYear = endDate.getYear();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(startYear), endYear).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)year -> {
                DateTime fisrtDateofYear = new DateTime(year, 1, 1, 0, 0);
                DateTime lastDateofYear = new DateTime(year, 12, 31, 23, 59, 59);
                this.getMeasures(station, fisrtDateofYear, lastDateofYear, user, (Option<ImportOptions>)importOptions, 4, TideGaugeConstants$.MODULE$.RAW_HIGHT_FREQUENCE(), filter, jobExecutionId);
            });
        }
        if (filter.forecastTide().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            Option<DateTime> lastadate2 = this.AnormHydroChronicImportDao.getLastDateConnect((int)station.id(), BoxesRunTime.unboxToInt((Object)filter.forecastTideDt().get()), this.AnormHydroChronicImportDao.getLastDateConnect$default$3());
            if (lastadate2.isDefined()) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(27).append("Last Date in bdd ").append(lastadate2.get()).append(" for type ").append(filter.forecastTideDt().get()).toString(), (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
            }
            this.AnormHydroChronicImportDao.deleteMeasures((int)station.id(), BoxesRunTime.unboxToInt((Object)filter.forecastTideDt().get()), BoxesRunTime.unboxToInt((Object)this.PointPrelDao.getDefaultPoint(StationTypeUtil$.MODULE$.HYDROMETRY(), (int)station.id(), BoxesRunTime.unboxToInt((Object)filter.forecastTideDt().get())).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.point())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), DateTime.now(), DateTime.now().plusMonths(1));
            this.getSimplyMeasures(station, (DateTime)lastadate2.getOrElse((Function0 & Serializable)() -> DateTime.now().minusMonths(1)), DateTime.now().plusMonths(1), user, (Option<ImportOptions>)importOptions, BoxesRunTime.unboxToInt((Object)filter.forecastTideDt().get()), TideGaugeConstants$.MODULE$.TIDAL_PREDICTION(), filter, jobExecutionId);
        }
        if (filter.surcharge().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            Option<DateTime> lastadate3 = this.AnormHydroChronicImportDao.getLastDateConnect((int)station.id(), BoxesRunTime.unboxToInt((Object)filter.surchargeDt().get()), this.AnormHydroChronicImportDao.getLastDateConnect$default$3());
            if (lastadate3.isDefined()) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(27).append("Last Date in bdd ").append(lastadate3.get()).append(" for type ").append(filter.surchargeDt().get()).toString(), (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
            }
            this.AnormHydroChronicImportDao.deleteMeasures((int)station.id(), BoxesRunTime.unboxToInt((Object)filter.surchargeDt().get()), BoxesRunTime.unboxToInt((Object)this.PointPrelDao.getDefaultPoint(StationTypeUtil$.MODULE$.HYDROMETRY(), (int)station.id(), BoxesRunTime.unboxToInt((Object)filter.surchargeDt().get())).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.point())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), DateTime.now(), DateTime.now().plusMonths(1));
            this.getSimplyMeasures(station, (DateTime)lastadate3.getOrElse((Function0 & Serializable)() -> DateTime.now().minusMonths(1)), DateTime.now().plusMonths(1), user, (Option<ImportOptions>)importOptions, BoxesRunTime.unboxToInt((Object)filter.surchargeDt().get()), TideGaugeConstants$.MODULE$.OVERSIZE_FORECAST(), filter, jobExecutionId);
        }
        if (filter.surchargeandforecast().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            Option<DateTime> lastadate4 = this.AnormHydroChronicImportDao.getLastDateConnect((int)station.id(), BoxesRunTime.unboxToInt((Object)filter.surchargeandforecastDt().get()), this.AnormHydroChronicImportDao.getLastDateConnect$default$3());
            if (lastadate4.isDefined()) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(27).append("Last Date in bdd ").append(lastadate4.get()).append(" for type ").append(filter.surchargeandforecastDt().get()).toString(), (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
            }
            this.AnormHydroChronicImportDao.deleteMeasures((int)station.id(), BoxesRunTime.unboxToInt((Object)filter.surchargeandforecastDt().get()), BoxesRunTime.unboxToInt((Object)this.PointPrelDao.getDefaultPoint(StationTypeUtil$.MODULE$.HYDROMETRY(), (int)station.id(), BoxesRunTime.unboxToInt((Object)filter.surchargeandforecastDt().get())).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.point())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), DateTime.now(), DateTime.now().plusMonths(1));
            this.getSimplyMeasures(station, (DateTime)lastadate4.getOrElse((Function0 & Serializable)() -> DateTime.now().minusMonths(1)), DateTime.now().plusMonths(1), user, (Option<ImportOptions>)importOptions, BoxesRunTime.unboxToInt((Object)filter.surchargeandforecastDt().get()), TideGaugeConstants$.MODULE$.OVERSIZE_TIDAL(), filter, jobExecutionId);
        }
        if (filter.surchargeReal().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            Option<DateTime> lastadate5 = this.AnormHydroChronicImportDao.getLastDateConnect((int)station.id(), BoxesRunTime.unboxToInt((Object)filter.surchargeRealDt().get()), this.AnormHydroChronicImportDao.getLastDateConnect$default$3());
            if (lastadate5.isDefined()) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(27).append("Last Date in bdd ").append(lastadate5.get()).append(" for type ").append(filter.surchargeRealDt().get()).toString(), (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
            }
            this.getSimplyMeasures(station, (DateTime)lastadate5.getOrElse((Function0 & Serializable)() -> DateTime.now().minusMonths(1)), DateTime.now().plusMonths(1), user, (Option<ImportOptions>)importOptions, BoxesRunTime.unboxToInt((Object)filter.surchargeRealDt().get()), TideGaugeConstants$.MODULE$.OVERSIZE_DISCOUNT(), filter, jobExecutionId);
        }
        if (filter.tide().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            Option<DateTime> lastadate6 = this.AnormHydroChronicImportDao.getLastDateConnect((int)station.id(), 1, this.AnormHydroChronicImportDao.getLastDateConnect$default$3());
            if (lastadate6.isDefined()) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(28).append("Last Date in bdd ").append(lastadate6.get()).append(" for type 1").toString(), (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
            }
            this.getTide((int)station.id(), (String)station.stationCode().get(), (DateTime)lastadate6.getOrElse((Function0 & Serializable)() -> DateTime.now().minusMonths(1)), DateTime.now().plusMonths(1), user, (Option<ImportOptions>)importOptions, 1, jobExecutionId);
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "End measure integration", (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
    }

    public void getMeasures(HydrometryStation station, DateTime begin, DateTime end, String user, Option<ImportOptions> importOptions, int measureType, String measureConstant, TiteGaugeFilter filter, long jobExecutionId) {
        int stationId = (int)station.id();
        scala.collection.immutable.Seq<Tuple2<DateTime, DateTime>> intervals = this.getListOfDate(begin, end);
        scala.collection.immutable.Seq observations = (scala.collection.immutable.Seq)((IterableOps)intervals.flatMap((Function1 & Serializable)dates -> $this.aqua6boTideGaugeDao.getMeasures((String)station.stationCode().get(), (DateTime)dates._1(), (DateTime)dates._2(), TideGaugeConstants$.MODULE$.RAW_DELAYED(), 0, jobExecutionId))).$plus$plus((IterableOnce)((IterableOps)intervals.flatMap((Function1 & Serializable)dates -> $this.aqua6boTideGaugeDao.getMeasures((String)station.stationCode().get(), (DateTime)dates._1(), (DateTime)dates._2(), measureConstant, 0, jobExecutionId))).groupBy((Function1 & Serializable)op -> {
            DateTime date = (DateTime)op.measureDate().get();
            return new Tuple4((Object)BoxesRunTime.boxToInteger((int)date.getYear()), (Object)BoxesRunTime.boxToInteger((int)date.getMonthOfYear()), (Object)BoxesRunTime.boxToInteger((int)date.getDayOfMonth()), (Object)BoxesRunTime.boxToInteger((int)date.getHourOfDay()));
        }).values().map((Function1 & Serializable)seq -> (HydrometryObservationInput)seq.maxBy((Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)x$5.measure()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
        if (observations.nonEmpty()) {
            scala.collection.immutable.Seq data = (scala.collection.immutable.Seq)observations.map((Function1 & Serializable)x$6 -> x$6.toGenericData(measureType, filter.status(), filter.qualification(), filter.producer(), filter.validator(), filter.manager(), filter.nature(), filter.obtainingMode()));
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(30).append("Begin integration of ").append(data.size()).append(" measures").toString(), (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
            this.AnormHydroChronicImportDao.importMeasuresConnect(stationId, (String)station.stationCode().get(), user, jobExecutionId, (scala.collection.immutable.Seq<GenericData>)data, importOptions);
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(24).append("Integration of ").append(data.size()).append(" measures").toString(), (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
            return;
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No measures to import", (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
    }

    public void getTide(int stationId, String code, DateTime begin, DateTime end, String user, Option<ImportOptions> importOptions, int measureType, long jobExecutionId) {
        scala.collection.immutable.Seq<Tuple2<DateTime, DateTime>> intervals = this.getListOfDate(begin, end);
        DateTimeFormatter shomTideDateParser = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC();
        scala.collection.immutable.Seq data = (scala.collection.immutable.Seq)intervals.flatMap((Function1 & Serializable)dates -> $this.aqua6boTideGaugeDao.getTides(code, (DateTime)dates._1(), (DateTime)dates._2(), 0, jobExecutionId));
        if (data.nonEmpty()) {
            Map grouped = data.groupBy((Function1 & Serializable)m -> m.dateMeasure());
            ObjectRef dataToImport = ObjectRef.create((Object)((scala.collection.immutable.Seq)Nil$.MODULE$));
            grouped.keys().map((Function1 & Serializable)dateMeasure -> {
                TideGaugeController.$anonfun$getTide$3(grouped, dataToImport, stationId, shomTideDateParser, jobExecutionId, dateMeasure);
                return BoxedUnit.UNIT;
            });
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(30).append("Begin integration of ").append(((scala.collection.immutable.Seq)dataToImport.elem).size()).append(" measures").toString(), code, this.JobLogUtil.log$default$5());
            ((scala.collection.immutable.Seq)dataToImport.elem).map((Function1 & Serializable)maree -> BoxesRunTime.boxToInteger((int)this.stationsHydroMaree.insert(maree)));
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(24).append("Integration of ").append(((scala.collection.immutable.Seq)dataToImport.elem).size()).append(" measures").toString(), code, this.JobLogUtil.log$default$5());
            return;
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No measures to import", code, this.JobLogUtil.log$default$5());
    }

    public void getSimplyMeasures(HydrometryStation station, DateTime begin, DateTime end, String user, Option<ImportOptions> importOptions, int measureType, String measureConstant, TiteGaugeFilter filter, long jobExecutionId) {
        int stationId = (int)station.id();
        scala.collection.immutable.Seq<Tuple2<DateTime, DateTime>> intervals = this.getListOfDate(begin, end);
        scala.collection.immutable.Seq observations = (scala.collection.immutable.Seq)intervals.flatMap((Function1 & Serializable)dates -> $this.aqua6boTideGaugeDao.getMeasures((String)station.stationCode().get(), (DateTime)dates._1(), (DateTime)dates._2(), measureConstant, 0, jobExecutionId));
        if (observations.nonEmpty()) {
            scala.collection.immutable.Seq data = (scala.collection.immutable.Seq)observations.map((Function1 & Serializable)x$7 -> x$7.toGenericData(measureType, filter.status(), filter.qualification(), filter.producer(), filter.validator(), filter.manager(), filter.nature(), filter.obtainingMode()));
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(30).append("Begin integration of ").append(data.size()).append(" measures").toString(), (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
            this.AnormHydroChronicImportDao.importMeasuresConnect(stationId, (String)station.stationCode().get(), user, jobExecutionId, (scala.collection.immutable.Seq<GenericData>)data, importOptions);
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(24).append("Integration of ").append(data.size()).append(" measures").toString(), (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
            return;
        }
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "No measures to import", (String)station.stationCode().get(), this.JobLogUtil.log$default$5());
    }

    public scala.collection.immutable.Seq<Tuple2<DateTime, DateTime>> getListOfDate(DateTime beginDate, DateTime endDate) {
        if (Months.monthsBetween((ReadableInstant)beginDate, (ReadableInstant)endDate).getMonths() < 1) {
            return new .colon.colon((Object)new Tuple2((Object)beginDate, (Object)endDate), (List)Nil$.MODULE$);
        }
        scala.collection.immutable.Seq listOfDate = package$.MODULE$.Iterator().iterate((Object)beginDate, (Function1 & Serializable)x$8 -> x$8.plus((ReadablePeriod)Period.months((int)1))).takeWhile((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TideGaugeController.$anonfun$getListOfDate$2(endDate, x$9))).toSeq();
        scala.collection.immutable.Seq listOfDateFormatted = (scala.collection.immutable.Seq)((IterableOnceOps)listOfDate.drop(1)).foldLeft((Object)package$.MODULE$.Seq().empty(), (Function2 & Serializable)(acc, dateInList) -> {
            if (acc.nonEmpty()) {
                return (scala.collection.immutable.Seq)acc.$colon$plus((Object)new Tuple2((Object)((DateTime)((Tuple2)acc.last())._2()).plusSeconds(1), dateInList));
            }
            return (scala.collection.immutable.Seq)acc.$colon$plus((Object)new Tuple2((Object)beginDate, dateInList));
        });
        return listOfDateFormatted;
    }

    public void OcenagramIntegration(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)error -> {
            TideGaugeController.$anonfun$OcenagramIntegration$1(this, error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)parameters -> {
            Object object;
            try {
                long jobExecutionId = parameters.jobExecutionId();
                String x$1 = "1";
                Option<String> x$2 = OceanogramFilter$.MODULE$.apply$default$1();
                Option<Object> x$3 = OceanogramFilter$.MODULE$.apply$default$2();
                Option<Object> x$4 = OceanogramFilter$.MODULE$.apply$default$3();
                Option<Object> x$5 = OceanogramFilter$.MODULE$.apply$default$4();
                Option<Object> x$6 = OceanogramFilter$.MODULE$.apply$default$5();
                Option<Object> x$7 = OceanogramFilter$.MODULE$.apply$default$6();
                Option<Object> x$8 = OceanogramFilter$.MODULE$.apply$default$7();
                Option<Object> x$9 = OceanogramFilter$.MODULE$.apply$default$8();
                Option<Object> x$10 = OceanogramFilter$.MODULE$.apply$default$9();
                Option<Object> x$11 = OceanogramFilter$.MODULE$.apply$default$10();
                Option<Object> x$12 = OceanogramFilter$.MODULE$.apply$default$11();
                Option<String> x$13 = OceanogramFilter$.MODULE$.apply$default$12();
                Option<Object> x$14 = OceanogramFilter$.MODULE$.apply$default$13();
                Option<Object> x$15 = OceanogramFilter$.MODULE$.apply$default$14();
                Option<Object> x$16 = OceanogramFilter$.MODULE$.apply$default$15();
                Option<Object> x$17 = OceanogramFilter$.MODULE$.apply$default$16();
                Option<Object> x$18 = OceanogramFilter$.MODULE$.apply$default$17();
                Option<Object> x$19 = OceanogramFilter$.MODULE$.apply$default$18();
                Option<Object> x$20 = OceanogramFilter$.MODULE$.apply$default$19();
                Option<Object> x$21 = OceanogramFilter$.MODULE$.apply$default$20();
                Option<Object> x$22 = OceanogramFilter$.MODULE$.apply$default$21();
                OceanogramFilter filter = (OceanogramFilter)JobUtil$.MODULE$.getFilters(parameters, jobExecutionId, $this.JobLogUtil, (Object)new OceanogramFilter(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, "1"), false, OceanogramFilter$.MODULE$.format());
                Option<String> importMode = filter.importMode();
                object = ((IterableOps)Option$.MODULE$.option2Iterable(parameters.parameters()).head()).map((Function1 & Serializable)station -> {
                    TideGaugeController.$anonfun$OcenagramIntegration$3(this, jobExecutionId, importMode, parameters, filter, station);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                $this.LogUtil.error(new StringBuilder(14).append("Error : ").append(e.getClass().getName()).append(" : ").append(e.getMessage()).append(" \n ").toString(), $this.LogUtil.error$default$2());
                $this.JobLogUtil.log(parameters.jobExecutionId(), JobState$.MODULE$.ERROR(), e.getMessage(), "", $this.JobLogUtil.log$default$5());
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public void OceanogramMeasureIntegration(Option<String> dataIntegration, String station, String user, OceanogramFilter filter, long jobExecutionId) {
        Option<String> x$1 = dataIntegration;
        Option<Object> x$2 = ImportOptions$.MODULE$.$lessinit$greater$default$1();
        Option<Object> x$3 = ImportOptions$.MODULE$.$lessinit$greater$default$3();
        Option<String> x$4 = ImportOptions$.MODULE$.$lessinit$greater$default$4();
        Option<Object> x$5 = ImportOptions$.MODULE$.$lessinit$greater$default$5();
        Option<scala.collection.immutable.Seq<Object>> x$6 = ImportOptions$.MODULE$.$lessinit$greater$default$6();
        Option<Object> x$7 = ImportOptions$.MODULE$.$lessinit$greater$default$7();
        Some importOptions = new Some((Object)new ImportOptions(x$2, x$1, x$3, x$4, x$5, x$6, x$7));
        int stationId = (int)((HydrometryStation)this.hydrometryStationDao.get(station).get()).id();
        DateTimeFormatter dateFormater = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        String url = station.contains("#") ? new StringBuilder(12).append(TideGaugeConstants$.MODULE$.OCEANOGRAM_URL()).append("code=").append(station.substring(0, station.indexOf("#"))).append("&delta=").append(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(filter.delta()))).toString() : new StringBuilder(12).append(TideGaugeConstants$.MODULE$.OCEANOGRAM_URL()).append("code=").append(station).append("&delta=").append(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(filter.delta()))).toString();
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(11).append("Call url : ").append(url).toString(), station, this.JobLogUtil.log$default$5());
        Option<Oceanogramme> oceano = this.aqua6boTideGaugeDao.getOceanogramData(url, station, filter.delta().toString(), 0, jobExecutionId);
        if (oceano.isDefined()) {
            if (filter.surchargeReal().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                scala.collection.immutable.Seq data = (scala.collection.immutable.Seq)((Oceanogramme)oceano.get()).valueVariable().map((Function1 & Serializable)vv -> new GenericData(dateFormater.parseDateTime(vv.datetime()), dateFormater.parseDateTime(vv.datetime()), vv.surge(), BoxesRunTime.unboxToInt((Object)filter.surchargeRealDt().get()), filter.status(), filter.qualification(), filter.obtainingMode(), filter.producer(), filter.validator(), filter.manager(), filter.nature(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(27).append("Begin integration of ").append(data.size()).append(" surge").toString(), station, this.JobLogUtil.log$default$5());
                this.AnormHydroChronicImportDao.importMeasuresConnect(stationId, station, user, jobExecutionId, (scala.collection.immutable.Seq<GenericData>)data, (Option<ImportOptions>)importOptions);
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(21).append("Integration of ").append(data.size()).append(" surge").toString(), station, this.JobLogUtil.log$default$5());
            }
            if (filter.height().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                scala.collection.immutable.Seq data = (scala.collection.immutable.Seq)((Oceanogramme)oceano.get()).valueVariable().map((Function1 & Serializable)vv -> new GenericData(dateFormater.parseDateTime(vv.datetime()), dateFormater.parseDateTime(vv.datetime()), vv.ssh(), BoxesRunTime.unboxToInt((Object)filter.heightDt().get()), filter.status(), filter.qualification(), filter.obtainingMode(), filter.producer(), filter.validator(), filter.manager(), filter.nature(), GenericData$.MODULE$.apply$default$12(), GenericData$.MODULE$.apply$default$13(), GenericData$.MODULE$.apply$default$14(), GenericData$.MODULE$.apply$default$15()));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(28).append("Begin integration of ").append(data.size()).append(" height").toString(), station, this.JobLogUtil.log$default$5());
                this.AnormHydroChronicImportDao.importMeasuresConnect(stationId, station, user, jobExecutionId, (scala.collection.immutable.Seq<GenericData>)data, (Option<ImportOptions>)importOptions);
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(22).append("Integration of ").append(data.size()).append(" height").toString(), station, this.JobLogUtil.log$default$5());
            }
            if (filter.tide().contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                scala.collection.immutable.Seq dataToImport = (scala.collection.immutable.Seq)((IterableOps)((Oceanogramme)oceano.get()).externalData().map((Function1 & Serializable)ed -> {
                    if (ed.tideCoef().isDefined()) {
                        int x$8 = stationId;
                        DateTime x$9 = ed.date();
                        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)((SeqOps)ed.tideCoef().get()).apply(0)))));
                        Some x$11 = new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)((SeqOps)ed.tideCoef().get()).apply(1)))));
                        Some x$12 = new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId));
                        Option<DateTime> x$13 = HydroMaree$.MODULE$.$lessinit$greater$default$3();
                        Option<Object> x$14 = HydroMaree$.MODULE$.$lessinit$greater$default$4();
                        Option<DateTime> x$15 = HydroMaree$.MODULE$.$lessinit$greater$default$5();
                        Option<Object> x$16 = HydroMaree$.MODULE$.$lessinit$greater$default$6();
                        Option<DateTime> x$17 = HydroMaree$.MODULE$.$lessinit$greater$default$7();
                        Option<Object> x$18 = HydroMaree$.MODULE$.$lessinit$greater$default$8();
                        Option<DateTime> x$19 = HydroMaree$.MODULE$.$lessinit$greater$default$9();
                        Option<Object> x$20 = HydroMaree$.MODULE$.$lessinit$greater$default$10();
                        return new .colon.colon((Object)new HydroMaree(x$8, x$9, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, (Option<Object>)x$10, (Option<Object>)x$11, (Option<Object>)x$12), (List)Nil$.MODULE$);
                    }
                    return (scala.collection.immutable.Seq)Nil$.MODULE$;
                })).flatten(Predef$.MODULE$.$conforms());
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(30).append("Begin integration of ").append(dataToImport.size()).append(" measures").toString(), station, this.JobLogUtil.log$default$5());
                dataToImport.map((Function1 & Serializable)maree -> BoxesRunTime.boxToInteger((int)this.stationsHydroMaree.insert(maree)));
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(24).append("Integration of ").append(dataToImport.size()).append(" measures").toString(), station, this.JobLogUtil.log$default$5());
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$integration$3(TideGaugeController $this, long jobExecutionId$1, Option stationInte$1, JobParameters parameters$1, Option importMode$1, TiteGaugeFilter filter$1, String code) {
        $this.JobLogUtil.checkExecutionAbort(jobExecutionId$1);
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.INFO(), new StringBuilder(42).append("Start integration for station with code : ").append(code).toString(), code, $this.JobLogUtil.log$default$5());
        Option<HydrometryStation> option = $this.stationIntegration(stationInte$1.isDefined() && BoxesRunTime.unboxToBoolean((Object)stationInte$1.get()), code, (Option<String>)parameters$1.user(), jobExecutionId$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            HydrometryStation station = (HydrometryStation)some.value();
            if (importMode$1.isDefined()) {
                Object object = importMode$1.get();
                String string = ImportMode$.MODULE$.NOTHING();
                if (object == null ? string != null : !object.equals(string)) {
                    $this.measureIntegration((Option<String>)importMode$1, station, (String)parameters$1.user().getOrElse((Function0 & Serializable)() -> "ADMIN"), filter$1, jobExecutionId$1);
                }
            }
        } else {
            $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.WARNING(), "Station not found", code, $this.JobLogUtil.log$default$5());
        }
        Object object = filter$1.withEvents().contains((Object)BoxesRunTime.boxToBoolean((boolean)true)) ? BoxesRunTime.boxToBoolean((boolean)$this.eventsIntegration(stationInte$1.isDefined() && BoxesRunTime.unboxToBoolean((Object)stationInte$1.get()), code, (Option<String>)parameters$1.user(), jobExecutionId$1)) : BoxedUnit.UNIT;
        $this.JobLogUtil.log(jobExecutionId$1, JobState$.MODULE$.SUCCESS(), new StringBuilder(40).append("End integration for station with code : ").append(code).toString(), code, $this.JobLogUtil.log$default$5());
    }

    public static final /* synthetic */ void $anonfun$integration$2(TideGaugeController $this, JobParameters parameters) {
        block4: {
            try {
                long jobExecutionId = parameters.jobExecutionId();
                TiteGaugeFilter filter = (TiteGaugeFilter)JobUtil$.MODULE$.getFilters(parameters, jobExecutionId, $this.JobLogUtil, (Object)new TiteGaugeFilter(TiteGaugeFilter$.MODULE$.apply$default$1(), TiteGaugeFilter$.MODULE$.apply$default$2(), TiteGaugeFilter$.MODULE$.apply$default$3(), TiteGaugeFilter$.MODULE$.apply$default$4(), TiteGaugeFilter$.MODULE$.apply$default$5(), TiteGaugeFilter$.MODULE$.apply$default$6(), TiteGaugeFilter$.MODULE$.apply$default$7(), TiteGaugeFilter$.MODULE$.apply$default$8(), TiteGaugeFilter$.MODULE$.apply$default$9(), TiteGaugeFilter$.MODULE$.apply$default$10(), TiteGaugeFilter$.MODULE$.apply$default$11(), TiteGaugeFilter$.MODULE$.apply$default$12(), TiteGaugeFilter$.MODULE$.apply$default$13(), TiteGaugeFilter$.MODULE$.apply$default$14(), TiteGaugeFilter$.MODULE$.apply$default$15(), TiteGaugeFilter$.MODULE$.apply$default$16(), TiteGaugeFilter$.MODULE$.apply$default$17(), TiteGaugeFilter$.MODULE$.apply$default$18(), TiteGaugeFilter$.MODULE$.apply$default$19(), TiteGaugeFilter$.MODULE$.apply$default$20(), TiteGaugeFilter$.MODULE$.apply$default$21(), TiteGaugeFilter$.MODULE$.apply$default$22()), false, TiteGaugeFilter$.MODULE$.format());
                Option<Object> stationInte = filter.stationIntegration();
                Option<String> importMode = filter.importMode();
                Option option = parameters.parameters();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    scala.collection.immutable.Seq codes = (scala.collection.immutable.Seq)some.value();
                    codes.foreach((Function1 & Serializable)code -> {
                        TideGaugeController.$anonfun$integration$3($this, jobExecutionId, stationInte, parameters, importMode, filter, code);
                        return BoxedUnit.UNIT;
                    });
                    break block4;
                }
                if (None$.MODULE$.equals(option)) {
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "Parameters is not present", "", $this.JobLogUtil.log$default$5());
                    break block4;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                $this.LogUtil.error(new StringBuilder(14).append("Error : ").append(e.getClass().getName()).append(" : ").append(e.getMessage()).append(" \n ").append(sw.toString()).toString(), $this.LogUtil.error$default$2());
                $this.JobLogUtil.log(parameters.jobExecutionId(), JobState$.MODULE$.ERROR(), e.getMessage(), "", $this.JobLogUtil.log$default$5());
            }
        }
    }

    public static final /* synthetic */ long $anonfun$getTide$6(TideResult l) {
        return ((BaseDateTime)l.measureDate().get()).getMillis();
    }

    public static final /* synthetic */ void $anonfun$getTide$5(Map groupedByTide$1, ObjectRef heure_bm_matin$1, ObjectRef hauteur_bm_matin$1, ObjectRef heure_bm_soir$1, ObjectRef hauteur_bm_soir$1, ObjectRef heure_pm_matin$1, ObjectRef hauteur_pm_matin$1, ObjectRef coefficient_matin$1, ObjectRef heure_pm_soir$1, ObjectRef hauteur_pm_soir$1, ObjectRef coefficient_soir$1, String typ) {
        scala.collection.immutable.Seq sorted = (scala.collection.immutable.Seq)((SeqOps)groupedByTide$1.apply((Object)typ)).sortBy((Function1 & Serializable)l -> BoxesRunTime.boxToLong((long)TideGaugeController.$anonfun$getTide$6(l)), (Ordering)Ordering.Long$.MODULE$);
        int siz = sorted.size();
        if (typ.equalsIgnoreCase("low")) {
            if (siz > 0) {
                heure_bm_matin$1.elem = ((TideResult)sorted.head()).measureDate();
                hauteur_bm_matin$1.elem = ((TideResult)sorted.head()).measure();
            }
            if (siz > 1) {
                heure_bm_soir$1.elem = ((TideResult)sorted.apply(1)).measureDate();
                hauteur_bm_soir$1.elem = ((TideResult)sorted.apply(1)).measure();
            }
        }
        if (typ.equalsIgnoreCase("high")) {
            if (siz > 0) {
                heure_pm_matin$1.elem = ((TideResult)sorted.head()).measureDate();
                hauteur_pm_matin$1.elem = ((TideResult)sorted.head()).measure();
                coefficient_matin$1.elem = ((TideResult)sorted.head()).coeff();
            }
            if (siz > 1) {
                heure_pm_soir$1.elem = ((TideResult)sorted.apply(1)).measureDate();
                hauteur_pm_soir$1.elem = ((TideResult)sorted.apply(1)).measure();
                coefficient_soir$1.elem = ((TideResult)sorted.apply(1)).coeff();
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$getTide$3(Map grouped$1, ObjectRef dataToImport$1, int stationId$1, DateTimeFormatter shomTideDateParser$1, long jobExecutionId$5, String dateMeasure) {
        Map groupedByTide = ((IterableOps)grouped$1.apply((Object)dateMeasure)).groupBy((Function1 & Serializable)m -> m.tide());
        ObjectRef heure_pm_matin = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef hauteur_pm_matin = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef heure_bm_matin = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef hauteur_bm_matin = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef heure_pm_soir = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef hauteur_pm_soir = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef heure_bm_soir = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef hauteur_bm_soir = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef coefficient_matin = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef coefficient_soir = ObjectRef.create((Object)None$.MODULE$);
        groupedByTide.keys().map((Function1 & Serializable)typ -> {
            TideGaugeController.$anonfun$getTide$5(groupedByTide, heure_bm_matin, hauteur_bm_matin, heure_bm_soir, hauteur_bm_soir, heure_pm_matin, hauteur_pm_matin, coefficient_matin, heure_pm_soir, hauteur_pm_soir, coefficient_soir, typ);
            return BoxedUnit.UNIT;
        });
        dataToImport$1.elem = (scala.collection.immutable.Seq)((scala.collection.immutable.Seq)dataToImport$1.elem).$plus$plus((IterableOnce)new .colon.colon((Object)new HydroMaree(stationId$1, shomTideDateParser$1.parseDateTime(dateMeasure), (Option<DateTime>)((Option)heure_pm_matin.elem), (Option<Object>)((Option)hauteur_pm_matin.elem), (Option<DateTime>)((Option)heure_bm_matin.elem), (Option<Object>)((Option)hauteur_bm_matin.elem), (Option<DateTime>)((Option)heure_pm_soir.elem), (Option<Object>)((Option)hauteur_pm_soir.elem), (Option<DateTime>)((Option)heure_bm_soir.elem), (Option<Object>)((Option)hauteur_bm_soir.elem), (Option<Object>)((Option)coefficient_matin.elem), (Option<Object>)((Option)coefficient_soir.elem), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)jobExecutionId$5))), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$getListOfDate$2(DateTime endDate$1, DateTime x$9) {
        return !x$9.isAfter((ReadableInstant)endDate$1.plusMonths(1));
    }

    public static final /* synthetic */ void $anonfun$OcenagramIntegration$1(TideGaugeController $this, Seq error) {
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Fail to parse json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString());
        $this.LogUtil.error(new StringBuilder(21).append("Fail to parse json :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.LogUtil.error$default$2());
    }

    public static final /* synthetic */ void $anonfun$OcenagramIntegration$3(TideGaugeController $this, long jobExecutionId$7, Option importMode$2, JobParameters parameters$2, OceanogramFilter filter$5, String station) {
        $this.JobLogUtil.log(jobExecutionId$7, JobState$.MODULE$.INFO(), new StringBuilder(42).append("Start integration for station with code : ").append(station).toString(), station, $this.JobLogUtil.log$default$5());
        if (importMode$2.isDefined()) {
            Object object = importMode$2.get();
            String string = ImportMode$.MODULE$.NOTHING();
            if (object == null ? string != null : !object.equals(string)) {
                $this.OceanogramMeasureIntegration((Option<String>)importMode$2, station, (String)parameters$2.user().getOrElse((Function0 & Serializable)() -> "ADMIN"), filter$5, jobExecutionId$7);
            }
        }
        $this.JobLogUtil.log(jobExecutionId$7, JobState$.MODULE$.SUCCESS(), new StringBuilder(40).append("End integration for station with code : ").append(station).toString(), station, $this.JobLogUtil.log$default$5());
    }

    @Inject
    public TideGaugeController(WSClient ws, LogUtil LogUtil2, Aqua6boTideGaugeDao aqua6boTideGaugeDao, HydrometryStationDao hydrometryStationDao, AnormHydroChronicImportDao AnormHydroChronicImportDao2, HydrometryEventDao hydrometryEventDao, StationsHydroMaree stationsHydroMaree, PointPrelDao PointPrelDao2, JobLogUtil JobLogUtil2, Database db) {
        this.LogUtil = LogUtil2;
        this.aqua6boTideGaugeDao = aqua6boTideGaugeDao;
        this.hydrometryStationDao = hydrometryStationDao;
        this.AnormHydroChronicImportDao = AnormHydroChronicImportDao2;
        this.hydrometryEventDao = hydrometryEventDao;
        this.stationsHydroMaree = stationsHydroMaree;
        this.PointPrelDao = PointPrelDao2;
        this.JobLogUtil = JobLogUtil2;
        this.db = db;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }
}

