/*
 * Decompiled with CFR 0.152.
 */
package tidegauge.dao.http;

import constant.JobState$;
import fr.aquasys.daeau.hydrometry.domain.input.HydrometryEventInput;
import fr.aquasys.daeau.hydrometry.domain.input.HydrometryEventInput$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.JobLogUtil;
import hydrometry.domain.HydrometryObservationInput;
import hydrometry.domain.HydrometryObservationInput$;
import hydrometry.domain.HydrometryStationInput;
import hydrometry.domain.HydrometryStationInput$;
import java.io.Serializable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.Reads$;
import play.api.libs.ws.WSClient;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.util.Try$;
import tidegauge.constant.TideGaugeConstants$;
import tidegauge.model.Oceanogramme;
import tidegauge.model.Oceanogramme$;
import tidegauge.model.TideResult;
import tidegauge.model.TideResult$;
import util.WSUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005-e\u0001B\u0006\r\u0001MA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ya\u0007\u0005\tO\u0001\u0011\t\u0011)A\u0006Q!A1\u0007\u0001B\u0001B\u0003-A\u0007C\u0003;\u0001\u0011\u00051\bC\u0003L\u0001\u0011\u0005A\nC\u0003l\u0001\u0011\u0005A\u000eC\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA@\u0001\u0011\u0005\u0011\u0011\u0011\u0002\u0014\u0003F,\u0018M\u000e2p)&$WmR1vO\u0016$\u0015m\u001c\u0006\u0003\u001b9\tA\u0001\u001b;ua*\u0011q\u0002E\u0001\u0004I\u0006|'\"A\t\u0002\u0013QLG-Z4bk\u001e,7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0017a\u0002'pOV#\u0018\u000e\u001c\t\u00039\u0015j\u0011!\b\u0006\u0003=}\tA!\u001e;jY*\u0011\u0001%I\u0001\te\u0006\u0014'-\u001b;nc*\u0011!eI\u0001\bCF,\u0018m]=t\u0015\u0005!\u0013A\u00014s\u0013\t1SDA\u0004M_\u001e,F/\u001b7\u0002\u0005]\u001c\bCA\u00152\u001b\u0005Q#BA\u0014,\u0015\taS&\u0001\u0003mS\n\u001c(B\u0001\u00180\u0003\r\t\u0007/\u001b\u0006\u0002a\u0005!\u0001\u000f\\1z\u0013\t\u0011$F\u0001\u0005X'\u000ec\u0017.\u001a8u\u0003)QuN\u0019'pOV#\u0018\u000e\u001c\t\u0003kaj\u0011A\u000e\u0006\u0003o\u0005\nQ!\u001e;jYNL!!\u000f\u001c\u0003\u0015){'\rT8h+RLG.\u0001\u0004=S:LGO\u0010\u000b\u0002yQ!Qh\u0010!B!\tq\u0004!D\u0001\r\u0011\u0015QB\u0001q\u0001\u001c\u0011\u00159C\u0001q\u0001)\u0011\u0015\u0019D\u0001q\u00015Q\t!1\t\u0005\u0002E\u00136\tQI\u0003\u0002G\u000f\u00061\u0011N\u001c6fGRT\u0011\u0001S\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0015\u0016\u0013a!\u00138kK\u000e$\u0018AC4fiN#\u0018\r^5p]R\u0011QJ\u0018\u000b\u0003\u001df\u00032!F(R\u0013\t\u0001fC\u0001\u0004PaRLwN\u001c\t\u0003%^k\u0011a\u0015\u0006\u0003)V\u000ba\u0001Z8nC&t'\"\u0001,\u0002\u0015!LHM]8nKR\u0014\u00180\u0003\u0002Y'\n1\u0002*\u001f3s_6,GO]=Ti\u0006$\u0018n\u001c8J]B,H\u000fC\u0003[\u000b\u0001\u000f1,\u0001\bk_\n,\u00050Z2vi&|g.\u00133\u0011\u0005Ua\u0016BA/\u0017\u0005\u0011auN\\4\t\u000b}+\u0001\u0019\u00011\u0002\t\r|G-\u001a\t\u0003C\"t!A\u00194\u0011\u0005\r4R\"\u00013\u000b\u0005\u0015\u0014\u0012A\u0002\u001fs_>$h(\u0003\u0002h-\u00051\u0001K]3eK\u001aL!!\u001b6\u0003\rM#(/\u001b8h\u0015\t9g#\u0001\thKR\u001cF/\u0019;j_:,e/\u001a8ugR\u0019Q.!\u0002\u0015\u00079\f\u0019\u0001E\u0002pi^t!\u0001\u001d:\u000f\u0005\r\f\u0018\"A\f\n\u0005M4\u0012a\u00029bG.\fw-Z\u0005\u0003kZ\u00141aU3r\u0015\t\u0019h\u0003\u0005\u0002y\u007f6\t\u0011P\u0003\u0002{w\u0006)\u0011N\u001c9vi*\u0011A\u000b \u0006\u0003-vT!A`\u0011\u0002\u000b\u0011\fW-Y;\n\u0007\u0005\u0005\u0011P\u0001\u000bIs\u0012\u0014x.\\3uef,e/\u001a8u\u0013:\u0004X\u000f\u001e\u0005\u00065\u001a\u0001\u001da\u0017\u0005\u0006?\u001a\u0001\r\u0001Y\u0001\fO\u0016$X*Z1tkJ,7\u000f\u0006\u0007\u0002\f\u0005]\u0011\u0011DA\u0019\u0003k\tI\u0004\u0006\u0003\u0002\u000e\u0005U\u0001\u0003B8u\u0003\u001f\u00012AUA\t\u0013\r\t\u0019b\u0015\u0002\u001b\u0011f$'o\\7fiJLxJY:feZ\fG/[8o\u0013:\u0004X\u000f\u001e\u0005\u00065\u001e\u0001\u001da\u0017\u0005\u0006?\u001e\u0001\r\u0001\u0019\u0005\b\u000379\u0001\u0019AA\u000f\u0003\u0015\u0011WmZ5o!\u0011\ty\"!\f\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\tA\u0001^5nK*!\u0011qEA\u0015\u0003\u0011Qw\u000eZ1\u000b\u0005\u0005-\u0012aA8sO&!\u0011qFA\u0011\u0005!!\u0015\r^3US6,\u0007bBA\u001a\u000f\u0001\u0007\u0011QD\u0001\u0004K:$\u0007BBA\u001c\u000f\u0001\u0007\u0001-\u0001\u0005eCR\fG+\u001f9f\u0011\u001d\tYd\u0002a\u0001\u0003{\tq!\u0019;uK6\u0004H\u000fE\u0002\u0016\u0003\u007fI1!!\u0011\u0017\u0005\rIe\u000e^\u0001\tO\u0016$H+\u001b3fgRQ\u0011qIA-\u00037\ni&a\u0018\u0015\t\u0005%\u0013q\u000b\t\u0005_R\fY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\t\u0006E\u0001\u0006[>$W\r\\\u0005\u0005\u0003+\nyE\u0001\u0006US\u0012,'+Z:vYRDQA\u0017\u0005A\u0004mCQa\u0018\u0005A\u0002\u0001Dq!a\u0007\t\u0001\u0004\ti\u0002C\u0004\u00024!\u0001\r!!\b\t\u000f\u0005m\u0002\u00021\u0001\u0002>\u0005\tr-\u001a;PG\u0016\fgn\\4sC6$\u0015\r^1\u0015\u0015\u0005\u0015\u0014\u0011OA;\u0003s\ni\b\u0006\u0003\u0002h\u0005=\u0004\u0003B\u000bP\u0003S\u0002B!!\u0014\u0002l%!\u0011QNA(\u00051y5-Z1o_\u001e\u0014\u0018-\\7f\u0011\u0015Q\u0016\u0002q\u0001\\\u0011\u0019\t\u0019(\u0003a\u0001A\u0006\u0019QO\u001d7\t\r\u0005]\u0014\u00021\u0001a\u0003\u001d\u0019H/\u0019;j_:Da!a\u001f\n\u0001\u0004\u0001\u0017!\u00023fYR\f\u0007bBA\u001e\u0013\u0001\u0007\u0011QH\u0001\u0012GJ,\u0017\r^3NK\u0006\u001cXO]3t+JdG#\u00031\u0002\u0004\u0006\u0015\u0015qQAE\u0011\u0015y&\u00021\u0001a\u0011\u0019\tYB\u0003a\u0001A\"1\u00111\u0007\u0006A\u0002\u0001Da!a\u000e\u000b\u0001\u0004\u0001\u0007")
public class Aqua6boTideGaugeDao {
    private final WSClient ws;
    private final JobLogUtil JobLogUtil;

    public Option<HydrometryStationInput> getStation(String code, long jobExecutionId) {
        String url = new StringBuilder(0).append(TideGaugeConstants$.MODULE$.STATION_URL()).append(code).toString();
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Start station integration", code, this.JobLogUtil.log$default$5());
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(11).append("Call url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
        Option<HydrometryStationInput> option = WSUtil$.MODULE$.getWithAuthOneTry(url, 4, WSUtil$.MODULE$.getWithAuthOneTry$default$3(), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), HydrometryStationInput$.MODULE$.reads(), this.ws);
        if (option instanceof Some) {
            None$ comment;
            None$ none$;
            Some some = (Some)option;
            HydrometryStationInput value = (HydrometryStationInput)some.value();
            Option<String> option2 = value.comment();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                String com = (String)some2.value();
                none$ = value.manager().isDefined() ? new Some((Object)new StringBuilder(3).append(com).append(" - ").append(value.manager().get()).toString()) : new Some((Object)com);
            } else {
                none$ = None$.MODULE$;
            }
            None$ x$1 = comment = none$;
            Option<String> x$2 = value.stationName();
            Option<String> x$3 = value.copy$default$1();
            Option<String> x$4 = value.copy$default$2();
            Option<String> x$5 = value.copy$default$4();
            Option<Object> x$6 = value.copy$default$5();
            Option<Object> x$7 = value.copy$default$6();
            Option<Object> x$8 = value.copy$default$7();
            Option<Object> x$9 = value.copy$default$8();
            Option<Object> x$10 = value.copy$default$9();
            Option<Object> x$11 = value.copy$default$10();
            Option<Object> x$12 = value.copy$default$12();
            Option<Object> x$13 = value.copy$default$13();
            Option<String> x$14 = value.copy$default$14();
            Option<String> x$15 = value.copy$default$15();
            Option<String> x$16 = value.copy$default$16();
            Option<String> x$17 = value.copy$default$17();
            Option<String> x$18 = value.copy$default$18();
            Option<String> x$19 = value.copy$default$19();
            Option<String> x$20 = value.copy$default$20();
            Option<String> x$21 = value.copy$default$21();
            Option<String> x$22 = value.copy$default$22();
            Option<String> x$23 = value.copy$default$23();
            Option<DateTime> x$24 = value.copy$default$24();
            Option<DateTime> x$25 = value.copy$default$25();
            Option<DateTime> x$26 = value.copy$default$26();
            Option<DateTime> x$27 = value.copy$default$27();
            Option<String> x$28 = value.copy$default$28();
            Option<Object> x$29 = value.copy$default$29();
            Option<Object> x$30 = value.copy$default$30();
            Option<Object> x$31 = value.copy$default$31();
            Option<Object> x$32 = value.copy$default$32();
            Option<Object> x$33 = value.copy$default$33();
            Option<Seq<String>> x$34 = value.copy$default$34();
            Option<DateTime> x$35 = value.copy$default$35();
            Option<DateTime> x$36 = value.copy$default$36();
            Option<DateTime> x$37 = value.copy$default$37();
            Option<Object> x$38 = value.copy$default$38();
            Option<Object> x$39 = value.copy$default$39();
            Option<String> x$40 = value.copy$default$40();
            Option<Object> x$41 = value.copy$default$41();
            Option<Object> x$42 = value.copy$default$42();
            HydrometryStationInput result = value.copy(x$3, x$4, x$2, x$5, x$6, x$7, x$8, x$9, x$10, x$11, (Option<String>)x$1, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42);
            return new Some((Object)result);
        }
        return None$.MODULE$;
    }

    public Seq<HydrometryEventInput> getStationEvents(String code, long jobExecutionId) {
        String url = new StringBuilder(0).append(TideGaugeConstants$.MODULE$.STATION_EVENT_URL()).append(code).toString();
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), "Start station event integration", code, this.JobLogUtil.log$default$5());
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(11).append("Call url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
        Option option = WSUtil$.MODULE$.getWithAuthOneTry(url, 4, WSUtil$.MODULE$.getWithAuthOneTry$default$3(), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), HydrometryEventInput$.MODULE$.reads()), this.ws);
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq value = (Seq)some.value();
            return value;
        }
        return (Seq)Nil$.MODULE$;
    }

    public Seq<HydrometryObservationInput> getMeasures(String code, DateTime begin, DateTime end, String dataType, int attempt, long jobExecutionId) {
        String url = this.createMeasuresUrl(code, Long.toString(begin.getMillis()), Long.toString(end.getMillis()), dataType);
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(11).append("Call url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
        Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> WSUtil$.MODULE$.getWithAuthOneTry(url, 4, WSUtil$.MODULE$.getWithAuthOneTry$default$3(), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), HydrometryObservationInput$.MODULE$.reads()), $this.ws)).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (None$.MODULE$.equals(option)) {
            if (attempt == 3) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "3 attempt failed : Error while fetching measure", code, this.JobLogUtil.log$default$5());
                return (Seq)Nil$.MODULE$;
            }
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(59).append("Attempt ").append(attempt).append(" failed, waiting 10s : Error while fetching measure").toString(), code, this.JobLogUtil.log$default$5());
            Thread.sleep(10000L);
            return this.getMeasures(code, begin, end, dataType, attempt + 1, jobExecutionId);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq observations = (Seq)some.value();
            return observations;
        }
        throw new MatchError((Object)option);
    }

    public Seq<TideResult> getTides(String code, DateTime begin, DateTime end, int attempt, long jobExecutionId) {
        String url = this.createMeasuresUrl(code, Long.toString(begin.getMillis()), Long.toString(end.getMillis()), TideGaugeConstants$.MODULE$.TIDE());
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(11).append("Call url : ").append(url).toString(), code, this.JobLogUtil.log$default$5());
        Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> WSUtil$.MODULE$.getWithAuthOneTry(url, 4, WSUtil$.MODULE$.getWithAuthOneTry$default$3(), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), TideResult$.MODULE$.writes()), $this.ws)).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (None$.MODULE$.equals(option)) {
            if (attempt == 3) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.WARNING(), "3 attempt failed : Error while fetching measure", code, this.JobLogUtil.log$default$5());
                return (Seq)Nil$.MODULE$;
            }
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(59).append("Attempt ").append(attempt).append(" failed, waiting 10s : Error while fetching measure").toString(), code, this.JobLogUtil.log$default$5());
            Thread.sleep(10000L);
            return this.getTides(code, begin, end, attempt + 1, jobExecutionId);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq observations = (Seq)some.value();
            return observations;
        }
        throw new MatchError((Object)option);
    }

    public Option<Oceanogramme> getOceanogramData(String url, String station, String delta, int attempt, long jobExecutionId) {
        Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> WSUtil$.MODULE$.getWithAuthOneTry(url, 4, WSUtil$.MODULE$.getWithAuthOneTry$default$3(), WSUtil$.MODULE$.getWithAuthOneTry$default$4(), Oceanogramme$.MODULE$.writes(), $this.ws)).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (None$.MODULE$.equals(option)) {
            if (attempt == 4) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "4 attempt failed : Error while fetching measure", station, this.JobLogUtil.log$default$5());
                return None$.MODULE$;
            }
            if (attempt == 3) {
                this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(58).append("Attempt ").append(attempt).append(" failed, waiting 3m : Error while fetching measure").toString(), station, this.JobLogUtil.log$default$5());
                Thread.sleep(5000L);
                return this.getOceanogramData(url, station, delta, attempt + 1, jobExecutionId);
            }
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(59).append("Attempt ").append(attempt).append(" failed, waiting 10s : Error while fetching measure").toString(), station, this.JobLogUtil.log$default$5());
            Thread.sleep(5000L);
            return this.getOceanogramData(url, station, delta, attempt + 1, jobExecutionId);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Oceanogramme data = (Oceanogramme)some.value();
            return new Some((Object)data);
        }
        throw new MatchError((Object)option);
    }

    public String createMeasuresUrl(String code, String begin, String end, String dataType) {
        String string = dataType;
        String string2 = TideGaugeConstants$.MODULE$.RAW_HIGHT_FREQUENCE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return new StringBuilder(30).append(TideGaugeConstants$.MODULE$.MEASURE_URL()).append(code).append("&beginDate=").append(begin).append("&endDate=").append(end).append("&dataType=").append(dataType).toString();
        }
        String string4 = TideGaugeConstants$.MODULE$.RAW_DELAYED();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return new StringBuilder(30).append(TideGaugeConstants$.MODULE$.MEASURE_URL()).append(code).append("&beginDate=").append(begin).append("&endDate=").append(end).append("&dataType=").append(dataType).toString();
        }
        String string6 = TideGaugeConstants$.MODULE$.TIDE();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return new StringBuilder(20).append(TideGaugeConstants$.MODULE$.TIDE_URL()).append(code).append("&beginDate=").append(begin).append("&endDate=").append(end).toString();
        }
        return new StringBuilder(30).append(TideGaugeConstants$.MODULE$.STATISTICS_URL()).append(code).append("&beginDate=").append(begin).append("&endDate=").append(end).append("&dataType=").append(dataType).toString();
    }

    @Inject
    public Aqua6boTideGaugeDao(LogUtil LogUtil2, WSClient ws, JobLogUtil JobLogUtil2) {
        this.ws = ws;
        this.JobLogUtil = JobLogUtil2;
    }
}

