/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.Serializable;
import org.locationtech.proj4j.BasicCoordinateTransform;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.ProjCoordinate;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class CoordinatesUtils$ {
    public static final CoordinatesUtils$ MODULE$ = new CoordinatesUtils$();
    private static final CRSFactory factory = new CRSFactory();

    public Tuple2<Object, Object> centroid(Seq<Seq<Object>> polygon) {
        int pointCount = polygon.length();
        Tuple2 tuple2 = (Tuple2)polygon.foldLeft((Object)new Tuple2.mcDD.sp(0.0, 0.0), (Function2 & Serializable)(tuple, points) -> new Tuple2.mcDD.sp(tuple._1$mcD$sp() + BoxesRunTime.unboxToDouble((Object)points.apply(0)), tuple._2$mcD$sp() + BoxesRunTime.unboxToDouble((Object)points.apply(1))));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double x = tuple2._1$mcD$sp();
        double y = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
        double x2 = sp2._1$mcD$sp();
        double y2 = sp2._2$mcD$sp();
        return new Tuple2.mcDD.sp(x2 / (double)pointCount, y2 / (double)pointCount);
    }

    public Tuple2<Object, Object> convertEPSG3857ToWgs84(double xCoordinateInput, double yCoordinateInput) {
        return this.convertCoordinate(xCoordinateInput, yCoordinateInput, "EPSG:3857", "EPSG:4326");
    }

    public CRSFactory factory() {
        return factory;
    }

    public CoordinateReferenceSystem createCoordinateSystem(String value) {
        return this.factory().createFromName(value);
    }

    public Tuple2<Object, Object> convertCoordinate(double xCoordinateInput, double yCoordinateInput, String sourceEPSG, String outputEPSG) {
        CoordinateReferenceSystem sourceCRS = this.createCoordinateSystem(sourceEPSG);
        CoordinateReferenceSystem targetCRS = this.createCoordinateSystem(outputEPSG);
        BasicCoordinateTransform transform = new BasicCoordinateTransform(sourceCRS, targetCRS);
        ProjCoordinate srcCoord = new ProjCoordinate(xCoordinateInput, yCoordinateInput);
        ProjCoordinate dstCoord = new ProjCoordinate();
        transform.transform(srcCoord, dstCoord);
        return new Tuple2.mcDD.sp(dstCoord.x, dstCoord.y);
    }

    private CoordinatesUtils$() {
    }
}

