/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.Serializable;
import play.api.http.Status$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class WSUtil$ {
    public static final WSUtil$ MODULE$ = new WSUtil$();
    private static final ExecutionContext context = ExecutionContext$.MODULE$.global();
    private static final Tuple2<String, String> authorization = new Tuple2((Object)"Authorization", (Object)System.getenv("APPLICATION_TOKEN"));

    public ExecutionContext context() {
        return context;
    }

    private Tuple2<String, String> authorization() {
        return authorization;
    }

    public <T> Option<T> response(Future<WSResponse> future, String url, Seq<Tuple3<Object, Function0<BoxedUnit>, Option<T>>> handledErrors, Duration timeout, Reads<T> reads) {
        Some some;
        Tuple3 tuple3;
        WSResponse r = (WSResponse)Await$.MODULE$.result(future, timeout);
        int n = r.status();
        if (Status$.MODULE$.OK() == n ? true : Status$.MODULE$.PARTIAL_CONTENT() == n) {
            JsResult jsResult = r.json().validate(reads);
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                return new Some(jsSuccess.value());
            }
            if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Predef$.MODULE$.println((Object)jsError.toString());
                return None$.MODULE$;
            }
            throw new MatchError((Object)jsResult);
        }
        Option option = handledErrors.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WSUtil$.$anonfun$response$1(r, x$1)));
        if (option instanceof Some && (tuple3 = (Tuple3)(some = (Some)option).value()) != null) {
            Function0 func = (Function0)tuple3._2();
            Option defaultReturn = (Option)tuple3._3();
            func.apply$mcV$sp();
            return defaultReturn;
        }
        if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println((Object)new StringBuilder(40).append("Unexpected response received with url : ").append(url).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(3).append(r.status()).append(" : ").append(r.statusText()).toString());
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public <T> Seq<Nothing$> response$default$3() {
        return (Seq)Nil$.MODULE$;
    }

    public <T> Duration response$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes();
    }

    public <T> Future<Either<T, Exception>> responseWithReads(Future<WSResponse> future, Reads<T> reads, String url, Seq<Tuple3<Object, Function0<BoxedUnit>, Either<T, Exception>>> handledErrors) {
        return future.map((Function1 & Serializable)response -> {
            Some some;
            Tuple3 tuple3;
            int n = response.status();
            if (Status$.MODULE$.OK() == n) {
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> response.json());
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    JsValue json = (JsValue)success.value();
                    JsResult jsResult = json.validate(reads);
                    if (jsResult instanceof JsSuccess) {
                        JsSuccess jsSuccess = (JsSuccess)jsResult;
                        return package$.MODULE$.Left().apply(jsSuccess.value());
                    }
                    if (jsResult instanceof JsError) {
                        JsError jsError = (JsError)jsResult;
                        return package$.MODULE$.Right().apply((Object)new Exception(jsError.toString()));
                    }
                    throw new MatchError((Object)jsResult);
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    Predef$.MODULE$.println((Object)new StringBuilder(39).append("ERROR : failed to read json with url : ").append(url).toString());
                    e.printStackTrace();
                    return package$.MODULE$.Right().apply((Object)new Exception(e));
                }
                throw new MatchError((Object)try_);
            }
            Option option = handledErrors.find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WSUtil$.$anonfun$responseWithReads$3(response, x$2)));
            if (option instanceof Some && (tuple3 = (Tuple3)(some = (Some)option).value()) != null) {
                Function0 func = (Function0)tuple3._2();
                Either defaultReturn = (Either)tuple3._3();
                func.apply$mcV$sp();
                return defaultReturn;
            }
            if (None$.MODULE$.equals(option)) {
                Predef$.MODULE$.println((Object)new StringBuilder(40).append("Unexpected response received with url : ").append(url).toString());
                return package$.MODULE$.Right().apply((Object)new Exception(new StringBuilder(13).append(response.status()).append(": ").append(response.statusText()).append(", with url ").append(url).toString()));
            }
            throw new MatchError((Object)option);
        }, this.context());
    }

    public <T> Seq<Nothing$> responseWithReads$default$4() {
        return (Seq)Nil$.MODULE$;
    }

    public <T> Future<Try<T>> responseTry(Future<WSResponse> future, Reads<T> reads) {
        return future.map((Function1 & Serializable)response -> {
            int n = response.status();
            if (Status$.MODULE$.OK() == n) {
                JsResult jsResult = response.json().validate(reads);
                if (jsResult instanceof JsSuccess) {
                    JsSuccess jsSuccess = (JsSuccess)jsResult;
                    return new Success(jsSuccess.value());
                }
                if (jsResult instanceof JsError) {
                    JsError jsError = (JsError)jsResult;
                    return new Failure((Throwable)new Exception(jsError.toString()));
                }
                throw new MatchError((Object)jsResult);
            }
            return new Failure((Throwable)new Exception(new StringBuilder(2).append(response.status()).append(": ").append(response.statusText()).toString()));
        }, this.context());
    }

    public <T> Option<T> simpleGet(String url, int nb, Duration timeout, Reads<T> reads, WSClient ws) {
        Option<T> option;
        block4: {
            try {
                Future x$1 = ws.url(url).withRequestTimeout(timeout).get();
                String x$2 = url;
                Duration x$3 = timeout;
                Seq<Nothing$> x$4 = this.response$default$3();
                option = this.response((Future<WSResponse>)x$1, x$2, x$4, x$3, reads);
            }
            catch (Throwable e) {
                if (nb > 0) {
                    Predef$.MODULE$.println((Object)new StringBuilder(17).append(" Error on appel ").append(url).append(" ").append(nb).toString());
                    Thread.sleep(5000L);
                    option = this.getWithAuthOneTry(url, nb - 1, this.getWithAuthOneTry$default$3(), this.getWithAuthOneTry$default$4(), reads, ws);
                    break block4;
                }
                if (nb == 0) {
                    Predef$.MODULE$.println((Object)new StringBuilder(16).append(" Error on url  ").append(url).append(" ").append(nb).toString());
                    Thread.sleep(5000L);
                    option = this.getWithAuthOneTry(url, nb - 1, this.getWithAuthOneTry$default$3(), this.getWithAuthOneTry$default$4(), reads, ws);
                    break block4;
                }
                option = None$.MODULE$;
            }
        }
        return option;
    }

    public <T> int simpleGet$default$2() {
        return 3;
    }

    public <T> Duration simpleGet$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).minutes();
    }

    public <T> Future<Either<T, Exception>> simpleGetWithReads(String url, Reads<T> reads, WSClient ws) {
        return this.responseWithReads((Future<WSResponse>)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), reads, url, this.responseWithReads$default$4());
    }

    public <T> Future<Either<T, Exception>> simplePostWithReads(String url, JsValue json, Reads<T> reads, WSClient ws) {
        return this.responseWithReads((Future<WSResponse>)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).post((Object)json, play.api.libs.ws.package$.MODULE$.writeableOf_JsValue()), reads, url, this.responseWithReads$default$4());
    }

    public <T> Future<Try<T>> simpleGetTry(String url, Reads<T> reads, WSClient ws) {
        return this.responseTry((Future<WSResponse>)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), reads);
    }

    public <T> Future<Try<T>> simpleGetWithAuthTry(String url, Reads<T> reads, WSClient ws) {
        return this.responseTry((Future<WSResponse>)ws.url(url).withHttpHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.authorization()})).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), reads);
    }

    public <T> Future<Try<T>> simplePostTry(String url, JsValue json, Reads<T> reads, WSClient ws) {
        return this.responseTry((Future<WSResponse>)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).post((Object)json, play.api.libs.ws.package$.MODULE$.writeableOf_JsValue()), reads);
    }

    public <T> Option<T> getWithAuth(String url, Seq<Tuple3<Object, Function0<BoxedUnit>, Option<T>>> handledErrors, Reads<T> reads, WSClient ws) {
        return this.getWithAuthOneTry(url, 4, handledErrors, this.getWithAuthOneTry$default$4(), reads, ws);
    }

    public <T> Seq<Nothing$> getWithAuth$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    public <T> Option<T> getWithAuthOneTry(String url, int nb, Seq<Tuple3<Object, Function0<BoxedUnit>, Option<T>>> handledErrors, Duration timeout, Reads<T> reads, WSClient ws) {
        Option<T> option;
        while (true) {
            try {
                option = this.response((Future<WSResponse>)ws.url(url).withHttpHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.authorization()})).withRequestTimeout(timeout).get(), url, handledErrors, timeout, reads);
            }
            catch (Throwable e) {
                if (nb >= 0) {
                    Predef$.MODULE$.println((Object)e);
                    Predef$.MODULE$.println((Object)new StringBuilder(15).append("Error on call ").append(url).append(" ").append(nb).toString());
                    Thread.sleep(5000L);
                    timeout = this.getWithAuthOneTry$default$4();
                    handledErrors = this.getWithAuthOneTry$default$3();
                    --nb;
                    continue;
                }
                throw new Exception(new StringBuilder(34).append("url not respond with 3 attempts : ").append(url).toString());
            }
            break;
        }
        return option;
    }

    public <T> Seq<Nothing$> getWithAuthOneTry$default$3() {
        return (Seq)Nil$.MODULE$;
    }

    public <T> Duration getWithAuthOneTry$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minutes();
    }

    public <T> Option<T> postAqua6BO(String url, String body, Duration timeout, int attempt, Reads<T> reads, WSClient ws) {
        Option<T> option;
        while (true) {
            try {
                Future x$1 = ws.url(url).withHttpHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.authorization()})).withRequestTimeout(timeout).post((Object)body, play.api.libs.ws.package$.MODULE$.writeableOf_String());
                String x$2 = url;
                Duration x$3 = timeout;
                Seq<Nothing$> x$4 = this.response$default$3();
                option = this.response((Future<WSResponse>)x$1, x$2, x$4, x$3, reads);
            }
            catch (Throwable throwable) {
                if (attempt < 3) {
                    Thread.sleep(5000L);
                    ++attempt;
                    continue;
                }
                throw new Exception(new StringBuilder(34).append("url not respond with 3 attempts : ").append(url).toString());
            }
            break;
        }
        return option;
    }

    public <T> Duration postAqua6BO$default$3() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minutes();
    }

    public <T> int postAqua6BO$default$4() {
        return 1;
    }

    public String postAqua6BOAsString(String url, String body, WSClient ws) {
        WSResponse resp = (WSResponse)Await$.MODULE$.result((Awaitable)ws.url(url).withHttpHeaders(fr.aquasys.utils.WSUtil$.MODULE$.getAqua6BoHeaders()).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minutes()).post((Object)body, play.api.libs.ws.package$.MODULE$.writeableOf_String()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).minutes());
        if (resp.status() != 200) {
            throw new Exception(new StringBuilder(32).append("Error whith Aqua6BO call : ").append(url).append(", ").append(resp.status()).append(" : ").append(resp.statusText()).toString());
        }
        return resp.body();
    }

    public <T> Future<Either<T, Exception>> getWithAuthWithReads(String url, Reads<T> reads, Option<Tuple2<String, String>> auth, Seq<Tuple3<Object, Function0<BoxedUnit>, Either<T, Exception>>> handledErrors, WSClient ws) {
        return this.responseWithReads((Future<WSResponse>)ws.url(url).withHttpHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{(Tuple2)auth.getOrElse((Function0 & Serializable)() -> MODULE$.authorization())})).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), reads, url, handledErrors);
    }

    public <T> Option<Tuple2<String, String>> getWithAuthWithReads$default$3() {
        return None$.MODULE$;
    }

    public <T> Seq<Nothing$> getWithAuthWithReads$default$4() {
        return (Seq)Nil$.MODULE$;
    }

    public String getAsString(String url, WSClient ws) {
        return ((WSResponse)Await$.MODULE$.result((Awaitable)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes())).body();
    }

    public static final /* synthetic */ boolean $anonfun$response$1(WSResponse r$1, Tuple3 x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1._1()) == r$1.status();
    }

    public static final /* synthetic */ boolean $anonfun$responseWithReads$3(WSResponse response$1, Tuple3 x$2) {
        return BoxesRunTime.unboxToInt((Object)x$2._1()) == response$1.status();
    }

    private WSUtil$() {
    }
}

