/*
 * Decompiled with CFR 0.152.
 */
package util;

import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.utils.JobLogUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

public final class ZipUtil$ {
    public static final ZipUtil$ MODULE$ = new ZipUtil$();

    public boolean unzipFiles(String directory, Option<String> filter, JobLogUtil JobLogUtil2, long jobExecutionId, Option<Object> debugMode) {
        block1: {
            if (!new File(directory).exists()) {
                JobLogUtil2.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(116).append("Directory does not exists. Please correct the job directory path or contact the administrator to create directory : ").append(directory).toString(), "", JobLogUtil2.log$default$5());
                return false;
            }
            File[] testZipFiles = new File(directory).listFiles();
            File[] zipfilesToProcess = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])testZipFiles), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ZipUtil$.$anonfun$unzipFiles$1(f)));
            if (zipfilesToProcess.length <= 0) break block1;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])zipfilesToProcess), (Function1 & Serializable)f -> {
                ZipUtil$.$anonfun$unzipFiles$2(directory, filter, JobLogUtil2, jobExecutionId, debugMode, f);
                return BoxedUnit.UNIT;
            });
        }
        return true;
    }

    public void unzip(File zipFile, File outputFolder, Option<String> filter, JobLogUtil JobLogUtil2, long jobExecutionId, Option<Object> debugMode) throws FileNotFoundException, IOException {
        byte[] buffer = new byte[1024];
        try {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                boolean goodName = false;
                if (filter.isDefined()) {
                    if (((String)filter.get()).startsWith("*") && ((String)filter.get()).endsWith("*") && ((String)filter.get()).length() > 1) {
                        String searchValue = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString((String)filter.get()), 1)), 1).toUpperCase();
                        goodName = ze.getName().toUpperCase().contains(searchValue);
                    } else if (((String)filter.get()).contains("*")) {
                        boolean bl;
                        String ends;
                        IndexedSeq splitted = Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)((String)filter.get()).split("\\*"));
                        String starts = splitted.nonEmpty() ? (String)splitted.head() : (String)filter.get();
                        String string = ends = splitted.length() > 1 ? (String)splitted.apply(1) : "";
                        if (splitted.length() == 1) {
                            String string2 = ze.getName();
                            Object object = filter.get();
                            bl = !(string2 != null ? !string2.equals(object) : object != null);
                        } else {
                            bl = ze.getName().startsWith(starts) && ze.getName().endsWith(ends);
                        }
                        goodName = bl;
                    } else {
                        String string = ze.getName();
                        Object object = filter.get();
                        goodName = !(string != null ? !string.equals(object) : object != null);
                    }
                } else {
                    goodName = true;
                }
                if (goodName) {
                    String fileName = ze.getName();
                    File newFile = new File(new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)outputFolder), File.separator)).append(fileName).toString());
                    JobLogUtil2.debug(jobExecutionId, new StringBuilder(13).append("file unzip : ").append(ze.getName()).toString(), "", JobLogUtil2.debug$default$4(), debugMode);
                    new File(newFile.getParent()).mkdirs();
                    FileOutputStream fos = new FileOutputStream(newFile);
                    int len = zis.read(buffer);
                    while (len > 0) {
                        fos.write(buffer, 0, len);
                        len = zis.read(buffer);
                    }
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException e) {
            JobLogUtil2.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(18).append("exception caught: ").append(e.getMessage()).toString(), "", JobLogUtil2.log$default$5());
        }
    }

    public Option<String> unzipFiles$default$2() {
        return None$.MODULE$;
    }

    public Option<String> unzip$default$3() {
        return None$.MODULE$;
    }

    public boolean deleteFileAfterThreatment(String directory, boolean rename, JobLogUtil JobLogUtil2, long jobExecutionId, Option<Object> debugMode) throws FileNotFoundException, IOException {
        block1: {
            if (!new File(directory).exists()) {
                JobLogUtil2.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(116).append("Directory does not exists. Please correct the job directory path or contact the administrator to create directory : ").append(directory).toString(), "", JobLogUtil2.log$default$5());
                return false;
            }
            File[] testZipFiles = new File(directory).listFiles();
            File[] zipfilesToProcess = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])testZipFiles), (Function1 & Serializable)zipfile -> BoxesRunTime.boxToBoolean((boolean)ZipUtil$.$anonfun$deleteFileAfterThreatment$1(zipfile)));
            if (zipfilesToProcess.length <= 0) break block1;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])zipfilesToProcess), (Function1 & Serializable)zipfile -> {
                Object object;
                block7: {
                    ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipfile.getCanonicalFile())));
                    Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        ZipEntry ze = null;
                        while (zis != null) {
                            Object object;
                            ze = zis.getNextEntry();
                            if (BoxedUnit.UNIT == null) break;
                            File f = new File(new File(directory).getCanonicalPath(), ze.getName());
                            JobLogUtil2.debug(jobExecutionId, new StringBuilder(16).append("suppression de ").append(new File(directory).getCanonicalPath()).append("/").append(ze.getName()).toString(), "", JobLogUtil2.debug$default$4(), debugMode);
                            try {
                                if (f != null && f.exists()) {
                                    object = BoxesRunTime.boxToBoolean((boolean)f.delete());
                                    continue;
                                }
                                object = BoxedUnit.UNIT;
                            }
                            catch (Exception e) {
                                JobLogUtil2.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(18).append("exception caught: ").append(e.getMessage()).toString(), "", JobLogUtil2.log$default$5());
                                object = BoxedUnit.UNIT;
                            }
                        }
                    });
                    if (try_ instanceof Failure) {
                        zis.close();
                    } else {
                        zis.close();
                    }
                    try {
                        if (rename) {
                            JobLogUtil2.debug(jobExecutionId, new StringBuilder(7).append("rename ").append(zipfile.getAbsolutePath()).toString(), "", JobLogUtil2.debug$default$4(), debugMode);
                            object = zipfile != null && zipfile.exists() ? BoxesRunTime.boxToBoolean((boolean)zipfile.renameTo(new File(new StringBuilder(6).append(zipfile.getAbsolutePath()).append(".").append(Long.toString(new DateTime().getMillis())).append(".DONE").toString()))) : BoxedUnit.UNIT;
                            break block7;
                        }
                        object = BoxedUnit.UNIT;
                    }
                    catch (IOException ioe) {
                        JobLogUtil2.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(27).append("Error during file rename : ").append(ioe.getMessage()).toString(), "", zipfile.getName());
                        object = BoxesRunTime.boxToBoolean((boolean)false);
                    }
                    catch (NullPointerException ie) {
                        JobLogUtil2.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(27).append("Error during file rename : ").append(ie).toString(), "", zipfile.getName());
                        object = BoxesRunTime.boxToBoolean((boolean)false);
                    }
                    catch (Exception e) {
                        JobLogUtil2.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(27).append("Error during file rename : ").append(e.getMessage()).toString(), "", zipfile.getName());
                        object = BoxesRunTime.boxToBoolean((boolean)false);
                    }
                }
                return object;
            });
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$unzipFiles$1(File f) {
        return f.getName().toLowerCase().endsWith("zip");
    }

    public static final /* synthetic */ void $anonfun$unzipFiles$2(String directory$1, Option filter$1, JobLogUtil JobLogUtil$1, long jobExecutionId$1, Option debugMode$1, File f) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> MODULE$.unzip(f, new File(directory$1), (Option<String>)filter$1, JobLogUtil$1, jobExecutionId$1, (Option<Object>)debugMode$1));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            JobLogUtil$1.log(jobExecutionId$1, JobState$.MODULE$.ERROR(), new StringBuilder(26).append("Error during file unzip : ").append(error.getMessage()).toString(), "", f.getName());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$deleteFileAfterThreatment$1(File zipfile) {
        return zipfile.getName().toLowerCase().endsWith("zip");
    }

    private ZipUtil$() {
    }
}

