/*
 * Decompiled with CFR 0.152.
 */
package weatherMeasures;

import api.Model;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import fr.aquasys.daeau.iaeau.dao.CalculatedMeasureDao;
import fr.aquasys.daeau.iaeau.model.CalculatedMeasure;
import fr.aquasys.daeau.iaeau.model.CalculatedMeasure$;
import fr.aquasys.daeau.job.model.GenericData;
import fr.aquasys.daeau.job.model.GenericData$;
import fr.aquasys.daeau.job.model.JobParameters;
import fr.aquasys.daeau.job.model.JobParameters$;
import fr.aquasys.daeau.job.model.JobState$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.Topic;
import fr.aquasys.rabbitmq.api.constant.IntegrationEngineRouting$;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.DateUtil$;
import fr.aquasys.utils.JobLogUtil;
import fr.aquasys.utils.JobUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import genericImport.itf.GenericImportDao;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.ws.WSClient;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import util.WSUtil$;
import weatherMeasures.WMJson;
import weatherMeasures.WMJson$;
import weatherMeasures.WMStation;
import weatherMeasures.WeatherMeasuresFilter;
import weatherMeasures.WeatherMeasuresFilter$;

@ScalaSignature(bytes="\u0006\u0005\tMa\u0001\u0002\u000b\u0016\u0001aA\u0001\"\n\u0001\u0003\u0002\u0003\u0006YA\n\u0005\te\u0001\u0011\t\u0011)A\u0006g!A\u0011\b\u0001B\u0001B\u0003-!\b\u0003\u0005C\u0001\t\u0005\t\u0015a\u0003D\u0011!i\u0005A!A!\u0002\u0017q\u0005\"\u0002-\u0001\t\u0003I\u0006\"B6\u0001\t\u0003b\u0007\"\u0002=\u0001\t\u0003J\bbBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u00037\u0001A\u0011AA\u001a\u0011\u001d\t9\u0004\u0001C\u0001\u0003sAq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003\u007f\u0003A\u0011AAa\u0011\u001d\ty\u000f\u0001C\u0001\u0003cDqAa\u0002\u0001\t\u0003\u0011IAA\rXK\u0006$\b.\u001a:NK\u0006\u001cXO]3t\u0007>tGO]8mY\u0016\u0014(\"\u0001\f\u0002\u001f],\u0017\r\u001e5fe6+\u0017m];sKN\u001c\u0001aE\u0002\u00013}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u0007\u0005\u0004\u0018.\u0003\u0002%C\t)Qj\u001c3fY\u00069Aj\\4Vi&d\u0007CA\u00141\u001b\u0005A#BA\u0015+\u0003\u0011)H/\u001b7\u000b\u0005-b\u0013\u0001\u0003:bE\nLG/\\9\u000b\u00055r\u0013aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002_\u0005\u0011aM]\u0005\u0003c!\u0012q\u0001T8h+RLG.\u0001\u0006K_\ndunZ+uS2\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0017\u0002\u000bU$\u0018\u000e\\:\n\u0005a*$A\u0003&pE2{w-\u0016;jY\u0006\u0001r-\u001a8fe&\u001c\u0017*\u001c9peR$\u0015m\u001c\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\n1!\u001b;g\u0015\u0005y\u0014!D4f]\u0016\u0014\u0018nY%na>\u0014H/\u0003\u0002By\t\u0001r)\u001a8fe&\u001c\u0017*\u001c9peR$\u0015m\\\u0001\u0015\u0007\u0006d7-\u001e7bi\u0016$W*Z1tkJ,G)Y8\u0011\u0005\u0011[U\"A#\u000b\u0005\u0019;\u0015a\u00013b_*\u0011\u0001*S\u0001\u0006S\u0006,\u0017-\u001e\u0006\u0003\u00152\nQ\u0001Z1fCVL!\u0001T#\u0003)\r\u000bGnY;mCR,G-T3bgV\u0014X\rR1p\u0003\t98\u000f\u0005\u0002P-6\t\u0001K\u0003\u0002N#*\u0011!kU\u0001\u0005Y&\u00147O\u0003\u0002#)*\tQ+\u0001\u0003qY\u0006L\u0018BA,Q\u0005!96k\u00117jK:$\u0018A\u0002\u001fj]&$h\bF\u0001[)\u0019YVLX0aCB\u0011A\fA\u0007\u0002+!)QE\u0002a\u0002M!)!G\u0002a\u0002g!)\u0011H\u0002a\u0002u!)!I\u0002a\u0002\u0007\")QJ\u0002a\u0002\u001d\"\u0012aa\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fa!\u001b8kK\u000e$(\"\u00015\u0002\u000b)\fg/\u0019=\n\u0005),'AB%oU\u0016\u001cG/A\u0007hKR\u0014v.\u001e;j]\u001e\\U-\u001f\u000b\u0002[B\u0011a.\u001e\b\u0003_N\u0004\"\u0001]\u000e\u000e\u0003ET!A]\f\u0002\rq\u0012xn\u001c;?\u0013\t!8$\u0001\u0004Qe\u0016$WMZ\u0005\u0003m^\u0014aa\u0015;sS:<'B\u0001;\u001c\u0003-A\u0017M\u001c3mK\u0016\u0013(o\u001c:\u0015\til\u0018\u0011\u0003\t\u00035mL!\u0001`\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006}\"\u0001\ra`\u0001\u0002KB!\u0011\u0011AA\u0006\u001d\u0011\t\u0019!a\u0002\u000f\u0007A\f)!C\u0001\u001d\u0013\r\tIaG\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti!a\u0004\u0003\u0013\u0015C8-\u001a9uS>t'bAA\u00057!9\u00111\u0003\u0005A\u0002\u0005U\u0011A\u00046pE\u0016CXmY;uS>t\u0017\n\u001a\t\u00045\u0005]\u0011bAA\r7\t!Aj\u001c8h\u0003\u001d)\u00070Z2vi\u0016$RA_A\u0010\u0003GAa!!\t\n\u0001\u0004i\u0017A\u0003:pkRLgnZ&fs\"9\u0011QE\u0005A\u0002\u0005\u001d\u0012aB7fgN\fw-\u001a\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011QF)\u0002\t)\u001cxN\\\u0005\u0005\u0003c\tYCA\u0004KgZ\u000bG.^3\u0015\u0007i\f)\u0004C\u0004\u0002&)\u0001\r!a\n\u0002\u0017%l\u0007o\u001c:u\r&dWm\u001d\u000b\u0007\u0003w\ty$!\u0013\u0015\u0007i\fi\u0004C\u0004\u0002\u0014-\u0001\u001d!!\u0006\t\u000f\u0005\u00053\u00021\u0001\u0002D\u00059a-\u001b7uKJ\u001c\bc\u0001/\u0002F%\u0019\u0011qI\u000b\u0003+]+\u0017\r\u001e5fe6+\u0017m];sKN4\u0015\u000e\u001c;fe\"9\u00111J\u0006A\u0002\u00055\u0013!\u00046pEB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0002P\u0005eSBAA)\u0015\u0011\t\u0019&!\u0016\u0002\u000b5|G-\u001a7\u000b\u0007\u0005]\u0013*A\u0002k_\nLA!a\u0017\u0002R\ti!j\u001c2QCJ\fW.\u001a;feN\fQ\"[7q_J$x+\u0014)pS:$H\u0003CA1\u0003K\ny'!\u001d\u0015\u0007i\f\u0019\u0007C\u0004\u0002\u00141\u0001\u001d!!\u0006\t\u000f\u0005\u001dD\u00021\u0001\u0002j\u00051\u0001\u000f\\;wS>\u00042\u0001XA6\u0013\r\ti'\u0006\u0002\n/6\u001bF/\u0019;j_:Dq!!\u0011\r\u0001\u0004\t\u0019\u0005C\u0004\u0002L1\u0001\r!!\u0014\u0002\u0011\u001d,G\u000fS5ti>$b!a\u001e\u0002\b\u0006-E\u0003BA=\u0003\u000b\u0003b!!\u0001\u0002|\u0005}\u0014\u0002BA?\u0003\u001f\u00111aU3r!\ra\u0016\u0011Q\u0005\u0004\u0003\u0007+\"AB,N\u0015N|g\u000eC\u0004\u0002\u00145\u0001\u001d!!\u0006\t\u000f\u0005%U\u00021\u0001\u0002D\u00051a-\u001b7uKJDq!!$\u000e\u0001\u0004\ty)A\u0004q_&tG/\u00133\u0011\ti\t\t*\\\u0005\u0004\u0003'[\"AB(qi&|g.\u0001\u0004hKR|%m\u001d\u000b\u0007\u00033\u000bi*a(\u0015\t\u0005e\u00141\u0014\u0005\b\u0003'q\u00019AA\u000b\u0011\u001d\tII\u0004a\u0001\u0003\u0007Bq!!$\u000f\u0001\u0004\ty)A\u0004hKR\u0004&/\u001a<\u0015\r\u0005\u0015\u0016\u0011VAV)\u0011\tI(a*\t\u000f\u0005Mq\u0002q\u0001\u0002\u0016!9\u0011\u0011R\bA\u0002\u0005\r\u0003BBAG\u001f\u0001\u0007Q.A\u0007u_\u001e+g.\u001a:jG\u0012\u000bG/\u0019\u000b\u0007\u0003c\u000bI,a/\u0011\r\u0005\u0005\u00111PAZ!\u0011\ty%!.\n\t\u0005]\u0016\u0011\u000b\u0002\f\u000f\u0016tWM]5d\t\u0006$\u0018\rC\u0004\u0002\nB\u0001\r!a\u0011\t\u000f\u0005u\u0006\u00031\u0001\u0002z\u0005!A-\u0019;b\u0003-9WM\\3sS\u000e$\u0015\r^1\u0015\u0011\u0005M\u00161YAn\u0003KDq!!2\u0012\u0001\u0004\t9-A\u0001e!\u0011\tI-a6\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\fA\u0001^5nK*!\u0011\u0011[Aj\u0003\u0011Qw\u000eZ1\u000b\u0005\u0005U\u0017aA8sO&!\u0011\u0011\\Af\u0005!!\u0015\r^3US6,\u0007bBAo#\u0001\u0007\u0011q\\\u0001\u0006m\u0006dW/\u001a\t\u00045\u0005\u0005\u0018bAAr7\t1Ai\\;cY\u0016Dq!a:\u0012\u0001\u0004\tI/\u0001\u0005eCR\fG+\u001f9f!\rQ\u00121^\u0005\u0004\u0003[\\\"aA%oi\u0006\u0019Bo\\\"bY\u000e,H.\u0019;fI6+\u0017m];sKRA\u00111_A\u0000\u0005\u0003\u0011\u0019\u0001\u0005\u0004\u0002\u0002\u0005m\u0014Q\u001f\t\u0005\u0003o\fY0\u0004\u0002\u0002z*\u0019\u00111K$\n\t\u0005u\u0018\u0011 \u0002\u0012\u0007\u0006d7-\u001e7bi\u0016$W*Z1tkJ,\u0007bBAE%\u0001\u0007\u00111\t\u0005\b\u0003{\u0013\u0002\u0019AA=\u0011\u001d\u0011)A\u0005a\u0001\u0003S\f\u0011\"\u001b3Ti\u0006$\u0018n\u001c8\u0002#\r\fGnY;mCR,G-T3bgV\u0014X\r\u0006\u0006\u0002v\n-!Q\u0002B\b\u0005#Aq!!2\u0014\u0001\u0004\t9\rC\u0004\u0002^N\u0001\r!a8\t\u000f\u0005\u001d8\u00031\u0001\u0002j\"9!QA\nA\u0002\u0005%\b")
public class WeatherMeasuresController
implements Model {
    private final LogUtil LogUtil;
    private final JobLogUtil JobLogUtil;
    private final GenericImportDao genericImportDao;
    private final CalculatedMeasureDao CalculatedMeasureDao;
    private final WSClient ws;
    private LogUtil logUtil;
    private Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit;
    private LogUtil logsUtil;
    private volatile byte bitmap$0;

    @Override
    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> initTopic() {
        return Model.initTopic$(this);
    }

    @Override
    public void executeWrapper(String routingKey, JsValue message) {
        Model.executeWrapper$(this, routingKey, message);
    }

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logUtil$lzycompute() {
        WeatherMeasuresController weatherMeasuresController = this;
        synchronized (weatherMeasuresController) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logUtil = Topic.logUtil$((Topic)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logUtil;
    }

    public LogUtil logUtil() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.logUtil$lzycompute();
        }
        return this.logUtil;
    }

    public Tuple2<String, Function2<String, JsValue, BoxedUnit>> fr$aquasys$rabbitmq$api$Topic$$callInit() {
        return this.fr$aquasys$rabbitmq$api$Topic$$callInit;
    }

    public final void fr$aquasys$rabbitmq$api$Topic$_setter_$fr$aquasys$rabbitmq$api$Topic$$callInit_$eq(Tuple2<String, Function2<String, JsValue, BoxedUnit>> x$1) {
        this.fr$aquasys$rabbitmq$api$Topic$$callInit = x$1;
    }

    private LogUtil logsUtil$lzycompute() {
        WeatherMeasuresController weatherMeasuresController = this;
        synchronized (weatherMeasuresController) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    @Override
    public String getRoutingKey() {
        return IntegrationEngineRouting$.MODULE$.WEATHER_MEASURE_TOPIC();
    }

    @Override
    public void handleError(Exception e, long jobExecutionId) {
        this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), e.getMessage(), "", this.JobLogUtil.log$default$5());
    }

    @Override
    public void execute(String routingKey, JsValue message) {
        String string = routingKey;
        String string2 = IntegrationEngineRouting$.MODULE$.INTEGRATION_WEATHER_MEASURES();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.execute(message);
            return;
        }
        if (string != null) {
            String string4 = string;
            this.LogUtil.info(new StringBuilder(19).append("Bad routing key => ").append(string4).toString(), this.LogUtil.info$default$2());
            return;
        }
        throw new MatchError((Object)string);
    }

    public void execute(JsValue message) {
        message.validate((Reads)JobParameters$.MODULE$.writes()).fold((Function1 & Serializable)x$1 -> ErrorUtil$.MODULE$.jsonError("Can't read job parameters input for weather measures job", 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.LogUtil), (Function1 & Serializable)jobParameters -> {
            WeatherMeasuresController.$anonfun$execute$2(this, jobParameters);
            return BoxedUnit.UNIT;
        });
    }

    public void importFiles(WeatherMeasuresFilter filters, JobParameters jobParameters, long jobExecutionId) {
        Seq<WMJson> allObsMeasures = BoxesRunTime.unboxToInt((Object)filters.importMode().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)) == 1 ? this.getObs(filters, (Option<String>)None$.MODULE$, jobExecutionId) : this.getHisto(filters, (Option<String>)None$.MODULE$, jobExecutionId);
        allObsMeasures.groupBy((Function1 & Serializable)x$2 -> x$2.pointId()).foreach((Function1 & Serializable)x0$1 -> {
            WeatherMeasuresController.$anonfun$importFiles$3(this, filters, jobParameters, jobExecutionId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void importWMPoint(WMStation pluvio, WeatherMeasuresFilter filters, JobParameters jobParameters, long jobExecutionId) {
        if (pluvio.idWM().isEmpty()) {
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(42).append("Can't get Weather Measures id for station ").append(pluvio.code()).toString(), pluvio.code(), this.JobLogUtil.log$default$5());
            return;
        }
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int pointId = BoxesRunTime.unboxToInt((Object)pluvio.idWM().get());
            $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(26).append("Start import for point id ").append(pointId).toString(), pluvio.code(), $this.JobLogUtil.log$default$5());
            if (BoxesRunTime.unboxToInt((Object)filters.importMode().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)) == 1) {
                if (filters.obsDays().exists((Function1)(JFunction1.mcZI.sp & Serializable)o -> o > 0)) {
                    Seq<GenericData> obsMeasures = this.toGenericData(filters, this.getObs(filters, (Option<String>)new Some((Object)Integer.toString(pointId)), jobExecutionId));
                    int res = $this.genericImportDao.importPluviometryChronic(Integer.toString(pluvio.id()), pluvio.code(), (String)jobParameters.user().getOrElse((Function0 & Serializable)() -> "ADMIN"), jobExecutionId, obsMeasures, $this.genericImportDao.importPluviometryChronic$default$6());
                    if (res > 0) {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(20).append(res).append(" obs measures saved.").toString(), pluvio.code(), $this.JobLogUtil.log$default$5());
                    } else {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing new to import", pluvio.code(), $this.JobLogUtil.log$default$5());
                    }
                }
                if (filters.prevDays().exists((Function1)(JFunction1.mcZI.sp & Serializable)o -> o > 0)) {
                    Seq<CalculatedMeasure> prevMeasures = this.toCalculatedMeasure(filters, this.getPrev(filters, Integer.toString(pointId), jobExecutionId), pluvio.id());
                    int res = $this.CalculatedMeasureDao.setMeasures(pluvio.id(), -1, StationTypeUtil$.MODULE$.PLUVIOMETRY(), prevMeasures);
                    if (res > 0) {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(21).append(res).append(" prev measures saved.").toString(), pluvio.code(), $this.JobLogUtil.log$default$5());
                    } else {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing new to import", pluvio.code(), $this.JobLogUtil.log$default$5());
                    }
                }
            }
            if (BoxesRunTime.unboxToInt((Object)filters.importMode().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1)) == 2) {
                if (filters.startDate().isDefined() && filters.endDate().isDefined()) {
                    if (DateUtil$.MODULE$.setMaxDay((DateTime)filters.endDate().get()).getMillis() > new DateTime().getMillis()) {
                        throw new Exception("End date can't be superior than today");
                    }
                    Seq<GenericData> obsMeasures = this.toGenericData(filters, this.getHisto(filters, (Option<String>)new Some((Object)Integer.toString(pointId)), jobExecutionId));
                    int res = $this.genericImportDao.importPluviometryChronic(Integer.toString(pluvio.id()), pluvio.code(), (String)jobParameters.user().getOrElse((Function0 & Serializable)() -> "ADMIN"), jobExecutionId, obsMeasures, $this.genericImportDao.importPluviometryChronic$default$6());
                    if (res > 0) {
                        $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.SUCCESS(), new StringBuilder(20).append(res).append(" obs measures saved.").toString(), pluvio.code(), $this.JobLogUtil.log$default$5());
                        return;
                    }
                    $this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing new to import", pluvio.code(), $this.JobLogUtil.log$default$5());
                    return;
                }
                return;
            }
        });
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(22).append("Error during import : ").append(err.getMessage()).toString(), pluvio.code(), this.JobLogUtil.log$default$5());
            this.LogUtil.printError(err);
            return;
        }
        throw new MatchError((Object)try_);
    }

    public Seq<WMJson> getHisto(WeatherMeasuresFilter filter, Option<String> pointId, long jobExecutionId) {
        long start = ((DateTime)filter.startDate().get()).withTimeAtStartOfDay().getMillis();
        long end = DateUtil$.MODULE$.setMaxDay((DateTime)filter.endDate().get()).getMillis();
        String point = (String)pointId.map((Function1 & Serializable)p -> new StringBuilder(9).append("&pointId=").append((String)p).toString()).getOrElse((Function0 & Serializable)() -> "");
        String url = new StringBuilder(83).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo.aquadb.fr")).append("/data/weatherMeasures/obs?startDate=").append(start).append("&endDate=").append(end).append("&dailyProduct=").append(filter.dailyObsProduct()).append("&hourlyProduct=").append(filter.hourlyObsProduct()).append("&apiMode=").append(filter.apiMode()).append(point).toString();
        Try try_ = (Try)Await$.MODULE$.result(WSUtil$.MODULE$.simpleGetWithAuthTry(url, WMJson$.MODULE$.readSeq(), this.ws), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "error during Obs call", (String)pointId.getOrElse((Function0 & Serializable)() -> ""), this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), err.getMessage(), (String)pointId.getOrElse((Function0 & Serializable)() -> ""), this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(13).append("failed url : ").append(url).toString(), (String)pointId.getOrElse((Function0 & Serializable)() -> ""), this.JobLogUtil.log$default$5());
            this.LogUtil.printError(err);
            throw err;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq res = (Seq)success.value();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(36).append("Obs call succeed : ").append(res.length()).append(" measures fetched").toString(), (String)pointId.getOrElse((Function0 & Serializable)() -> ""), this.JobLogUtil.log$default$5());
            return res;
        }
        throw new MatchError((Object)try_);
    }

    public Seq<WMJson> getObs(WeatherMeasuresFilter filter, Option<String> pointId, long jobExecutionId) {
        long start = new DateTime().minusDays(BoxesRunTime.unboxToInt((Object)filter.obsDays().get())).getMillis();
        String point = (String)pointId.map((Function1 & Serializable)p -> new StringBuilder(9).append("&pointId=").append((String)p).toString()).getOrElse((Function0 & Serializable)() -> "");
        String url = new StringBuilder(83).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo.aquadb.fr")).append("/data/weatherMeasures/obs?startDate=").append(start).append("&endDate=").append(new DateTime().getMillis()).append("&dailyProduct=").append(filter.dailyObsProduct()).append("&hourlyProduct=").append(filter.hourlyObsProduct()).append("&apiMode=").append(filter.apiMode()).append(point).toString();
        Try try_ = (Try)Await$.MODULE$.result(WSUtil$.MODULE$.simpleGetWithAuthTry(url, WMJson$.MODULE$.readSeq(), this.ws), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "error during Obs call", (String)pointId.getOrElse((Function0 & Serializable)() -> ""), this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), err.getMessage(), (String)pointId.getOrElse((Function0 & Serializable)() -> ""), this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(13).append("failed url : ").append(url).toString(), (String)pointId.getOrElse((Function0 & Serializable)() -> ""), this.JobLogUtil.log$default$5());
            this.LogUtil.printError(err);
            throw err;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq res = (Seq)success.value();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(36).append("Obs call succeed : ").append(res.length()).append(" measures fetched").toString(), (String)pointId.getOrElse((Function0 & Serializable)() -> ""), this.JobLogUtil.log$default$5());
            return res;
        }
        throw new MatchError((Object)try_);
    }

    public Seq<WMJson> getPrev(WeatherMeasuresFilter filter, String pointId, long jobExecutionId) {
        String url = new StringBuilder(92).append((String)scala.sys.package$.MODULE$.env().getOrElse((Object)"AQUA6BO_URL", (Function0 & Serializable)() -> "https://aqua6bo.aquadb.fr")).append("/data/weatherMeasures/prev?pointId=").append(pointId).append("&startDay=0&endDay=").append(filter.prevDays().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 9)).append("&dailyProduct=").append(filter.dailyPrevProduct()).append("&hourlyProduct=").append(filter.hourlyPrevProduct()).append("&apiMode=").append(filter.apiMode()).toString();
        Try try_ = (Try)Await$.MODULE$.result(WSUtil$.MODULE$.simpleGetWithAuthTry(url, WMJson$.MODULE$.readSeq(), this.ws), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).minutes());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), "error during Prev call", pointId, this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), err.getMessage(), pointId, this.JobLogUtil.log$default$5());
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.ERROR(), new StringBuilder(13).append("failed url : ").append(url).toString(), pointId, this.JobLogUtil.log$default$5());
            this.LogUtil.printError(err);
            throw err;
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq res = (Seq)success.value();
            this.JobLogUtil.log(jobExecutionId, JobState$.MODULE$.INFO(), new StringBuilder(37).append("Prev call succeed : ").append(res.length()).append(" measures fetched").toString(), pointId, this.JobLogUtil.log$default$5());
            return res;
        }
        throw new MatchError((Object)try_);
    }

    public Seq<GenericData> toGenericData(WeatherMeasuresFilter filter, Seq<WMJson> data) {
        return (Seq)data.flatMap((Function1 & Serializable)d -> (Seq)new .colon.colon((Object)filter.rain().map((Function1 & Serializable)id -> this.genericData(d.date(), d.rain(), BoxesRunTime.unboxToInt((Object)id))), (List)new .colon.colon((Object)filter.radiation().map((Function1 & Serializable)id -> this.genericData(d.date(), d.radiation(), BoxesRunTime.unboxToInt((Object)id))), (List)new .colon.colon((Object)filter.temperature().map((Function1 & Serializable)id -> this.genericData(d.date(), d.temperature(), BoxesRunTime.unboxToInt((Object)id))), (List)new .colon.colon((Object)filter.humidity().map((Function1 & Serializable)id -> this.genericData(d.date(), d.humidity(), BoxesRunTime.unboxToInt((Object)id))), (List)new .colon.colon((Object)filter.forecastId().map((Function1 & Serializable)id -> this.genericData(d.date(), d.forecastId(), BoxesRunTime.unboxToInt((Object)id))), (List)new .colon.colon((Object)filter.ETP().map((Function1 & Serializable)id -> this.genericData(d.date(), d.ETP(), BoxesRunTime.unboxToInt((Object)id))), (List)Nil$.MODULE$)))))).flatten(Predef$.MODULE$.$conforms()));
    }

    public GenericData genericData(DateTime d, double value, int dataType) {
        return new GenericData(d, d, (Option)new Some((Object)BoxesRunTime.boxToDouble((double)value)), dataType, GenericData$.MODULE$.$lessinit$greater$default$5(), GenericData$.MODULE$.$lessinit$greater$default$6(), GenericData$.MODULE$.$lessinit$greater$default$7(), GenericData$.MODULE$.$lessinit$greater$default$8(), GenericData$.MODULE$.$lessinit$greater$default$9(), GenericData$.MODULE$.$lessinit$greater$default$10(), GenericData$.MODULE$.$lessinit$greater$default$11(), GenericData$.MODULE$.$lessinit$greater$default$12(), GenericData$.MODULE$.$lessinit$greater$default$13(), GenericData$.MODULE$.$lessinit$greater$default$14(), GenericData$.MODULE$.$lessinit$greater$default$15());
    }

    public Seq<CalculatedMeasure> toCalculatedMeasure(WeatherMeasuresFilter filter, Seq<WMJson> data, int idStation) {
        return (Seq)data.flatMap((Function1 & Serializable)d -> (Seq)new .colon.colon((Object)filter.rain().map((Function1 & Serializable)id -> this.calculatedMeasure(d.date(), d.rain(), BoxesRunTime.unboxToInt((Object)id), idStation)), (List)new .colon.colon((Object)filter.radiation().map((Function1 & Serializable)id -> this.calculatedMeasure(d.date(), d.radiation(), BoxesRunTime.unboxToInt((Object)id), idStation)), (List)new .colon.colon((Object)filter.temperature().map((Function1 & Serializable)id -> this.calculatedMeasure(d.date(), d.temperature(), BoxesRunTime.unboxToInt((Object)id), idStation)), (List)new .colon.colon((Object)filter.humidity().map((Function1 & Serializable)id -> this.calculatedMeasure(d.date(), d.humidity(), BoxesRunTime.unboxToInt((Object)id), idStation)), (List)new .colon.colon((Object)filter.forecastId().map((Function1 & Serializable)id -> this.calculatedMeasure(d.date(), d.forecastId(), BoxesRunTime.unboxToInt((Object)id), idStation)), (List)new .colon.colon((Object)filter.ETP().map((Function1 & Serializable)id -> this.calculatedMeasure(d.date(), d.ETP(), BoxesRunTime.unboxToInt((Object)id), idStation)), (List)Nil$.MODULE$)))))).flatten(Predef$.MODULE$.$conforms()));
    }

    public CalculatedMeasure calculatedMeasure(DateTime d, double value, int dataType, int idStation) {
        int x$1 = idStation;
        DateTime x$2 = d;
        Some x$3 = new Some((Object)BoxesRunTime.boxToDouble((double)value));
        int x$4 = dataType;
        Option x$5 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$5();
        Option x$6 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$6();
        Option x$7 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$7();
        Option x$8 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$8();
        Option x$9 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$9();
        Option x$10 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$10();
        Option x$11 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = CalculatedMeasure$.MODULE$.$lessinit$greater$default$16();
        return new CalculatedMeasure(x$1, x$4, x$2, (Option)x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
    }

    public static final /* synthetic */ void $anonfun$execute$2(WeatherMeasuresController $this, JobParameters jobParameters) {
        block4: {
            long jobExecutionId = jobParameters.jobExecutionId();
            WeatherMeasuresFilter filters = (WeatherMeasuresFilter)JobUtil$.MODULE$.getFilters(jobParameters, jobExecutionId, $this.JobLogUtil, (Object)new WeatherMeasuresFilter(WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$1(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$2(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$3(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$4(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$5(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$6(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$7(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$8(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$9(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$10(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$11(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$12(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$13(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$14(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$15(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$16(), WeatherMeasuresFilter$.MODULE$.$lessinit$greater$default$17()), JobUtil$.MODULE$.getFilters$default$5(), WeatherMeasuresFilter$.MODULE$.format());
            String string = filters.apiMode();
            switch (string == null ? 0 : string.hashCode()) {
                case -925161243: {
                    if (!"Fichiers".equals(string)) break;
                    $this.importFiles(filters, jobParameters, jobExecutionId);
                    break block4;
                }
                case 2286824: {
                    if (!"JSON".equals(string)) break;
                    Seq<WMStation> stations = filters.stations();
                    stations.foreach((Function1 & Serializable)pluvio -> {
                        $this.importWMPoint(pluvio, filters, jobParameters, jobExecutionId);
                        return BoxedUnit.UNIT;
                    });
                    break block4;
                }
            }
            throw new MatchError((Object)string);
        }
    }

    public static final /* synthetic */ boolean $anonfun$importFiles$4(Option pointId$1, WMStation x$3) {
        return x$3.idWM().contains((Object)pointId$1);
    }

    public static final /* synthetic */ void $anonfun$importFiles$5(WeatherMeasuresController $this, JobParameters jobParameters$2, long jobExecutionId$2, WeatherMeasuresFilter filters$2, Seq results$1, WMStation station) {
        int res = $this.genericImportDao.importPluviometryChronic(Integer.toString(station.id()), station.code(), (String)jobParameters$2.user().getOrElse((Function0 & Serializable)() -> "ADMIN"), jobExecutionId$2, $this.toGenericData(filters$2, (Seq<WMJson>)results$1), $this.genericImportDao.importPluviometryChronic$default$6());
        if (res > 0) {
            $this.JobLogUtil.log(jobExecutionId$2, JobState$.MODULE$.SUCCESS(), new StringBuilder(20).append(res).append(" obs measures saved.").toString(), station.code(), $this.JobLogUtil.log$default$5());
            return;
        }
        $this.JobLogUtil.log(jobExecutionId$2, JobState$.MODULE$.NOTHING_TO_DO(), "Nothing new to import", station.code(), $this.JobLogUtil.log$default$5());
    }

    public static final /* synthetic */ void $anonfun$importFiles$3(WeatherMeasuresController $this, WeatherMeasuresFilter filters$2, JobParameters jobParameters$2, long jobExecutionId$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Option pointId = (Option)tuple2._1();
            Seq results = (Seq)tuple2._2();
            filters$2.stations().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)WeatherMeasuresController.$anonfun$importFiles$4(pointId, x$3))).foreach((Function1 & Serializable)station -> {
                WeatherMeasuresController.$anonfun$importFiles$5($this, jobParameters$2, jobExecutionId$2, filters$2, results, station);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Inject
    public WeatherMeasuresController(LogUtil LogUtil2, JobLogUtil JobLogUtil2, GenericImportDao genericImportDao, CalculatedMeasureDao CalculatedMeasureDao2, WSClient ws) {
        this.LogUtil = LogUtil2;
        this.JobLogUtil = JobLogUtil2;
        this.genericImportDao = genericImportDao;
        this.CalculatedMeasureDao = CalculatedMeasureDao2;
        this.ws = ws;
        Producer.$init$((Producer)this);
        Topic.$init$((Topic)this);
        Model.$init$(this);
        Statics.releaseFence();
    }
}

