/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.ScriptStyle;
import jxl.format.UnderlineStyle;
import jxl.read.biff.Record;

public class FontRecord
extends WritableRecordData
implements Font {
    private int pointHeight;
    private int colourIndex;
    private int boldWeight;
    private int scriptStyle;
    private int underlineStyle;
    private boolean italic;
    private String name;
    private boolean initialized;
    private int fontIndex;
    public static Biff7 biff7 = new Biff7();

    protected FontRecord(String fn, int ps, int bold, boolean it, int us, int ci, int ss) {
        super(Type.FONT);
        this.boldWeight = bold;
        this.underlineStyle = us;
        this.name = fn;
        this.pointHeight = ps;
        this.italic = it;
        this.scriptStyle = ss;
        this.colourIndex = ci;
        this.initialized = false;
    }

    public FontRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.pointHeight = IntegerHelper.getInt(data[0], data[1]) / 20;
        this.colourIndex = IntegerHelper.getInt(data[4], data[5]);
        this.boldWeight = IntegerHelper.getInt(data[6], data[7]);
        this.scriptStyle = IntegerHelper.getInt(data[8], data[9]);
        this.underlineStyle = data[10];
        this.initialized = false;
        if ((data[2] & 2) != 0) {
            this.italic = true;
        }
        byte numChars = data[14];
        if (data[15] == 0) {
            this.name = StringHelper.getString(data, numChars, 16);
        } else if (data[15] == 1) {
            this.name = StringHelper.getUnicodeString(data, numChars, 16);
        } else {
            System.out.println("Read non unicode font " + this.name);
        }
    }

    public FontRecord(Record t, Biff7 dummy) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.pointHeight = IntegerHelper.getInt(data[0], data[1]) / 20;
        this.colourIndex = IntegerHelper.getInt(data[4], data[5]);
        this.boldWeight = IntegerHelper.getInt(data[6], data[7]);
        this.scriptStyle = IntegerHelper.getInt(data[8], data[9]);
        this.underlineStyle = data[10];
        this.initialized = false;
        if ((data[2] & 2) != 0) {
            this.italic = true;
        }
        byte numChars = data[14];
        this.name = StringHelper.getString(data, numChars, 15);
    }

    public int getBoldWeight() {
        return this.boldWeight;
    }

    public Colour getColour() {
        return Colour.getColour(this.colourIndex);
    }

    public byte[] getData() {
        byte[] data = new byte[16 + this.name.length() * 2];
        IntegerHelper.getTwoBytes(this.pointHeight * 20, data, 0);
        if (this.italic) {
            data[2] = (byte)(data[2] | 2);
        }
        IntegerHelper.getTwoBytes(this.colourIndex, data, 4);
        IntegerHelper.getTwoBytes(this.boldWeight, data, 6);
        IntegerHelper.getTwoBytes(this.scriptStyle, data, 8);
        data[10] = (byte)this.underlineStyle;
        data[11] = 0;
        data[12] = 0;
        data[13] = 0;
        data[14] = (byte)this.name.length();
        data[15] = 1;
        StringHelper.getUnicodeBytes(this.name, data, 16);
        return data;
    }

    public final int getFontIndex() {
        return this.fontIndex;
    }

    public String getName() {
        return this.name;
    }

    public int getPointSize() {
        return this.pointHeight;
    }

    public ScriptStyle getScriptStyle() {
        return ScriptStyle.getStyle(this.scriptStyle);
    }

    public UnderlineStyle getUnderlineStyle() {
        return UnderlineStyle.getStyle(this.underlineStyle);
    }

    public final void initialize(int pos) {
        this.fontIndex = pos;
        this.initialized = true;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public boolean isItalic() {
        return this.italic;
    }

    protected void setFontBoldStyle(int bs) {
        Assert.verify(this.initialized ^ true);
        this.boldWeight = bs;
    }

    protected void setFontColour(int c) {
        Assert.verify(this.initialized ^ true);
        this.colourIndex = c;
    }

    protected void setFontItalic(boolean i) {
        Assert.verify(this.initialized ^ true);
        this.italic = i;
    }

    protected void setFontPointSize(int ps) {
        Assert.verify(this.initialized ^ true);
        this.pointHeight = ps;
    }

    protected void setFontScriptStyle(int ss) {
        Assert.verify(this.initialized ^ true);
        this.scriptStyle = ss;
    }

    protected void setFontUnderlineStyle(int us) {
        Assert.verify(this.initialized ^ true);
        this.underlineStyle = us;
    }

    public final void uninitialize() {
        this.initialized = false;
    }

    private static class Biff7 {
        Biff7() {
        }
    }
}

