/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Assert;
import java.util.Stack;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Function;
import jxl.biff.formula.Operator;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class BuiltInFunction
extends Operator
implements ParsedThing {
    private Function function;

    byte[] getBytes() {
        ParseItem[] operands = this.getOperands();
        byte[] data = new byte[]{};
        int i = 0;
        while (i < operands.length) {
            byte[] opdata = operands[i].getBytes();
            byte[] newdata = new byte[data.length + opdata.length];
            System.arraycopy(data, 0, newdata, 0, data.length);
            System.arraycopy(opdata, 0, newdata, data.length, opdata.length);
            data = newdata;
            ++i;
        }
        byte[] newdata = new byte[data.length + 3];
        System.arraycopy(data, 0, newdata, 0, data.length);
        newdata[data.length] = Token.FUNCTION.getCode();
        IntegerHelper.getTwoBytes(this.function.code, newdata, data.length + 1);
        return newdata;
    }

    public void getOperands(Stack s) {
        int i = 0;
        while (i < this.function.numArgs) {
            ParseItem pi = (ParseItem)s.pop();
            this.add(pi);
            ++i;
        }
    }

    public void getString(StringBuffer buf) {
        buf.append(this.function.string);
        buf.append('(');
        if (this.function.numArgs > 0) {
            ParseItem[] operands = this.getOperands();
            operands[0].getString(buf);
            int i = 1;
            while (i < this.function.numArgs) {
                buf.append(',');
                operands[i].getString(buf);
                ++i;
            }
        }
        buf.append(')');
    }

    public int read(byte[] data, int pos) {
        int index = IntegerHelper.getInt(data[pos], data[pos + 1]);
        this.function = Function.getFunction(index);
        Assert.verify(this.function != Function.UNKNOWN, "function code " + index);
        return 2;
    }
}

