/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import jxl.Cell;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.CellReferenceHelper;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class CellReference3d
extends Operand
implements ParsedThing {
    private boolean columnRelative;
    private boolean rowRelative;
    private int column;
    private int row;
    private Cell relativeTo;
    private int sheet;
    private ExternalSheet workbook;

    public CellReference3d(Cell rt, ExternalSheet w) {
        this.relativeTo = rt;
        this.workbook = w;
    }

    byte[] getBytes() {
        byte[] data = new byte[7];
        data[0] = Token.REF3D.getCode();
        IntegerHelper.getTwoBytes(this.sheet, data, 1);
        IntegerHelper.getTwoBytes(this.row, data, 3);
        IntegerHelper.getTwoBytes(this.column, data, 5);
        return data;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public void getString(StringBuffer buf) {
        CellReferenceHelper.getCellReference(this.sheet, this.column, this.row, this.workbook, buf);
    }

    public int read(byte[] data, int pos) {
        this.sheet = IntegerHelper.getInt(data[pos], data[pos + 1]);
        this.row = IntegerHelper.getInt(data[pos + 2], data[pos + 3]);
        int columnMask = IntegerHelper.getInt(data[pos + 4], data[pos + 5]);
        this.column = columnMask & 0xFF;
        this.columnRelative = (columnMask & 0x4000) != 0;
        this.rowRelative = (columnMask & 0x8000) != 0;
        return 6;
    }
}

