/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

public class CSV {
    public CSV(Workbook w, OutputStream out, String encoding) throws IOException {
        if (encoding == null || !encoding.equals("UnicodeBig")) {
            encoding = "UTF8";
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter(out, encoding);
            BufferedWriter bw = new BufferedWriter(osw);
            int sheet = 0;
            while (sheet < w.getNumberOfSheets()) {
                Sheet s = w.getSheet(sheet);
                bw.write(s.getName());
                bw.newLine();
                Cell[] row = null;
                int i = 0;
                while (i < s.getRows()) {
                    row = s.getRow(i);
                    if (row.length > 0) {
                        bw.write(row[0].getContents());
                        int j = 1;
                        while (j < row.length) {
                            bw.write(44);
                            bw.write(row[j].getContents());
                            ++j;
                        }
                    }
                    bw.newLine();
                    ++i;
                }
                ++sheet;
            }
            bw.flush();
            bw.close();
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.toString());
        }
    }
}

