/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import jxl.CellType;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.UnderlineStyle;
import jxl.read.biff.BiffException;
import jxl.write.DateFormat;
import jxl.write.DateFormats;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class ReadWrite {
    private File inputWorkbook;
    private File outputWorkbook;

    public ReadWrite(String input, String output) {
        this.inputWorkbook = new File(input);
        this.outputWorkbook = new File(output);
        System.out.println("Input file:  " + input);
        System.out.println("Output file:  " + output);
    }

    private void modify(WritableWorkbook w) {
        Number n;
        System.out.println("Modifying...");
        WritableSheet sheet = w.getSheet("modified");
        WritableCell cell = sheet.getWritableCell(1, 3);
        WritableFont bold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat cf = new WritableCellFormat(bold);
        cell.setCellFormat(cf);
        cell = sheet.getWritableCell(1, 4);
        WritableFont underline = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.SINGLE);
        cf = new WritableCellFormat(underline);
        cell.setCellFormat(cf);
        cell = sheet.getWritableCell(1, 5);
        WritableFont tenpoint = new WritableFont(WritableFont.ARIAL, 10);
        cf = new WritableCellFormat(tenpoint);
        cell.setCellFormat(cf);
        cell = sheet.getWritableCell(1, 6);
        if (cell.getType() == CellType.LABEL) {
            Label lc = (Label)cell;
            lc.setString(String.valueOf(lc.getString()) + " - mod");
        }
        cell = sheet.getWritableCell(1, 9);
        NumberFormat sevendps = new NumberFormat("#.0000000");
        cf = new WritableCellFormat(sevendps);
        cell.setCellFormat(cf);
        cell = sheet.getWritableCell(1, 10);
        NumberFormat exp4 = new NumberFormat("0.####E0");
        cf = new WritableCellFormat(exp4);
        cell.setCellFormat(cf);
        cell = sheet.getWritableCell(1, 11);
        cell.setCellFormat(WritableWorkbook.NORMAL_STYLE);
        cell = sheet.getWritableCell(1, 12);
        if (cell.getType() == CellType.NUMBER) {
            n = (Number)cell;
            n.setValue(42.0);
        }
        if ((cell = sheet.getWritableCell(1, 13)).getType() == CellType.NUMBER) {
            n = (Number)cell;
            n.setValue(n.getValue() + 0.1);
        }
        cell = sheet.getWritableCell(1, 16);
        DateFormat df = new DateFormat("dd MMM yyyy HH:mm:ss");
        cf = new WritableCellFormat(df);
        cell.setCellFormat(cf);
        cell = sheet.getWritableCell(1, 17);
        cf = new WritableCellFormat(DateFormats.FORMAT9);
        cell.setCellFormat(cf);
        cell = sheet.getWritableCell(1, 18);
        if (cell.getType() == CellType.DATE) {
            DateTime dt = (DateTime)cell;
            Calendar cal = Calendar.getInstance();
            TimeZone tz = TimeZone.getTimeZone("GMT");
            cal.setTimeZone(tz);
            cal.set(1998, 1, 18, 11, 23, 28);
            Date d = cal.getTime();
            dt.setDate(d);
        }
        if ((cell = sheet.getWritableCell(1, 22)).getType() == CellType.NUMBER) {
            Number n2 = (Number)cell;
            n2.setValue(6.8);
        }
        if ((cell = sheet.getWritableCell(1, 29)).getType() == CellType.LABEL) {
            Label l = (Label)cell;
            l.setString("Modified string contents");
        }
        sheet.insertRow(34);
        sheet.removeRow(38);
        sheet.insertColumn(9);
        sheet.removeColumn(11);
    }

    public void readWrite() throws IOException, BiffException {
        System.out.println("Reading...");
        Workbook w1 = Workbook.getWorkbook(this.inputWorkbook);
        Sheet s = w1.getSheet(0);
        System.out.println("Copying...");
        WritableWorkbook w2 = Workbook.createWorkbook(this.outputWorkbook, w1);
        if (this.inputWorkbook.getName().equals("jxlrwtest.xls")) {
            this.modify(w2);
        }
        w2.write();
        w2.close();
        System.out.println("Done");
    }
}

