/*
 * Decompiled with CFR 0.152.
 */
package jxl.format;

public class Pattern {
    private int value;
    private String string;
    private static Pattern[] patterns = new Pattern[0];
    public static final Pattern SOLID = new Pattern(1024, "Solid");
    public static final Pattern NONE = new Pattern(0, "None");
    public static final Pattern GRAY_75 = new Pattern(3072, "Gray 75%");
    public static final Pattern GRAY_50 = new Pattern(2048, "Gray 50%");
    public static final Pattern GRAY_25 = new Pattern(4096, "Gray 25%");

    protected Pattern(int val, String s) {
        this.value = val;
        this.string = s;
        Pattern[] oldcols = patterns;
        patterns = new Pattern[oldcols.length + 1];
        System.arraycopy(oldcols, 0, patterns, 0, oldcols.length);
        Pattern.patterns[oldcols.length] = this;
    }

    public String getDescription() {
        return this.string;
    }

    public static Pattern getPattern(int val) {
        int i = 0;
        while (i < patterns.length) {
            if (patterns[i].getValue() == val) {
                return patterns[i];
            }
            ++i;
        }
        return NONE;
    }

    public int getValue() {
        return this.value;
    }
}

