/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import jxl.BooleanCell;
import jxl.BooleanFormulaCell;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.CellValue;
import jxl.read.biff.Record;

class BooleanFormulaRecord
extends CellValue
implements BooleanCell,
FormulaData,
BooleanFormulaCell {
    private boolean value;
    private ExternalSheet externalSheet;
    private String formulaString;
    private byte[] data;

    public BooleanFormulaRecord(Record t, FormattingRecords fr, ExternalSheet es) {
        super(t, fr);
        this.externalSheet = es;
        this.value = false;
        this.data = this.getRecord().getData();
        Assert.verify(this.data[6] != 2);
        this.value = this.data[8] == 1;
    }

    public String getContents() {
        return new Boolean(this.value).toString();
    }

    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] tokens = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, tokens, 0, tokens.length);
            FormulaParser fp = new FormulaParser(tokens, this, this.externalSheet);
            fp.parse();
            this.formulaString = fp.getFormula();
        }
        return this.formulaString;
    }

    public byte[] getFormulaData() {
        return this.data;
    }

    public CellType getType() {
        return CellType.BOOLEAN_FORMULA;
    }

    public boolean getValue() {
        return this.value;
    }
}

