/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.Cell;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.XFRecord;
import jxl.format.CellFormat;
import jxl.read.biff.Record;

public abstract class CellValue
extends RecordData
implements Cell {
    private int row;
    private int column;
    private int xfIndex;
    private FormattingRecords formattingRecords;
    private boolean initialized;
    private XFRecord format;

    protected CellValue(Record t, FormattingRecords fr) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.row = IntegerHelper.getInt(data[0], data[1]);
        this.column = IntegerHelper.getInt(data[2], data[3]);
        this.xfIndex = IntegerHelper.getInt(data[4], data[5]);
        this.formattingRecords = fr;
        this.initialized = false;
    }

    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.format = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.format;
    }

    public final int getColumn() {
        return this.column;
    }

    public abstract String getContents();

    public final int getRow() {
        return this.row;
    }

    public abstract CellType getType();

    public final int getXFIndex() {
        return this.xfIndex;
    }
}

