/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.BaseCompoundFile;
import jxl.biff.IntegerHelper;
import jxl.read.biff.BiffException;

final class CompoundFile
extends BaseCompoundFile {
    private byte[] data;
    private int numBigBlockDepotBlocks;
    private int sbdStartBlock;
    private int rootStartBlock;
    private int extensionBlock;
    private int numExtensionBlocks;
    private byte[] rootEntry;
    private int[] bigBlockChain;
    private int[] smallBlockChain;
    private int[] bigBlockDepotBlocks;
    private ArrayList propertySets;

    public CompoundFile(byte[] d) throws BiffException {
        this.data = d;
        int i = 0;
        while (i < BaseCompoundFile.identifier.length) {
            if (this.data[i] != BaseCompoundFile.identifier[i]) {
                throw new BiffException(BiffException.unrecognizedOLEFile);
            }
            ++i;
        }
        this.propertySets = new ArrayList();
        this.numBigBlockDepotBlocks = IntegerHelper.getInt(this.data[BaseCompoundFile.NUM_BIG_BLOCK_DEPOT_BLOCKS_POS], this.data[BaseCompoundFile.NUM_BIG_BLOCK_DEPOT_BLOCKS_POS + 1], this.data[BaseCompoundFile.NUM_BIG_BLOCK_DEPOT_BLOCKS_POS + 2], this.data[BaseCompoundFile.NUM_BIG_BLOCK_DEPOT_BLOCKS_POS + 3]);
        this.sbdStartBlock = IntegerHelper.getInt(this.data[BaseCompoundFile.SMALL_BLOCK_DEPOT_BLOCK_POS], this.data[BaseCompoundFile.SMALL_BLOCK_DEPOT_BLOCK_POS + 1], this.data[BaseCompoundFile.SMALL_BLOCK_DEPOT_BLOCK_POS + 2], this.data[BaseCompoundFile.SMALL_BLOCK_DEPOT_BLOCK_POS + 3]);
        this.rootStartBlock = IntegerHelper.getInt(this.data[BaseCompoundFile.ROOT_START_BLOCK_POS], this.data[BaseCompoundFile.ROOT_START_BLOCK_POS + 1], this.data[BaseCompoundFile.ROOT_START_BLOCK_POS + 2], this.data[BaseCompoundFile.ROOT_START_BLOCK_POS + 3]);
        this.extensionBlock = IntegerHelper.getInt(this.data[BaseCompoundFile.EXTENSION_BLOCK_POS], this.data[BaseCompoundFile.EXTENSION_BLOCK_POS + 1], this.data[BaseCompoundFile.EXTENSION_BLOCK_POS + 2], this.data[BaseCompoundFile.EXTENSION_BLOCK_POS + 3]);
        this.numExtensionBlocks = IntegerHelper.getInt(this.data[BaseCompoundFile.NUM_EXTENSION_BLOCK_POS], this.data[BaseCompoundFile.NUM_EXTENSION_BLOCK_POS + 1], this.data[BaseCompoundFile.NUM_EXTENSION_BLOCK_POS + 2], this.data[BaseCompoundFile.NUM_EXTENSION_BLOCK_POS + 3]);
        this.bigBlockDepotBlocks = new int[this.numBigBlockDepotBlocks];
        int pos = BaseCompoundFile.BIG_BLOCK_DEPOT_BLOCKS_POS;
        int bbdBlocks = this.numBigBlockDepotBlocks;
        if (this.numExtensionBlocks != 0) {
            bbdBlocks = (BaseCompoundFile.BIG_BLOCK_SIZE - BaseCompoundFile.BIG_BLOCK_DEPOT_BLOCKS_POS) / 4;
        }
        int i2 = 0;
        while (i2 < bbdBlocks) {
            this.bigBlockDepotBlocks[i2] = IntegerHelper.getInt(d[pos], d[pos + 1], d[pos + 2], d[pos + 3]);
            pos += 4;
            ++i2;
        }
        int j = 0;
        while (j < this.numExtensionBlocks) {
            pos = (this.extensionBlock + 1) * BaseCompoundFile.BIG_BLOCK_SIZE;
            int blocksToRead = Math.min(this.numBigBlockDepotBlocks - bbdBlocks, BaseCompoundFile.BIG_BLOCK_SIZE / 4 - 1);
            int i3 = bbdBlocks;
            while (i3 < bbdBlocks + blocksToRead) {
                this.bigBlockDepotBlocks[i3] = IntegerHelper.getInt(d[pos], d[pos + 1], d[pos + 2], d[pos + 3]);
                pos += 4;
                ++i3;
            }
            if ((bbdBlocks += blocksToRead) < this.numBigBlockDepotBlocks) {
                this.extensionBlock = IntegerHelper.getInt(d[pos], d[pos + 1], d[pos + 2], d[pos + 3]);
            }
            ++j;
        }
        this.readBigBlockDepot();
        this.readSmallBlockDepot();
        this.rootEntry = this.readData(this.rootStartBlock);
        this.readPropertySets();
    }

    private byte[] getBigBlockStream(BaseCompoundFile.PropertyStorage ps) {
        int numBlocks = ps.size / BaseCompoundFile.BIG_BLOCK_SIZE;
        if (ps.size % BaseCompoundFile.BIG_BLOCK_SIZE != 0) {
            ++numBlocks;
        }
        byte[] streamData = new byte[numBlocks * BaseCompoundFile.BIG_BLOCK_SIZE];
        int block = ps.startBlock;
        int count = 0;
        int pos = 0;
        while (block != -2) {
            pos = (block + 1) * BaseCompoundFile.BIG_BLOCK_SIZE;
            System.arraycopy(this.data, pos, streamData, count * BaseCompoundFile.BIG_BLOCK_SIZE, BaseCompoundFile.BIG_BLOCK_SIZE);
            ++count;
            block = this.bigBlockChain[block];
        }
        return streamData;
    }

    private BaseCompoundFile.PropertyStorage getPropertyStorage(String name) throws BiffException {
        Iterator i = ((AbstractList)this.propertySets).iterator();
        boolean found = false;
        BaseCompoundFile.PropertyStorage ps = null;
        while (!found && i.hasNext()) {
            ps = (BaseCompoundFile.PropertyStorage)i.next();
            if (!ps.name.equalsIgnoreCase(name)) continue;
            found = true;
        }
        if (!found) {
            throw new BiffException(BiffException.streamNotFound);
        }
        return ps;
    }

    private byte[] getSmallBlockStream(BaseCompoundFile.PropertyStorage ps) throws BiffException {
        BaseCompoundFile.PropertyStorage rootps = null;
        try {
            rootps = this.getPropertyStorage("root entry");
        }
        catch (BiffException biffException) {
            rootps = (BaseCompoundFile.PropertyStorage)this.propertySets.get(0);
        }
        byte[] rootdata = this.readData(rootps.startBlock);
        byte[] data = new byte[]{};
        int block = ps.startBlock;
        boolean count = false;
        int pos = 0;
        while (block != -2) {
            byte[] olddata = data;
            data = new byte[olddata.length + BaseCompoundFile.SMALL_BLOCK_SIZE];
            System.arraycopy(olddata, 0, data, 0, olddata.length);
            pos = block * BaseCompoundFile.SMALL_BLOCK_SIZE;
            System.arraycopy(rootdata, pos, data, olddata.length, BaseCompoundFile.SMALL_BLOCK_SIZE);
            block = this.smallBlockChain[block];
        }
        return data;
    }

    public byte[] getStream(String streamName) throws BiffException {
        BaseCompoundFile.PropertyStorage ps = this.getPropertyStorage(streamName);
        if (ps.size >= BaseCompoundFile.SMALL_BLOCK_THRESHOLD || streamName.equalsIgnoreCase("root entry")) {
            return this.getBigBlockStream(ps);
        }
        return this.getSmallBlockStream(ps);
    }

    private void readBigBlockDepot() {
        int pos = 0;
        int index = 0;
        this.bigBlockChain = new int[this.numBigBlockDepotBlocks * BaseCompoundFile.BIG_BLOCK_SIZE / 4];
        int i = 0;
        while (i < this.numBigBlockDepotBlocks) {
            pos = (this.bigBlockDepotBlocks[i] + 1) * BaseCompoundFile.BIG_BLOCK_SIZE;
            int j = 0;
            while (j < BaseCompoundFile.BIG_BLOCK_SIZE / 4) {
                this.bigBlockChain[index] = IntegerHelper.getInt(this.data[pos], this.data[pos + 1], this.data[pos + 2], this.data[pos + 3]);
                pos += 4;
                ++index;
                ++j;
            }
            ++i;
        }
    }

    private byte[] readData(int bl) {
        int block = bl;
        int pos = 0;
        byte[] entry = new byte[]{};
        while (block != -2) {
            byte[] oldEntry = entry;
            entry = new byte[oldEntry.length + BaseCompoundFile.BIG_BLOCK_SIZE];
            System.arraycopy(oldEntry, 0, entry, 0, oldEntry.length);
            pos = (block + 1) * BaseCompoundFile.BIG_BLOCK_SIZE;
            System.arraycopy(this.data, pos, entry, oldEntry.length, BaseCompoundFile.BIG_BLOCK_SIZE);
            block = this.bigBlockChain[block];
        }
        return entry;
    }

    private void readPropertySets() {
        int offset = 0;
        byte[] d = null;
        while (offset < this.rootEntry.length) {
            d = new byte[BaseCompoundFile.PROPERTY_STORAGE_BLOCK_SIZE];
            System.arraycopy(this.rootEntry, offset, d, 0, d.length);
            CompoundFile compoundFile = this;
            compoundFile.getClass();
            BaseCompoundFile.PropertyStorage ps = (BaseCompoundFile)compoundFile.new BaseCompoundFile.PropertyStorage(d);
            this.propertySets.add(ps);
            offset += BaseCompoundFile.PROPERTY_STORAGE_BLOCK_SIZE;
        }
    }

    private void readSmallBlockDepot() {
        int pos = 0;
        int index = 0;
        int sbdBlock = this.sbdStartBlock;
        this.smallBlockChain = new int[0];
        while (sbdBlock != -2) {
            int[] oldChain = this.smallBlockChain;
            this.smallBlockChain = new int[this.smallBlockChain.length + BaseCompoundFile.BIG_BLOCK_SIZE / 4];
            System.arraycopy(oldChain, 0, this.smallBlockChain, 0, oldChain.length);
            pos = (sbdBlock + 1) * BaseCompoundFile.BIG_BLOCK_SIZE;
            int j = 0;
            while (j < BaseCompoundFile.BIG_BLOCK_SIZE / 4) {
                this.smallBlockChain[index] = IntegerHelper.getInt(this.data[pos], this.data[pos + 1], this.data[pos + 2], this.data[pos + 3]);
                pos += 4;
                ++index;
                ++j;
            }
            sbdBlock = this.bigBlockChain[sbdBlock];
        }
    }
}

