/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.read.biff.Record;

public class ExternalSheetRecord
extends RecordData {
    public static Biff7 biff7 = new Biff7();
    private XTI[] xtiArray;

    ExternalSheetRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        int numxtis = IntegerHelper.getInt(data[0], data[1]);
        this.xtiArray = new XTI[numxtis];
        int pos = 2;
        int i = 0;
        while (i < numxtis) {
            int s = IntegerHelper.getInt(data[pos], data[pos + 1]);
            int f = IntegerHelper.getInt(data[pos + 2], data[pos + 3]);
            int l = IntegerHelper.getInt(data[pos + 4], data[pos + 5]);
            this.xtiArray[i] = new XTI(s, f, l);
            pos += 6;
            ++i;
        }
    }

    ExternalSheetRecord(Record t, Biff7 dummy) {
        super(t);
    }

    public byte[] getData() {
        return this.getRecord().getData();
    }

    int getFirstTabIndex(int index) {
        return this.xtiArray[index].firstTab;
    }

    int getLastTabIndex(int index) {
        return this.xtiArray[index].lastTab;
    }

    int getSupbookIndex(int index) {
        return this.xtiArray[index].supbookIndex;
    }

    private static class Biff7 {
        Biff7() {
        }
    }

    private static class XTI {
        int supbookIndex;
        int firstTab;
        int lastTab;

        XTI(int s, int f, int l) {
            this.supbookIndex = s;
            this.firstTab = f;
            this.lastTab = l;
        }
    }
}

