/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import jxl.CellType;
import jxl.biff.DoubleHelper;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.ExternalSheet;
import jxl.read.biff.BooleanFormulaRecord;
import jxl.read.biff.CellValue;
import jxl.read.biff.ErrorFormulaRecord;
import jxl.read.biff.File;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.Record;
import jxl.read.biff.SharedNumberFormulaRecord;
import jxl.read.biff.SharedStringFormulaRecord;
import jxl.read.biff.StringFormulaRecord;

class FormulaRecord
extends CellValue {
    private CellValue formula;
    private boolean shared;

    public FormulaRecord(Record t, File excelFile, FormattingRecords fr, ExternalSheet es) {
        super(t, fr);
        byte[] data = this.getRecord().getData();
        this.shared = false;
        int grbit = IntegerHelper.getInt(data[14], data[15]);
        if ((grbit & 8) != 0) {
            this.shared = true;
            if (data[6] == 0 && data[12] == -1 && data[13] == -1) {
                this.formula = new SharedStringFormulaRecord(t, excelFile, fr, es);
            } else {
                double value = DoubleHelper.getIEEEDouble(data, 6);
                this.formula = new SharedNumberFormulaRecord(t, value, fr, es);
            }
            return;
        }
        this.formula = data[6] == 0 && data[12] == -1 && data[13] == -1 ? new StringFormulaRecord(t, excelFile, fr, es) : (data[6] == 1 && data[12] == -1 && data[13] == -1 ? new BooleanFormulaRecord(t, fr, es) : (data[6] == 2 && data[12] == -1 && data[13] == -1 ? new ErrorFormulaRecord(t, fr, es) : new NumberFormulaRecord(t, fr, es)));
    }

    public String getContents() {
        Assert.verify(false);
        return "";
    }

    final CellValue getFormula() {
        return this.formula;
    }

    public CellType getType() {
        Assert.verify(false);
        return CellType.EMPTY;
    }

    final boolean isShared() {
        return this.shared;
    }
}

