/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.util.ArrayList;
import jxl.Cell;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.ExternalSheet;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.Record;

class SharedFormulaRecord {
    private int firstRow;
    private int lastRow;
    private int firstCol;
    private int lastCol;
    private BaseSharedFormulaRecord templateFormula;
    private ArrayList formulas;
    private byte[] tokens;
    private ExternalSheet externalSheet;

    public SharedFormulaRecord(Record t, BaseSharedFormulaRecord fr, ExternalSheet es) {
        this.externalSheet = es;
        byte[] data = t.getData();
        this.firstRow = IntegerHelper.getInt(data[0], data[1]);
        this.lastRow = IntegerHelper.getInt(data[2], data[3]);
        this.firstCol = data[4];
        this.lastCol = data[5];
        this.formulas = new ArrayList();
        this.templateFormula = fr;
        this.tokens = new byte[data.length - 10];
        System.arraycopy(data, 10, this.tokens, 0, this.tokens.length);
    }

    public boolean add(BaseSharedFormulaRecord fr) {
        if (fr.getRow() >= this.firstRow && fr.getRow() <= this.lastRow && fr.getColumn() >= this.firstCol && fr.getColumn() <= this.lastCol) {
            this.formulas.add(fr);
            return true;
        }
        return false;
    }

    Cell[] getFormulas(FormattingRecords fr) {
        Cell[] sfs = new Cell[this.formulas.size() + 1];
        this.templateFormula.setTokens(this.tokens);
        sfs[0] = this.templateFormula;
        BaseSharedFormulaRecord f = null;
        int i = 0;
        while (i < this.formulas.size()) {
            f = (BaseSharedFormulaRecord)this.formulas.get(i);
            f.setTokens(this.tokens);
            sfs[i + 1] = f;
            ++i;
        }
        return sfs;
    }
}

