/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.NumberFormulaCell;
import jxl.biff.DoubleHelper;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.Record;

public class SharedNumberFormulaRecord
extends BaseSharedFormulaRecord
implements NumberCell,
FormulaData,
NumberFormulaCell {
    private double value;
    private NumberFormat format;
    private FormattingRecords formattingRecords;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    public SharedNumberFormulaRecord(Record t, double v, FormattingRecords fr, ExternalSheet es) {
        super(t, fr, es);
        this.value = v;
        this.format = defaultFormat;
    }

    public String getContents() {
        return this.format.format(this.value);
    }

    public byte[] getFormulaData() throws FormulaException {
        FormulaParser fp = new FormulaParser(this.getTokens(), this, this.getExternalSheet());
        fp.parse();
        byte[] rpnTokens = fp.getBytes();
        byte[] data = new byte[rpnTokens.length + 22];
        IntegerHelper.getTwoBytes(this.getRow(), data, 0);
        IntegerHelper.getTwoBytes(this.getColumn(), data, 2);
        IntegerHelper.getTwoBytes(this.getXFIndex(), data, 4);
        DoubleHelper.getIEEEBytes(this.value, data, 6);
        System.arraycopy(rpnTokens, 0, data, 22, rpnTokens.length);
        IntegerHelper.getTwoBytes(rpnTokens.length, data, 20);
        return data;
    }

    public CellType getType() {
        return CellType.NUMBER_FORMULA;
    }

    public double getValue() {
        return this.value;
    }

    final void setNumberFormat(NumberFormat f) {
        if (f != null) {
            this.format = f;
        }
    }
}

