/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.LabelCell;
import jxl.Sheet;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.RecordData;
import jxl.biff.Type;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.BiffException;
import jxl.read.biff.BlankCell;
import jxl.read.biff.BooleanRecord;
import jxl.read.biff.CellValue;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.DateRecord;
import jxl.read.biff.DimensionRecord;
import jxl.read.biff.ErrorRecord;
import jxl.read.biff.File;
import jxl.read.biff.FormulaRecord;
import jxl.read.biff.LabelRecord;
import jxl.read.biff.LabelSSTRecord;
import jxl.read.biff.MulBlankCell;
import jxl.read.biff.MulBlankRecord;
import jxl.read.biff.MulRKRecord;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.NumberRecord;
import jxl.read.biff.NumberValue;
import jxl.read.biff.RKHelper;
import jxl.read.biff.RKRecord;
import jxl.read.biff.RStringRecord;
import jxl.read.biff.Record;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SharedFormulaRecord;
import jxl.read.biff.WorkbookParser;

public class SheetImpl
implements Sheet {
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord sheetBof;
    private BOFRecord workbookBof;
    private FormattingRecords formattingRecords;
    private String name;
    private boolean hidden;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private int startPosition;
    private ColumnInfoRecord[] columnInfos;
    private ArrayList columnInfosArray;
    private ArrayList sharedFormulas;
    private boolean columnInfosInitialized;
    private boolean nineteenFour;
    private WorkbookParser workbook;

    SheetImpl(File f, SSTRecord sst, FormattingRecords fr, BOFRecord sb, BOFRecord wb, boolean nf, WorkbookParser wp) throws BiffException {
        this.excelFile = f;
        this.sharedStrings = sst;
        this.formattingRecords = fr;
        this.sheetBof = sb;
        this.workbookBof = wb;
        this.columnInfosArray = new ArrayList();
        this.sharedFormulas = new ArrayList();
        this.columnInfosInitialized = false;
        this.nineteenFour = nf;
        this.workbook = wp;
        this.startPosition = f.getPos();
        Record r = null;
        int bofs = 1;
        while (bofs >= 1) {
            r = f.next();
            if (r.getCode() == Type.EOF.value) {
                --bofs;
            }
            if (r.getCode() != Type.BOF.value) continue;
            ++bofs;
        }
    }

    private void addCell(Cell cell) {
        Assert.verify(this.cells[cell.getRow()][cell.getColumn()] == null);
        this.cells[cell.getRow()][cell.getColumn()] = cell;
    }

    private void addToSharedFormulas(BaseSharedFormulaRecord fr) {
        Iterator i = ((AbstractList)this.sharedFormulas).iterator();
        boolean added = false;
        SharedFormulaRecord sfr = null;
        while (i.hasNext() && !added) {
            sfr = (SharedFormulaRecord)i.next();
            added = sfr.add(fr);
        }
    }

    final void clear() {
        this.cells = null;
        System.gc();
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        int i = 0;
        while (i < this.getRows() && !found) {
            Cell[] row = this.getRow(i);
            int j = 0;
            while (j < row.length && !found) {
                if (row[j].getContents().equals(contents)) {
                    cell = row[j];
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        int i = 0;
        while (i < this.getRows() && !found) {
            Cell[] row = this.getRow(i);
            int j = 0;
            while (j < row.length && !found) {
                if ((row[j].getType() == CellType.LABEL || row[j].getType() == CellType.STRING_FORMULA) && row[j].getContents().equals(contents)) {
                    cell = (LabelCell)row[j];
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public Cell getCell(int column, int row) {
        Cell c;
        if (this.cells == null) {
            this.readSheet();
        }
        if ((c = this.cells[row][column]) == null) {
            c = new EmptyCell(column, row);
            this.addCell(c);
        }
        return c;
    }

    public Cell[] getColumn(int col) {
        if (this.cells == null) {
            this.readSheet();
        }
        boolean found = false;
        int row = this.numRows - 1;
        while (row >= 0 && !found) {
            if (this.cells[row][col] != null) {
                found = true;
                continue;
            }
            --row;
        }
        Cell[] cells = new Cell[row + 1];
        int i = 0;
        while (i <= row) {
            cells[i] = this.getCell(col, i);
            ++i;
        }
        return cells;
    }

    public ColumnInfoRecord getColumnInfo(int col) {
        if (!this.columnInfosInitialized) {
            Iterator i = ((AbstractList)this.columnInfosArray).iterator();
            ColumnInfoRecord cir = null;
            while (i.hasNext()) {
                cir = (ColumnInfoRecord)i.next();
                int startcol = Math.max(0, cir.getStartColumn());
                int endcol = Math.min(this.columnInfos.length - 1, cir.getEndColumn());
                int c = startcol;
                while (c <= endcol) {
                    this.columnInfos[c] = cir;
                    ++c;
                }
            }
            this.columnInfosInitialized = true;
        }
        return this.columnInfos[col];
    }

    public int getColumns() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numCols;
    }

    public String getName() {
        return this.name;
    }

    public Cell[] getRow(int row) {
        if (this.cells == null) {
            this.readSheet();
        }
        boolean found = false;
        int col = this.numCols - 1;
        while (col >= 0 && !found) {
            if (this.cells[row][col] != null) {
                found = true;
                continue;
            }
            --col;
        }
        Cell[] cells = new Cell[col + 1];
        int i = 0;
        while (i <= col) {
            cells[i] = this.getCell(i, row);
            ++i;
        }
        return cells;
    }

    public int getRows() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numRows;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    final void readSheet() {
        if (!this.sheetBof.isWorksheet()) {
            this.numRows = 0;
            this.numCols = 0;
            this.cells = new Cell[0][0];
            return;
        }
        Record r = null;
        BaseSharedFormulaRecord sharedFormula = null;
        boolean cont = true;
        this.excelFile.setPos(this.startPosition);
        while (cont) {
            CellValue lr;
            RecordData br;
            int i;
            DateRecord dc;
            r = this.excelFile.next();
            if (r.getType() == Type.DIMENSION) {
                DimensionRecord dr = null;
                dr = this.workbookBof.isBiff8() ? new DimensionRecord(r) : new DimensionRecord(r, DimensionRecord.biff7);
                this.numRows = dr.getNumberOfRows();
                this.numCols = dr.getNumberOfColumns();
                this.cells = new Cell[this.numRows][this.numCols];
                this.columnInfos = new ColumnInfoRecord[this.numCols];
            }
            if (r.getType() == Type.LABELSST) {
                LabelSSTRecord label = new LabelSSTRecord(r, this.sharedStrings, this.formattingRecords);
                this.addCell(label);
            }
            if (r.getType() == Type.RK || r.getType() == Type.RK2) {
                RKRecord rkr = new RKRecord(r, this.formattingRecords);
                if (this.formattingRecords.isDate(rkr.getXFIndex())) {
                    dc = new DateRecord(rkr, rkr.getXFIndex(), this.formattingRecords, this.nineteenFour);
                    this.addCell(dc);
                } else {
                    this.addCell(rkr);
                }
            }
            if (r.getType() == Type.MULRK) {
                MulRKRecord mulrk = new MulRKRecord(r);
                int num = mulrk.getNumberOfColumns();
                int ixf = 0;
                i = 0;
                while (i < num) {
                    ixf = mulrk.getXFIndex(i);
                    NumberValue nv = new NumberValue(mulrk.getRow(), mulrk.getFirstColumn() + i, RKHelper.getDouble(mulrk.getRKNumber(i)), ixf, this.formattingRecords);
                    if (this.formattingRecords.isDate(ixf)) {
                        DateRecord dc2 = new DateRecord(nv, ixf, this.formattingRecords, this.nineteenFour);
                        this.addCell(dc2);
                    } else {
                        nv.setNumberFormat(this.formattingRecords.getNumberFormat(ixf));
                        this.addCell(nv);
                    }
                    ++i;
                }
            }
            r.getType();
            if (r.getType() == Type.NUMBER) {
                NumberRecord nr = new NumberRecord(r, this.formattingRecords);
                if (this.formattingRecords.isDate(nr.getXFIndex())) {
                    dc = new DateRecord(nr, nr.getXFIndex(), this.formattingRecords, this.nineteenFour);
                    this.addCell(dc);
                } else {
                    this.addCell(nr);
                }
            }
            if (r.getType() == Type.BOOLERR) {
                br = new BooleanRecord(r, this.formattingRecords);
                if (((BooleanRecord)br).isError()) {
                    ErrorRecord er = new ErrorRecord(((BooleanRecord)br).getRecord(), this.formattingRecords);
                    this.addCell(er);
                } else {
                    this.addCell((Cell)((Object)br));
                }
            }
            r.getType();
            r.getType();
            if (r.getType() == Type.SHAREDFORMULA) {
                SharedFormulaRecord sfr = new SharedFormulaRecord(r, sharedFormula, this.workbook);
                this.sharedFormulas.add(sfr);
            }
            if (r.getType() == Type.FORMULA || r.getType() == Type.FORMULA2) {
                FormulaRecord fr = new FormulaRecord(r, this.excelFile, this.formattingRecords, this.workbook);
                if (fr.isShared()) {
                    sharedFormula = (BaseSharedFormulaRecord)fr.getFormula();
                    this.addToSharedFormulas(sharedFormula);
                } else {
                    NumberFormulaRecord nfr;
                    Cell cell = fr.getFormula();
                    if (fr.getFormula().getType() == CellType.NUMBER_FORMULA && this.formattingRecords.isDate((nfr = (NumberFormulaRecord)fr.getFormula()).getXFIndex())) {
                        cell = new DateRecord(nfr, nfr.getXFIndex(), this.formattingRecords, this.nineteenFour);
                    }
                    this.addCell(cell);
                }
            }
            if (r.getType() == Type.LABEL) {
                lr = null;
                lr = this.workbookBof.isBiff8() ? new LabelRecord(r, this.formattingRecords) : new LabelRecord(r, this.formattingRecords, LabelRecord.biff7);
                this.addCell(lr);
            }
            if (r.getType() == Type.RSTRING) {
                lr = null;
                Assert.verify(this.workbookBof.isBiff8() ^ true);
                lr = new RStringRecord(r, this.formattingRecords, RStringRecord.biff7);
                this.addCell(lr);
            }
            r.getType();
            if (r.getType() == Type.BLANK) {
                BlankCell bc = new BlankCell(r, this.formattingRecords);
                this.addCell(bc);
            }
            if (r.getType() == Type.MULBLANK) {
                MulBlankRecord mulblank = new MulBlankRecord(r);
                int num = mulblank.getNumberOfColumns();
                int ixf = 0;
                i = 0;
                while (i < num) {
                    ixf = mulblank.getXFIndex(i);
                    MulBlankCell mbc = new MulBlankCell(mulblank.getRow(), mulblank.getFirstColumn() + i, ixf, this.formattingRecords);
                    this.addCell(mbc);
                    ++i;
                }
            }
            if (r.getType() == Type.COLINFO) {
                ColumnInfoRecord cir = new ColumnInfoRecord(r);
                this.columnInfosArray.add(cir);
            }
            r.getType();
            r.getType();
            if (r.getType() == Type.BOF) {
                br = new BOFRecord(r);
                Assert.verify(((BOFRecord)br).isWorksheet() ^ true);
                int startpos = this.excelFile.getPos() - r.getLength() - 4;
                Record r2 = this.excelFile.next();
                while (r2.getCode() != Type.EOF.value) {
                    r2 = this.excelFile.next();
                }
            }
            if (r.getType() != Type.EOF) continue;
            cont = false;
        }
        this.excelFile.restorePos();
        Iterator i = ((AbstractList)this.sharedFormulas).iterator();
        while (i.hasNext()) {
            SharedFormulaRecord sfr = (SharedFormulaRecord)i.next();
            Cell[] sfnr = sfr.getFormulas(this.formattingRecords);
            int sf = 0;
            while (sf < sfnr.length) {
                this.addCell(sfnr[sf]);
                ++sf;
            }
        }
    }

    final void setHidden(boolean h) {
        this.hidden = h;
    }

    final void setName(String s) {
        this.name = s;
    }
}

