/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import java.io.UnsupportedEncodingException;
import jxl.CellType;
import jxl.LabelCell;
import jxl.StringFormulaCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.CellValue;
import jxl.read.biff.File;
import jxl.read.biff.Record;

class StringFormulaRecord
extends CellValue
implements LabelCell,
FormulaData,
StringFormulaCell {
    private String value;
    private ExternalSheet externalSheet;
    private String formulaString;
    private byte[] data;

    public StringFormulaRecord(Record t, File excelFile, FormattingRecords fr, ExternalSheet es) {
        super(t, fr);
        this.externalSheet = es;
        this.data = this.getRecord().getData();
        int pos = excelFile.getPos();
        Record nextRecord = excelFile.next();
        int count = 0;
        while (nextRecord.getType() != Type.STRING && count < 4) {
            nextRecord = excelFile.next();
            ++count;
        }
        Assert.verify(count < 4, " @ " + pos);
        this.readString(nextRecord.getData());
    }

    public String getContents() {
        return this.value;
    }

    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] tokens = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, tokens, 0, tokens.length);
            FormulaParser fp = new FormulaParser(tokens, this, this.externalSheet);
            fp.parse();
            this.formulaString = fp.getFormula();
        }
        return this.formulaString;
    }

    public byte[] getFormulaData() {
        return this.data;
    }

    public String getString() {
        return this.value;
    }

    public CellType getType() {
        return CellType.STRING_FORMULA;
    }

    private void readString(byte[] data) {
        try {
            boolean richString;
            int pos = 0;
            int chars = IntegerHelper.getInt(data[0], data[1]);
            byte optionFlags = data[pos += 2];
            ++pos;
            boolean extendedString = (optionFlags & 4) != 0;
            boolean bl = richString = (optionFlags & 8) != 0;
            if (richString) {
                pos += 2;
            }
            if (extendedString) {
                pos += 4;
            }
            boolean asciiEncoding = (optionFlags & 1) == 0;
            byte[] bytes = null;
            if (asciiEncoding) {
                bytes = new byte[chars];
                System.arraycopy(data, pos, bytes, 0, chars);
                pos += chars;
            } else {
                bytes = new byte[chars * 2];
                System.arraycopy(data, pos, bytes, 0, chars * 2);
                pos += bytes.length;
            }
            this.value = asciiEncoding ? new String(bytes) : new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.toString());
        }
    }
}

