/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.BooleanCell;
import jxl.CellType;
import jxl.biff.Type;
import jxl.format.CellFormat;
import jxl.write.biff.CellValue;

public class BooleanRecord
extends CellValue {
    private boolean value;

    protected BooleanRecord(int c, int r, boolean val) {
        super(Type.BOOLERR, c, r);
        this.value = val;
    }

    protected BooleanRecord(int c, int r, boolean val, CellFormat st) {
        super(Type.NUMBER, c, r, st);
        this.value = val;
    }

    protected BooleanRecord(BooleanCell nc) {
        super(Type.BOOLERR, nc);
        this.value = nc.getValue();
    }

    public String getContents() {
        return new Boolean(this.value).toString();
    }

    public byte[] getData() {
        byte[] celldata = super.getData();
        byte[] data = new byte[celldata.length + 2];
        System.arraycopy(celldata, 0, data, 0, celldata.length);
        if (this.value) {
            data[celldata.length] = 1;
        }
        return data;
    }

    public CellType getType() {
        return CellType.BOOLEAN;
    }

    public boolean getValue() {
        return this.value;
    }

    protected void setValue(boolean val) {
        this.value = val;
    }
}

