/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import jxl.Cell;
import jxl.CellType;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;
import jxl.format.CellFormat;
import jxl.write.WritableCell;
import jxl.write.WritableWorkbook;
import jxl.write.biff.SharedStrings;

public abstract class CellValue
extends WritableRecordData
implements WritableCell {
    private int row;
    private int column;
    private XFRecord format;
    private FormattingRecords formattingRecords;
    private boolean referenced;

    protected CellValue(Type t, int c, int r) {
        this(t, c, r, WritableWorkbook.NORMAL_STYLE);
    }

    protected CellValue(Type t, int c, int r, CellFormat st) {
        super(t);
        this.row = r;
        this.column = c;
        this.format = (XFRecord)st;
        this.referenced = false;
    }

    protected CellValue(Type t, Cell c) {
        this(t, c.getColumn(), c.getRow());
        this.format = (XFRecord)c.getCellFormat();
    }

    void decrementColumn() {
        --this.column;
    }

    void decrementRow() {
        --this.row;
    }

    public CellFormat getCellFormat() {
        return this.format;
    }

    public int getColumn() {
        return this.column;
    }

    public abstract String getContents();

    public byte[] getData() {
        byte[] mydata = new byte[6];
        IntegerHelper.getTwoBytes(this.row, mydata, 0);
        IntegerHelper.getTwoBytes(this.column, mydata, 2);
        IntegerHelper.getTwoBytes(this.format.getXFIndex(), mydata, 4);
        return mydata;
    }

    public int getRow() {
        return this.row;
    }

    public abstract CellType getType();

    final int getXFIndex() {
        return this.format.getXFIndex();
    }

    void incrementColumn() {
        ++this.column;
    }

    void incrementRow() {
        ++this.row;
    }

    final boolean isReferenced() {
        return this.referenced;
    }

    void setCellDetails(FormattingRecords fr, SharedStrings ss) {
        this.referenced = true;
        try {
            if (!this.format.isInitialized()) {
                fr.addStyle(this.format);
            }
            this.formattingRecords = fr;
        }
        catch (NumFormatRecordsException numFormatRecordsException) {
            System.err.println("Warning:  maximum number of format records exceeded.  Using default format");
            this.format = WritableWorkbook.NORMAL_STYLE;
        }
    }

    public void setCellFormat(CellFormat cf) {
        this.format = (XFRecord)cf;
        if (!this.referenced) {
            return;
        }
        Assert.verify(this.formattingRecords != null);
        try {
            if (!this.format.isInitialized()) {
                this.formattingRecords.addStyle(this.format);
            }
        }
        catch (NumFormatRecordsException numFormatRecordsException) {
            System.err.println("Warning:  maximum number of format records exceeded.  Using default format");
            this.format = WritableWorkbook.NORMAL_STYLE;
        }
    }
}

