/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.IOException;
import java.io.OutputStream;
import jxl.biff.BaseCompoundFile;
import jxl.biff.IntegerHelper;

final class CompoundFile
extends BaseCompoundFile {
    private OutputStream out;
    private byte[] excelData;
    private int size;
    private int requiredSize;
    private int numBigBlockDepotBlocks;
    private int numExtensionBlocks;
    private int extensionBlock;
    private int excelDataBlocks;
    private int rootStartBlock;
    private int excelDataStartBlock;
    private int bbdStartBlock;
    private int bbdPos;
    private byte[] bigBlockDepot;

    public CompoundFile(byte[] data, int l, OutputStream os) {
        this.size = l;
        this.excelData = data;
        int blocks = l / BaseCompoundFile.BIG_BLOCK_SIZE + 1;
        this.requiredSize = l < BaseCompoundFile.SMALL_BLOCK_THRESHOLD ? BaseCompoundFile.SMALL_BLOCK_THRESHOLD : blocks * BaseCompoundFile.BIG_BLOCK_SIZE;
        this.out = os;
        this.excelDataBlocks = this.requiredSize / BaseCompoundFile.BIG_BLOCK_SIZE;
        int blockChainLength = (BaseCompoundFile.BIG_BLOCK_SIZE - BaseCompoundFile.BIG_BLOCK_DEPOT_BLOCKS_POS) / 4;
        int totalBlocks = this.excelDataBlocks + 8 + 8 + 1 + 1;
        this.numBigBlockDepotBlocks = (int)Math.ceil((double)totalBlocks / (double)(BaseCompoundFile.BIG_BLOCK_SIZE / 4));
        this.numBigBlockDepotBlocks = (int)Math.ceil((double)(totalBlocks += this.numBigBlockDepotBlocks) / (double)(BaseCompoundFile.BIG_BLOCK_SIZE / 4));
        if (this.numBigBlockDepotBlocks > blockChainLength - 1) {
            this.extensionBlock = 0;
            int bbdBlocksLeft = this.numBigBlockDepotBlocks - blockChainLength + 1;
            this.numExtensionBlocks = (int)Math.ceil((double)bbdBlocksLeft / (double)(BaseCompoundFile.BIG_BLOCK_SIZE / 4 - 1));
            this.numBigBlockDepotBlocks = (int)Math.ceil((double)(totalBlocks += this.numExtensionBlocks) / (double)(BaseCompoundFile.BIG_BLOCK_SIZE / 4));
        } else {
            this.extensionBlock = -2;
            this.numExtensionBlocks = 0;
        }
        this.excelDataStartBlock = this.numExtensionBlocks;
        this.bbdStartBlock = this.excelDataStartBlock + this.excelDataBlocks + 16;
        this.rootStartBlock = this.excelDataStartBlock + this.excelDataBlocks + 16 + this.numBigBlockDepotBlocks;
    }

    private void checkBbdPos() throws IOException {
        if (this.bbdPos >= BaseCompoundFile.BIG_BLOCK_SIZE) {
            this.out.write(this.bigBlockDepot);
            this.bigBlockDepot = new byte[BaseCompoundFile.BIG_BLOCK_SIZE];
            this.bbdPos = 0;
        }
    }

    public void write() throws IOException {
        this.writeHeader();
        this.writeExcelData();
        this.writeBigBlockDepot();
        this.writePropertySets();
        this.out.flush();
        this.out.close();
    }

    private void writeBigBlockDepot() throws IOException {
        int summaryInfoBlock;
        int i;
        this.bigBlockDepot = new byte[BaseCompoundFile.BIG_BLOCK_SIZE];
        this.bbdPos = 0;
        int i2 = 0;
        while (i2 < this.numExtensionBlocks) {
            IntegerHelper.getFourBytes(-3, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
            ++i2;
        }
        int blocksToWrite = this.excelDataBlocks - 1;
        int blockNumber = this.excelDataStartBlock + 1;
        while (blocksToWrite > 0) {
            int bbdBlocks = Math.min(blocksToWrite, (BaseCompoundFile.BIG_BLOCK_SIZE - this.bbdPos) / 4);
            i = 0;
            while (i < bbdBlocks) {
                IntegerHelper.getFourBytes(blockNumber, this.bigBlockDepot, this.bbdPos);
                this.bbdPos += 4;
                ++blockNumber;
                ++i;
            }
            blocksToWrite -= bbdBlocks;
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        i = summaryInfoBlock = this.excelDataStartBlock + this.excelDataBlocks;
        while (i < summaryInfoBlock + 7) {
            IntegerHelper.getFourBytes(i + 1, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
            ++i;
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        int i3 = summaryInfoBlock + 8;
        while (i3 < summaryInfoBlock + 15) {
            IntegerHelper.getFourBytes(i3 + 1, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
            ++i3;
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        int i4 = 0;
        while (i4 < this.numBigBlockDepotBlocks) {
            IntegerHelper.getFourBytes(-3, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
            ++i4;
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        if (this.bbdPos != 0) {
            int i5 = this.bbdPos;
            while (i5 < BaseCompoundFile.BIG_BLOCK_SIZE) {
                this.bigBlockDepot[i5] = -1;
                ++i5;
            }
            this.out.write(this.bigBlockDepot);
        }
    }

    private void writeExcelData() throws IOException {
        this.out.write(this.excelData, 0, this.size);
        byte[] padding = new byte[this.requiredSize - this.size];
        this.out.write(padding);
        padding = new byte[BaseCompoundFile.SMALL_BLOCK_THRESHOLD];
        this.out.write(padding);
        this.out.write(padding);
    }

    private void writeHeader() throws IOException {
        byte[] headerBlock = new byte[BaseCompoundFile.BIG_BLOCK_SIZE];
        byte[] extensionBlockData = new byte[BaseCompoundFile.BIG_BLOCK_SIZE * this.numExtensionBlocks];
        System.arraycopy(BaseCompoundFile.identifier, 0, headerBlock, 0, BaseCompoundFile.identifier.length);
        headerBlock[24] = 62;
        headerBlock[26] = 3;
        headerBlock[28] = -2;
        headerBlock[29] = -1;
        headerBlock[30] = 9;
        headerBlock[32] = 6;
        headerBlock[57] = 16;
        IntegerHelper.getFourBytes(this.numBigBlockDepotBlocks, headerBlock, BaseCompoundFile.NUM_BIG_BLOCK_DEPOT_BLOCKS_POS);
        IntegerHelper.getFourBytes(-2, headerBlock, BaseCompoundFile.SMALL_BLOCK_DEPOT_BLOCK_POS);
        IntegerHelper.getFourBytes(this.extensionBlock, headerBlock, BaseCompoundFile.EXTENSION_BLOCK_POS);
        IntegerHelper.getFourBytes(this.numExtensionBlocks, headerBlock, BaseCompoundFile.NUM_EXTENSION_BLOCK_POS);
        IntegerHelper.getFourBytes(this.rootStartBlock, headerBlock, BaseCompoundFile.ROOT_START_BLOCK_POS);
        int pos = BaseCompoundFile.BIG_BLOCK_DEPOT_BLOCKS_POS;
        int blocksToWrite = Math.min(this.numBigBlockDepotBlocks, (BaseCompoundFile.BIG_BLOCK_SIZE - BaseCompoundFile.BIG_BLOCK_DEPOT_BLOCKS_POS) / 4);
        boolean extensionBlock = false;
        int blocksWritten = 0;
        int i = 0;
        while (i < blocksToWrite) {
            IntegerHelper.getFourBytes(this.bbdStartBlock + i, headerBlock, pos);
            pos += 4;
            ++blocksWritten;
            ++i;
        }
        int i2 = pos;
        while (i2 < BaseCompoundFile.BIG_BLOCK_SIZE) {
            headerBlock[i2] = -1;
            ++i2;
        }
        this.out.write(headerBlock);
        pos = 0;
        int extBlock = 0;
        while (extBlock < this.numExtensionBlocks) {
            System.out.println("Blocks written:  " + blocksWritten);
            System.out.println("Writing extension block " + extBlock);
            blocksToWrite = Math.min(this.numBigBlockDepotBlocks - blocksWritten, BaseCompoundFile.BIG_BLOCK_SIZE / 4 - 1);
            int j = 0;
            while (j < blocksToWrite) {
                IntegerHelper.getFourBytes(this.bbdStartBlock + blocksWritten + j, extensionBlockData, pos);
                pos += 4;
                ++j;
            }
            int nextBlock = (blocksWritten += blocksToWrite) == this.numBigBlockDepotBlocks ? -2 : extBlock + 1;
            System.out.println("blocksWritten " + blocksWritten);
            System.out.println("nextExtensionBlock " + nextBlock);
            IntegerHelper.getFourBytes(nextBlock, extensionBlockData, pos);
            pos += 4;
            ++extBlock;
        }
        if (this.numExtensionBlocks > 0) {
            int i3 = pos;
            while (i3 < extensionBlockData.length) {
                extensionBlockData[i3] = -1;
                ++i3;
            }
            this.out.write(extensionBlockData);
        }
    }

    private void writePropertySets() throws IOException {
        byte[] propertySetStorage = new byte[BaseCompoundFile.BIG_BLOCK_SIZE];
        int pos = 0;
        CompoundFile compoundFile = this;
        compoundFile.getClass();
        BaseCompoundFile.PropertyStorage ps = (BaseCompoundFile)compoundFile.new BaseCompoundFile.PropertyStorage("Root Entry");
        ps.setType(5);
        ps.setStartBlock(-2);
        ps.setSize(0);
        ps.setPrevious(-1);
        ps.setNext(-1);
        ps.setDirectory(2);
        System.arraycopy(ps.data, 0, propertySetStorage, pos, BaseCompoundFile.PROPERTY_STORAGE_BLOCK_SIZE);
        pos += BaseCompoundFile.PROPERTY_STORAGE_BLOCK_SIZE;
        CompoundFile compoundFile2 = this;
        compoundFile2.getClass();
        ps = (BaseCompoundFile)compoundFile2.new BaseCompoundFile.PropertyStorage("Workbook");
        ps.setType(2);
        ps.setStartBlock(this.excelDataStartBlock);
        ps.setSize(this.requiredSize);
        ps.setPrevious(-1);
        ps.setNext(-1);
        ps.setDirectory(-1);
        System.arraycopy(ps.data, 0, propertySetStorage, pos, BaseCompoundFile.PROPERTY_STORAGE_BLOCK_SIZE);
        pos += BaseCompoundFile.PROPERTY_STORAGE_BLOCK_SIZE;
        CompoundFile compoundFile3 = this;
        compoundFile3.getClass();
        ps = (BaseCompoundFile)compoundFile3.new BaseCompoundFile.PropertyStorage("SummaryInformation");
        ps.setType(2);
        ps.setStartBlock(this.excelDataStartBlock + this.excelDataBlocks);
        ps.setSize(BaseCompoundFile.SMALL_BLOCK_THRESHOLD);
        ps.setPrevious(1);
        ps.setNext(3);
        ps.setDirectory(-1);
        System.arraycopy(ps.data, 0, propertySetStorage, pos, BaseCompoundFile.PROPERTY_STORAGE_BLOCK_SIZE);
        pos += BaseCompoundFile.PROPERTY_STORAGE_BLOCK_SIZE;
        CompoundFile compoundFile4 = this;
        compoundFile4.getClass();
        ps = (BaseCompoundFile)compoundFile4.new BaseCompoundFile.PropertyStorage("DocumentSummaryInformation");
        ps.setType(2);
        ps.setStartBlock(this.excelDataStartBlock + this.excelDataBlocks + 8);
        ps.setSize(BaseCompoundFile.SMALL_BLOCK_THRESHOLD);
        ps.setPrevious(-1);
        ps.setNext(-1);
        ps.setDirectory(-1);
        System.arraycopy(ps.data, 0, propertySetStorage, pos, BaseCompoundFile.PROPERTY_STORAGE_BLOCK_SIZE);
        pos += BaseCompoundFile.PROPERTY_STORAGE_BLOCK_SIZE;
        this.out.write(propertySetStorage);
    }
}

