/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.CellType;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.write.Number;
import jxl.write.biff.CellValue;
import jxl.write.biff.File;
import jxl.write.biff.MulRKRecord;
import jxl.write.biff.StringRecord;

class RowRecord
extends WritableRecordData {
    private byte[] data;
    private CellValue[] cells;
    private int rowHeight;
    private boolean outlineCollapsed;
    private boolean zeroHeight;
    private int rowNumber;
    private int maxColumn;
    private static final int growSize = 10;
    private static final int maxRKValue = 0x1FFFFFFF;
    private static final int minRKValue = -536870912;

    public RowRecord(int rn) {
        super(Type.ROW);
        this.rowNumber = rn;
        this.cells = new CellValue[0];
        this.maxColumn = 0;
        this.rowHeight = 255;
        this.outlineCollapsed = false;
        this.zeroHeight = false;
    }

    public void addCell(CellValue cv) {
        int col = cv.getColumn();
        if (col >= this.cells.length) {
            CellValue[] oldCells = this.cells;
            this.cells = new CellValue[Math.max(oldCells.length + 10, col + 1)];
            System.arraycopy(oldCells, 0, this.cells, 0, oldCells.length);
            Object var3_3 = null;
        }
        this.cells[col] = cv;
        this.maxColumn = Math.max(col + 1, this.maxColumn);
    }

    void decrementRow() {
        --this.rowNumber;
        int i = 0;
        while (i < this.cells.length) {
            if (this.cells[i] != null) {
                this.cells[i].decrementRow();
            }
            ++i;
        }
    }

    public CellValue getCell(int col) {
        return col >= 0 && col <= this.maxColumn ? this.cells[col] : null;
    }

    public byte[] getData() {
        byte[] data = new byte[16];
        IntegerHelper.getTwoBytes(this.rowNumber, data, 0);
        IntegerHelper.getTwoBytes(this.maxColumn, data, 4);
        IntegerHelper.getTwoBytes(this.rowHeight, data, 6);
        if (this.outlineCollapsed) {
            data[15] = (byte)(data[15] | 4);
        }
        if (this.zeroHeight) {
            data[15] = (byte)(data[15] | 8);
        }
        return data;
    }

    public int getMaxColumn() {
        return this.maxColumn;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    void incrementRow() {
        ++this.rowNumber;
        int i = 0;
        while (i < this.cells.length) {
            if (this.cells[i] != null) {
                this.cells[i].incrementRow();
            }
            ++i;
        }
    }

    void insertColumn(int col) {
        if (col >= this.maxColumn) {
            return;
        }
        CellValue[] oldCells = this.cells;
        this.cells = this.maxColumn == this.cells.length ? new CellValue[oldCells.length + 10] : new CellValue[oldCells.length];
        System.arraycopy(oldCells, 0, this.cells, 0, col);
        System.arraycopy(oldCells, col, this.cells, col + 1, this.maxColumn - col + 1);
        int i = col + 1;
        while (i <= this.maxColumn) {
            if (this.cells[i] != null) {
                this.cells[i].incrementColumn();
            }
            ++i;
        }
        ++this.maxColumn;
    }

    public void removeCell(int col) {
        if (col >= this.maxColumn) {
            return;
        }
        this.cells[col] = null;
    }

    void removeColumn(int col) {
        if (col >= this.maxColumn) {
            return;
        }
        CellValue[] oldCells = this.cells;
        this.cells = new CellValue[oldCells.length];
        System.arraycopy(oldCells, 0, this.cells, 0, col);
        System.arraycopy(oldCells, col + 1, this.cells, col, this.maxColumn - col);
        int i = col;
        while (i < this.maxColumn) {
            if (this.cells[i] != null) {
                this.cells[i].decrementColumn();
            }
            ++i;
        }
        --this.maxColumn;
    }

    public void setRowHeight(int h) {
        this.rowHeight = h;
    }

    public void write(File outputFile) throws IOException {
        outputFile.write(this);
    }

    public void writeCells(File outputFile) throws IOException {
        ArrayList<CellValue> integerValues = new ArrayList<CellValue>();
        boolean integerValue = false;
        int i = 0;
        while (i < this.maxColumn) {
            integerValue = false;
            if (this.cells[i] != null) {
                Number nc;
                if (this.cells[i].getType() == CellType.NUMBER && (nc = (Number)this.cells[i]).getValue() == (double)((int)nc.getValue()) && nc.getValue() < 5.36870911E8 && nc.getValue() > -5.36870912E8) {
                    integerValue = true;
                }
                if (integerValue) {
                    integerValues.add(this.cells[i]);
                } else {
                    this.writeIntegerValues(integerValues, outputFile);
                    outputFile.write(this.cells[i]);
                    if (this.cells[i].getType() == CellType.STRING_FORMULA) {
                        StringRecord sr = new StringRecord(this.cells[i].getContents());
                        outputFile.write(sr);
                    }
                }
            } else {
                this.writeIntegerValues(integerValues, outputFile);
            }
            ++i;
        }
        this.writeIntegerValues(integerValues, outputFile);
    }

    private void writeIntegerValues(ArrayList integerValues, File outputFile) throws IOException {
        if (integerValues.size() == 0) {
            return;
        }
        if (integerValues.size() >= 3) {
            MulRKRecord mulrk = new MulRKRecord(integerValues);
            outputFile.write(mulrk);
        } else {
            Iterator i = ((AbstractList)integerValues).iterator();
            while (i.hasNext()) {
                outputFile.write((CellValue)i.next());
            }
        }
        integerValues.clear();
    }
}

