/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.DateCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.biff.EmptyCell;
import jxl.biff.Fonts;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.XFRecord;
import jxl.format.CellFormat;
import jxl.read.biff.SheetImpl;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.BOFRecord;
import jxl.write.biff.CalcCountRecord;
import jxl.write.biff.CalcModeRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.DBCellRecord;
import jxl.write.biff.DefaultColumnWidth;
import jxl.write.biff.DefaultRowHeightRecord;
import jxl.write.biff.DeltaRecord;
import jxl.write.biff.DimensionRecord;
import jxl.write.biff.EOFRecord;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.FormulaRecord;
import jxl.write.biff.GridSetRecord;
import jxl.write.biff.GuttersRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HorizontalCentreRecord;
import jxl.write.biff.IndexRecord;
import jxl.write.biff.IterationRecord;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.PrintGridLinesRecord;
import jxl.write.biff.PrintHeadersRecord;
import jxl.write.biff.RefModeRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SaveRecalcRecord;
import jxl.write.biff.SelectionRecord;
import jxl.write.biff.SetupRecord;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.VerticalCentreRecord;
import jxl.write.biff.Window2Record;
import jxl.write.biff.WorkspaceInformationRecord;

class WritableSheetImpl
implements WritableSheet {
    private String name;
    private boolean hidden;
    private File outputFile;
    private RowRecord[] rows;
    private FormattingRecords formatRecords;
    private Fonts fonts;
    private SharedStrings sharedStrings;
    private TreeSet columnFormats;
    private int maxRow;
    private int maxColumn;
    private boolean selected;
    private static final int rowGrowSize = 10;
    private static final int maxRowsPerSheet = 65536;

    public WritableSheetImpl(String n, File of, FormattingRecords fr, Fonts f, SharedStrings ss) {
        this.name = n;
        this.outputFile = of;
        this.rows = new RowRecord[0];
        this.maxRow = 0;
        this.maxColumn = 0;
        this.selected = false;
        this.formatRecords = fr;
        this.fonts = f;
        this.sharedStrings = ss;
        this.columnFormats = new TreeSet(new ColumnInfoComparator());
    }

    public void addCell(WritableCell cell) throws WriteException, RowsExceededException {
        RowRecord rowrec;
        CellValue cv = (CellValue)cell;
        if (cv.isReferenced()) {
            throw new JxlWriteException(JxlWriteException.cellReferenced);
        }
        int row = cell.getRow();
        if (row >= 65536) {
            throw new RowsExceededException();
        }
        if (row >= this.rows.length) {
            RowRecord[] oldRows = this.rows;
            this.rows = new RowRecord[Math.max(oldRows.length + 10, row + 1)];
            System.arraycopy(oldRows, 0, this.rows, 0, oldRows.length);
            oldRows = null;
        }
        if ((rowrec = this.rows[row]) == null) {
            this.rows[row] = rowrec = new RowRecord(row);
        }
        rowrec.addCell(cv);
        this.maxRow = Math.max(row + 1, this.maxRow);
        this.maxColumn = Math.max(this.maxColumn, rowrec.getMaxColumn());
        cv.setCellDetails(this.formatRecords, this.sharedStrings);
    }

    void copy(Sheet s) {
        this.copyCells(s);
        SheetImpl si = (SheetImpl)s;
        jxl.read.biff.ColumnInfoRecord readCir = null;
        int i = 0;
        while (i < s.getColumns()) {
            readCir = si.getColumnInfo(i);
            if (readCir != null) {
                ColumnInfoRecord cir = new ColumnInfoRecord(readCir, i, this.formatRecords);
                this.columnFormats.add(cir);
            }
            ++i;
        }
    }

    void copy(WritableSheet s) {
        this.copyCells(s);
        this.columnFormats = ((WritableSheetImpl)s).columnFormats;
    }

    private void copyCells(Sheet s) {
        int cells = s.getRows();
        Cell[] row = null;
        Cell cell = null;
        int i = 0;
        while (i < cells) {
            row = s.getRow(i);
            int j = 0;
            while (j < row.length) {
                cell = row[j];
                CellType ct = cell.getType();
                try {
                    CellValue b;
                    if (ct == CellType.LABEL) {
                        Label l = new Label((LabelCell)cell);
                        this.addCell(l);
                    } else if (ct == CellType.NUMBER) {
                        Number n = new Number((NumberCell)cell);
                        this.addCell(n);
                    } else if (ct == CellType.DATE) {
                        DateTime dt = new DateTime((DateCell)cell);
                        this.addCell(dt);
                    } else if (ct == CellType.BOOLEAN) {
                        b = new Boolean((BooleanCell)cell);
                        this.addCell(b);
                    } else if (ct == CellType.NUMBER_FORMULA || ct == CellType.STRING_FORMULA || ct == CellType.BOOLEAN_FORMULA || ct == CellType.FORMULA_ERROR) {
                        FormulaRecord fr = new FormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                    } else if (ct == CellType.EMPTY && cell.getCellFormat() != null) {
                        b = new Blank(cell);
                        this.addCell(b);
                    }
                }
                catch (WriteException writeException) {
                    Assert.verify(false);
                }
                ++j;
            }
            ++i;
        }
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        int i = 0;
        while (i < this.getRows() && !found) {
            Cell[] row = this.getRow(i);
            int j = 0;
            while (j < row.length && !found) {
                if (row[j].getContents().equals(contents)) {
                    cell = row[j];
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        int i = 0;
        while (i < this.getRows() && !found) {
            Cell[] row = this.getRow(i);
            int j = 0;
            while (j < row.length && !found) {
                if ((row[j].getType() == CellType.LABEL || row[j].getType() == CellType.STRING_FORMULA) && row[j].getContents().equals(contents)) {
                    cell = (LabelCell)row[j];
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public Cell getCell(int column, int row) {
        return this.getWritableCell(column, row);
    }

    public Cell[] getColumn(int col) {
        boolean found = false;
        int row = this.maxRow - 1;
        while (row >= 0 && !found) {
            if (this.getCell(row, col) != CellType.EMPTY) {
                found = true;
                continue;
            }
            --row;
        }
        Cell[] cells = new Cell[row + 1];
        int i = 0;
        while (i <= row) {
            cells[i] = this.getCell(col, i);
            ++i;
        }
        return cells;
    }

    public int getColumns() {
        return this.maxColumn;
    }

    public String getName() {
        return this.name;
    }

    public Cell[] getRow(int row) {
        boolean found = false;
        int col = this.maxColumn - 1;
        while (col >= 0 && !found) {
            if (this.getCell(row, col) != CellType.EMPTY) {
                found = true;
                continue;
            }
            --col;
        }
        Cell[] cells = new Cell[col + 1];
        int i = 0;
        while (i <= col) {
            cells[i] = this.getCell(i, row);
            ++i;
        }
        return cells;
    }

    public int getRows() {
        return this.maxRow;
    }

    public WritableCell getWritableCell(int column, int row) {
        WritableCell c = null;
        if (this.rows[row] != null) {
            c = this.rows[row].getCell(column);
        }
        if (c == null) {
            c = new EmptyCell(column, row);
        }
        return c;
    }

    public void insertColumn(int col) {
        if (col < 0 || col >= this.maxColumn) {
            return;
        }
        int i = 0;
        while (i < this.maxRow) {
            if (this.rows[i] != null) {
                this.rows[i].insertColumn(col);
            }
            ++i;
        }
        ++this.maxColumn;
    }

    public void insertRow(int row) {
        if (row < 0 || row >= this.maxRow) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = this.maxRow == this.rows.length ? new RowRecord[oldRows.length + 10] : new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row, this.rows, row + 1, this.maxRow - row + 1);
        int i = row + 1;
        while (i <= this.maxRow) {
            if (this.rows[i] != null) {
                this.rows[i].incrementRow();
            }
            ++i;
        }
        ++this.maxRow;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void removeColumn(int col) {
        if (col < 0 || col >= this.maxColumn) {
            return;
        }
        int i = 0;
        while (i < this.maxRow) {
            if (this.rows[i] != null) {
                this.rows[i].removeColumn(col);
            }
            ++i;
        }
        --this.maxColumn;
    }

    public void removeRow(int row) {
        if (row < 0 || row >= this.maxRow) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row + 1, this.rows, row, this.maxRow - row);
        int i = row;
        while (i < this.maxRow) {
            if (this.rows[i] != null) {
                this.rows[i].decrementRow();
            }
            ++i;
        }
        --this.maxRow;
    }

    public void setColumnView(int col, int width) {
        this.setColumnView(col, width, WritableWorkbook.NORMAL_STYLE);
    }

    public void setColumnView(int col, int width, CellFormat format) {
        block4: {
            XFRecord xfr = (XFRecord)format;
            try {
                ColumnInfoRecord cir;
                if (!xfr.isInitialized()) {
                    this.formatRecords.addStyle(xfr);
                }
                if (!this.columnFormats.contains(cir = new ColumnInfoRecord(col, width, xfr))) {
                    this.columnFormats.add(cir);
                }
            }
            catch (NumFormatRecordsException numFormatRecordsException) {
                System.err.println("Warning:  maximum number of format records exceeded.  Using default format");
                ColumnInfoRecord cir = new ColumnInfoRecord(col, width, WritableWorkbook.NORMAL_STYLE);
                if (this.columnFormats.contains(cir)) break block4;
                this.columnFormats.add(cir);
            }
        }
    }

    public void setHidden(boolean h) {
        this.hidden = h;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setSelected() {
        this.selected = true;
    }

    public void write() throws IOException {
        int bofpos = this.outputFile.getPos();
        BOFRecord bof = new BOFRecord(BOFRecord.sheet);
        this.outputFile.write(bof);
        int numBlocks = this.getRows() / 32;
        if (this.getRows() - numBlocks * 32 != 0) {
            ++numBlocks;
        }
        int indexPos = this.outputFile.getPos();
        IndexRecord indexRecord = new IndexRecord(0, this.getRows(), numBlocks);
        this.outputFile.write(indexRecord);
        CalcModeRecord cmr = new CalcModeRecord(CalcModeRecord.automatic);
        this.outputFile.write(cmr);
        CalcCountRecord ccr = new CalcCountRecord(100);
        this.outputFile.write(ccr);
        RefModeRecord rmr = new RefModeRecord();
        this.outputFile.write(rmr);
        IterationRecord itr = new IterationRecord(false);
        this.outputFile.write(itr);
        DeltaRecord dtr = new DeltaRecord(0.001);
        this.outputFile.write(dtr);
        SaveRecalcRecord srr = new SaveRecalcRecord(true);
        this.outputFile.write(srr);
        PrintHeadersRecord phr = new PrintHeadersRecord(false);
        this.outputFile.write(phr);
        PrintGridLinesRecord pglr = new PrintGridLinesRecord(false);
        this.outputFile.write(pglr);
        GridSetRecord gsr = new GridSetRecord(true);
        this.outputFile.write(gsr);
        GuttersRecord gutr = new GuttersRecord();
        this.outputFile.write(gutr);
        DefaultRowHeightRecord drhr = new DefaultRowHeightRecord();
        this.outputFile.write(drhr);
        WorkspaceInformationRecord wir = new WorkspaceInformationRecord();
        this.outputFile.write(wir);
        HeaderRecord hr = new HeaderRecord("");
        this.outputFile.write(hr);
        FooterRecord fr = new FooterRecord("");
        this.outputFile.write(fr);
        HorizontalCentreRecord hcr = new HorizontalCentreRecord(false);
        this.outputFile.write(hcr);
        VerticalCentreRecord vcr = new VerticalCentreRecord(false);
        this.outputFile.write(vcr);
        SetupRecord setr = new SetupRecord();
        this.outputFile.write(setr);
        DefaultColumnWidth dcw = new DefaultColumnWidth(8);
        this.outputFile.write(dcw);
        ColumnInfoRecord cir = null;
        Iterator colit = this.columnFormats.iterator();
        while (colit.hasNext()) {
            cir = (ColumnInfoRecord)colit.next();
            this.outputFile.write(cir);
            XFRecord xfr = cir.getCellFormat();
            if (xfr == WritableWorkbook.NORMAL_STYLE) continue;
            Cell[] cells = this.getColumn(cir.getColumn());
            int i = 0;
            while (i < cells.length) {
                if (cells[i].getCellFormat() == WritableWorkbook.NORMAL_STYLE) {
                    ((WritableCell)cells[i]).setCellFormat(xfr);
                }
                ++i;
            }
        }
        DimensionRecord dr = new DimensionRecord(this.getRows(), this.getColumns());
        this.outputFile.write(dr);
        int block = 0;
        while (block < numBlocks) {
            DBCellRecord dbcell = new DBCellRecord(this.outputFile.getPos());
            int blockRows = Math.min(32, this.getRows() - block * 32);
            boolean firstRow = true;
            int i = block * 32;
            while (i < block * 32 + blockRows) {
                if (this.rows[i] != null) {
                    this.rows[i].write(this.outputFile);
                    if (firstRow) {
                        dbcell.setCellOffset(this.outputFile.getPos());
                        firstRow = false;
                    }
                }
                ++i;
            }
            int i2 = block * 32;
            while (i2 < block * 32 + blockRows) {
                if (this.rows[i2] != null) {
                    dbcell.addCellRowPosition(this.outputFile.getPos());
                    this.rows[i2].writeCells(this.outputFile);
                }
                ++i2;
            }
            indexRecord.addBlockPosition(this.outputFile.getPos());
            dbcell.setPosition(this.outputFile.getPos());
            this.outputFile.write(dbcell);
            ++block;
        }
        Window2Record w2r = new Window2Record(this.selected);
        this.outputFile.write(w2r);
        SelectionRecord sr = new SelectionRecord();
        this.outputFile.write(sr);
        EOFRecord eof = new EOFRecord();
        this.outputFile.write(eof);
        this.outputFile.setData(indexRecord.getData(), indexPos + 4);
    }

    private static class ColumnInfoComparator
    implements Comparator {
        ColumnInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Assert.verify(o1 instanceof ColumnInfoRecord);
            Assert.verify(o2 instanceof ColumnInfoRecord);
            ColumnInfoRecord ci1 = (ColumnInfoRecord)o1;
            ColumnInfoRecord ci2 = (ColumnInfoRecord)o2;
            return ci1.getColumn() - ci2.getColumn();
        }

        public boolean equals(Object o) {
            return o == this;
        }
    }
}

