/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.text.MessageFormat;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationFactory;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.GeneralPosition;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;

public class TransformedPosition
extends GeneralPosition {
    private static final long serialVersionUID = -3988283183934950437L;
    private final CoordinateOperationFactory factory;
    private final CoordinateReferenceSystem defaultCRS;
    private transient CoordinateReferenceSystem sourceCRS;
    private transient MathTransform forward;
    private transient MathTransform inverse;

    public TransformedPosition() {
        this(null, DefaultGeographicCRS.WGS84, null);
    }

    public TransformedPosition(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Hints hints) throws FactoryRegistryException {
        super(targetCRS);
        TransformedPosition.ensureNonNull("targetCRS", targetCRS);
        this.defaultCRS = CRS.equalsIgnoreMetadata(sourceCRS, targetCRS) ? null : sourceCRS;
        this.factory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
    }

    @Override
    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        TransformedPosition.ensureNonNull("crs", crs);
        super.setCoordinateReferenceSystem(crs);
        this.forward = null;
        this.inverse = null;
    }

    private void setSourceCRS(CoordinateReferenceSystem crs) throws TransformException {
        CoordinateOperation operation;
        CoordinateReferenceSystem targetCRS = this.getCoordinateReferenceSystem();
        try {
            operation = this.factory.createOperation(crs, targetCRS);
        }
        catch (FactoryException exception) {
            throw new TransformException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.forward = operation.getMathTransform();
        this.inverse = null;
        this.sourceCRS = crs;
    }

    public void transform(Position position) throws TransformException {
        CoordinateReferenceSystem userCRS = position.getCoordinateReferenceSystem();
        if (userCRS == null && (userCRS = this.defaultCRS) == null) {
            this.setLocation(position);
            return;
        }
        if (this.forward == null || !CRS.equalsIgnoreMetadata(this.sourceCRS, userCRS)) {
            this.setSourceCRS(userCRS);
        }
        if (this.forward.transform(position, (Position)this) != this) {
            throw new AssertionError(this.forward);
        }
    }

    public Position inverseTransform(CoordinateReferenceSystem crs) throws TransformException {
        if (this.inverse == null || !CRS.equalsIgnoreMetadata(this.sourceCRS, crs)) {
            TransformedPosition.ensureNonNull("crs", crs);
            this.setSourceCRS(crs);
            this.inverse = this.forward.inverse();
        }
        return this.inverse.transform((Position)this, null);
    }

    public Position inverseTransform() throws TransformException {
        if (this.defaultCRS != null) {
            return this.inverseTransform(this.defaultCRS);
        }
        return new GeneralPosition(this);
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(MessageFormat.format("Argument \"{0}\" should not be null.", name));
        }
    }
}

