/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.measure.Measure;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.UnsupportedImplementationException;
import si.uom.NonSI;

public class DefaultGeographicCRS
extends AbstractSingleCRS
implements GeographicCRS {
    private static final long serialVersionUID = 861224913438092335L;
    public static final DefaultGeographicCRS WGS84;
    public static final DefaultGeographicCRS WGS84_3D;

    public DefaultGeographicCRS(GeographicCRS crs) {
        super((SingleCRS)crs);
    }

    public DefaultGeographicCRS(GeodeticDatum datum, EllipsoidalCS cs) {
        this(DefaultGeographicCRS.getProperties((IdentifiedObject)datum), datum, cs);
    }

    public DefaultGeographicCRS(String name, GeodeticDatum datum, EllipsoidalCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultGeographicCRS(Map<String, ?> properties, GeodeticDatum datum, EllipsoidalCS cs) {
        super(properties, (Datum)datum, (CoordinateSystem)cs);
    }

    public EllipsoidalCS getCoordinateSystem() {
        return (EllipsoidalCS)super.getCoordinateSystem();
    }

    public GeodeticDatum getDatum() {
        return (GeodeticDatum)super.getDatum();
    }

    @Override
    public Measure distance(double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        if (!(this.coordinateSystem instanceof DefaultEllipsoidalCS)) {
            throw new UnsupportedImplementationException(this.coordinateSystem.getClass());
        }
        Ellipsoid ellipsoid = ((GeodeticDatum)this.datum).getEllipsoid();
        if (!(ellipsoid instanceof DefaultEllipsoid)) {
            throw new UnsupportedImplementationException(ellipsoid.getClass());
        }
        DefaultEllipsoidalCS cs = (DefaultEllipsoidalCS)this.coordinateSystem;
        DefaultEllipsoid e = (DefaultEllipsoid)ellipsoid;
        if (coord1.length != 2 || coord2.length != 2 || cs.getDimension() != 2) {
            return super.distance(coord1, coord2);
        }
        return new Measure(e.orthodromicDistance(cs.getLongitude(coord1), cs.getLatitude(coord1), cs.getLongitude(coord2), cs.getLatitude(coord2)), e.getAxisUnit());
    }

    @Override
    public int hashCode() {
        return 0xED31AC2F ^ super.hashCode();
    }

    static Unit<Angle> getAngularUnit(CoordinateSystem coordinateSystem) {
        Unit unit = NonSI.DEGREE_ANGLE;
        int i = coordinateSystem.getDimension();
        while (--i >= 0) {
            CoordinateSystemAxis axis = coordinateSystem.getAxis(i);
            Unit candidate = axis.getUnit();
            if (!NonSI.DEGREE_ANGLE.isCompatible(candidate)) continue;
            unit = candidate.asType(Angle.class);
            if (!AxisDirection.EAST.equals((Object)axis.getDirection().absolute())) continue;
            break;
        }
        return unit;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        Unit<Angle> oldUnit = formatter.getAngularUnit();
        Unit<Angle> unit = DefaultGeographicCRS.getAngularUnit(this.coordinateSystem);
        formatter.setAngularUnit(unit);
        formatter.append((IdentifiedObject)this.datum);
        formatter.append((IdentifiedObject)((GeodeticDatum)this.datum).getPrimeMeridian());
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append((IdentifiedObject)this.coordinateSystem.getAxis(i));
        }
        if (!unit.equals(this.getUnit())) {
            formatter.setInvalidWKT(GeographicCRS.class);
        }
        formatter.setAngularUnit(oldUnit);
        return "GEOGCS";
    }

    static {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        properties.put("name", "WGS84(DD)");
        String[] alias = new String[]{"WGS84", "WGS 84"};
        properties.put("alias", alias);
        properties.put("domainOfValidity", ExtentImpl.WORLD);
        properties.put("identifiers", new NamedIdentifier(Citations.EPSG, "4326"));
        WGS84 = new DefaultGeographicCRS(properties, (GeodeticDatum)DefaultGeodeticDatum.WGS84, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_2D);
        alias[1] = "WGS 84 (geographic 3D)";
        properties.put("identifiers", new NamedIdentifier(Citations.EPSG, "4327"));
        WGS84_3D = new DefaultGeographicCRS(properties, (GeodeticDatum)DefaultGeodeticDatum.WGS84, (EllipsoidalCS)DefaultEllipsoidalCS.GEODETIC_3D);
    }
}

