/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.measure.IncommensurableException;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.RangeMeaning;
import org.geotools.api.util.CodeList;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.cs.DirectionAlongMeridian;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.NameFactory;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import si.uom.NonSI;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;

public class DefaultCoordinateSystemAxis
extends AbstractIdentifiedObject
implements CoordinateSystemAxis {
    private static final long serialVersionUID = -7883614853277827689L;
    static final int COMPASS_DIRECTION_COUNT = 16;
    private static int PREDEFINED_COUNT = 0;
    private static final DefaultCoordinateSystemAxis[] PREDEFINED = new DefaultCoordinateSystemAxis[26];
    public static final DefaultCoordinateSystemAxis GEODETIC_LONGITUDE = new DefaultCoordinateSystemAxis(86, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis GEODETIC_LATITUDE = new DefaultCoordinateSystemAxis(85, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis LONGITUDE = new DefaultCoordinateSystemAxis(132, "\u03bb", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis LATITUDE = new DefaultCoordinateSystemAxis(120, "\u03c6", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
    public static final DefaultCoordinateSystemAxis ELLIPSOIDAL_HEIGHT = new DefaultCoordinateSystemAxis(58, "h", AxisDirection.UP, SI.METRE);
    public static final DefaultCoordinateSystemAxis GRAVITY_RELATED_HEIGHT = new DefaultCoordinateSystemAxis(93, "H", AxisDirection.UP, SI.METRE);
    public static final DefaultCoordinateSystemAxis ALTITUDE = new DefaultCoordinateSystemAxis(5, "h", AxisDirection.UP, SI.METRE);
    public static final DefaultCoordinateSystemAxis DEPTH;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_RADIUS;
    public static final DefaultCoordinateSystemAxis SPHERICAL_LONGITUDE;
    public static final DefaultCoordinateSystemAxis SPHERICAL_LATITUDE;
    public static final DefaultCoordinateSystemAxis X;
    public static final DefaultCoordinateSystemAxis Y;
    public static final DefaultCoordinateSystemAxis Z;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_X;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Y;
    public static final DefaultCoordinateSystemAxis GEOCENTRIC_Z;
    public static final DefaultCoordinateSystemAxis EASTING;
    public static final DefaultCoordinateSystemAxis WESTING;
    public static final DefaultCoordinateSystemAxis NORTHING;
    public static final DefaultCoordinateSystemAxis SOUTHING;
    public static final DefaultCoordinateSystemAxis TIME;
    public static final DefaultCoordinateSystemAxis COLUMN;
    public static final DefaultCoordinateSystemAxis ROW;
    public static final DefaultCoordinateSystemAxis DISPLAY_X;
    public static final DefaultCoordinateSystemAxis DISPLAY_Y;
    private static final Map<String, CoordinateSystemAxis> ALIASES;
    private final String abbreviation;
    private final AxisDirection direction;
    private final Unit<?> unit;
    private final double minimum;
    private final double maximum;
    private final RangeMeaning rangeMeaning;
    private transient DefaultCoordinateSystemAxis opposite;

    private static boolean nameMatchesXY(String xy, String name) {
        if ((xy = xy.trim()).length() == 1) {
            DefaultCoordinateSystemAxis axis;
            switch (Character.toLowerCase(xy.charAt(0))) {
                case 'x': {
                    axis = EASTING;
                    break;
                }
                case 'y': {
                    axis = NORTHING;
                    break;
                }
                default: {
                    return false;
                }
            }
            return axis.nameMatches(name) || axis.getOpposite().nameMatches(name);
        }
        return false;
    }

    public DefaultCoordinateSystemAxis(CoordinateSystemAxis axis) {
        super((IdentifiedObject)axis);
        this.abbreviation = axis.getAbbreviation();
        this.direction = axis.getDirection();
        this.unit = axis.getUnit();
        this.minimum = axis.getMinimumValue();
        this.maximum = axis.getMaximumValue();
        this.rangeMeaning = axis.getRangeMeaning();
    }

    public DefaultCoordinateSystemAxis(Map<String, ?> properties, String abbreviation, AxisDirection direction, Unit<?> unit, double minimum, double maximum, RangeMeaning rangeMeaning) {
        super(properties);
        this.abbreviation = abbreviation;
        this.direction = direction;
        this.unit = unit;
        this.minimum = minimum;
        this.maximum = maximum;
        this.rangeMeaning = rangeMeaning;
        DefaultCoordinateSystemAxis.ensureNonNull("abbreviation", abbreviation);
        DefaultCoordinateSystemAxis.ensureNonNull("direction", direction);
        DefaultCoordinateSystemAxis.ensureNonNull("unit", unit);
        DefaultCoordinateSystemAxis.ensureNonNull("rangeMeaning", rangeMeaning);
        if (!(minimum < maximum)) {
            throw new IllegalArgumentException(MessageFormat.format("Range [{0} .. {1}] is not valid.", minimum, maximum));
        }
    }

    public DefaultCoordinateSystemAxis(Map<String, ?> properties, String abbreviation, AxisDirection direction, Unit<?> unit) {
        super(properties);
        this.abbreviation = abbreviation;
        this.direction = direction;
        this.unit = unit;
        DefaultCoordinateSystemAxis.ensureNonNull("abbreviation", abbreviation);
        DefaultCoordinateSystemAxis.ensureNonNull("direction", direction);
        DefaultCoordinateSystemAxis.ensureNonNull("unit", unit);
        if (unit.isCompatible(NonSI.DEGREE_ANGLE)) {
            UnitConverter fromDegrees;
            try {
                fromDegrees = NonSI.DEGREE_ANGLE.getConverterToAny(unit);
            }
            catch (IncommensurableException | UnconvertibleException e) {
                throw new IllegalArgumentException("The provided unit is not compatible with DEGREE_ANGLE unit", e);
            }
            AxisDirection dir = direction.absolute();
            if (dir.equals((Object)AxisDirection.NORTH)) {
                double range = Math.abs(fromDegrees.convert(90.0));
                this.minimum = -range;
                this.maximum = range;
                this.rangeMeaning = RangeMeaning.EXACT;
                return;
            }
            if (dir.equals((Object)AxisDirection.EAST)) {
                double range = Math.abs(fromDegrees.convert(180.0));
                this.minimum = -range;
                this.maximum = range;
                this.rangeMeaning = RangeMeaning.WRAPAROUND;
                return;
            }
        }
        this.minimum = Double.NEGATIVE_INFINITY;
        this.maximum = Double.POSITIVE_INFINITY;
        this.rangeMeaning = RangeMeaning.EXACT;
    }

    public DefaultCoordinateSystemAxis(String abbreviation, AxisDirection direction, Unit<?> unit) {
        this(Collections.singletonMap("name", abbreviation), abbreviation, direction, unit);
    }

    public DefaultCoordinateSystemAxis(InternationalString name, String abbreviation, AxisDirection direction, Unit<?> unit) {
        this(DefaultCoordinateSystemAxis.toMap(name), abbreviation, direction, unit);
    }

    private static Map<String, Object> toMap(InternationalString name) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        if (name != null) {
            properties.put("name", name.toString(null));
            properties.put("alias", NameFactory.create((CharSequence[])new CharSequence[]{name}));
        }
        return properties;
    }

    private DefaultCoordinateSystemAxis(int name, String abbreviation, AxisDirection direction, Unit<?> unit) {
        this((InternationalString)(name >= 0 ? Vocabulary.formatInternational((int)name) : new SimpleInternationalString(abbreviation)), abbreviation, direction, unit);
        DefaultCoordinateSystemAxis.PREDEFINED[DefaultCoordinateSystemAxis.PREDEFINED_COUNT++] = this;
    }

    public static DefaultCoordinateSystemAxis getPredefined(String name, AxisDirection direction) {
        DefaultCoordinateSystemAxis.ensureNonNull("name", name);
        name = name.trim();
        DefaultCoordinateSystemAxis found = null;
        for (int i = 0; i < PREDEFINED_COUNT; ++i) {
            DefaultCoordinateSystemAxis candidate = PREDEFINED[i];
            if (direction != null && !direction.equals((Object)candidate.getDirection())) continue;
            if (candidate.abbreviation.equals(name)) {
                return candidate;
            }
            if (found != null || !candidate.nameMatches(name) || (candidate == GEODETIC_LONGITUDE || candidate == GEODETIC_LATITUDE) && !name.toLowerCase().startsWith("geodetic")) continue;
            found = candidate;
        }
        return found;
    }

    static DefaultCoordinateSystemAxis getPredefined(CoordinateSystemAxis axis) {
        return DefaultCoordinateSystemAxis.getPredefined(axis.getName().getCode(), axis.getDirection());
    }

    static DefaultCoordinateSystemAxis[] values() {
        return (DefaultCoordinateSystemAxis[])PREDEFINED.clone();
    }

    public static AxisDirection getDirection(String direction) throws NoSuchElementException {
        DefaultCoordinateSystemAxis.ensureNonNull("direction", direction);
        direction = direction.trim();
        AxisDirection candidate = DirectionAlongMeridian.findDirection(direction);
        if (candidate != null) {
            return candidate;
        }
        if ("northeast".equalsIgnoreCase(direction)) {
            return AxisDirection.NORTH_EAST;
        }
        if ("northwest".equalsIgnoreCase(direction)) {
            return AxisDirection.NORTH_WEST;
        }
        DirectionAlongMeridian meridian = DirectionAlongMeridian.parse(direction);
        if (meridian != null) {
            candidate = meridian.getDirection();
            assert (candidate == DirectionAlongMeridian.findDirection(meridian.toString()));
            return candidate;
        }
        throw new NoSuchElementException(MessageFormat.format("Unknow axis direction: \"{0}\".", direction));
    }

    public AxisDirection getDirection() {
        return this.direction;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public Unit<?> getUnit() {
        return this.unit;
    }

    public double getMinimumValue() {
        return this.minimum;
    }

    public double getMaximumValue() {
        return this.maximum;
    }

    public RangeMeaning getRangeMeaning() {
        return this.rangeMeaning;
    }

    final DefaultCoordinateSystemAxis getOpposite() {
        return this.opposite;
    }

    public static boolean isCompassDirection(AxisDirection direction) {
        DefaultCoordinateSystemAxis.ensureNonNull("direction", direction);
        int n = direction.ordinal() - AxisDirection.NORTH.ordinal();
        return n >= 0 && n < 16;
    }

    public static double getAngle(AxisDirection source, AxisDirection target) {
        DirectionAlongMeridian tgt;
        DefaultCoordinateSystemAxis.ensureNonNull("source", source);
        DefaultCoordinateSystemAxis.ensureNonNull("target", target);
        int compass = DefaultCoordinateSystemAxis.getCompassAngle(source, target);
        if (compass != Integer.MIN_VALUE) {
            return (double)compass * 22.5;
        }
        DirectionAlongMeridian src = DirectionAlongMeridian.parse(source);
        if (src != null && (tgt = DirectionAlongMeridian.parse(target)) != null) {
            return src.getAngle(tgt);
        }
        return Double.NaN;
    }

    static int getCompassAngle(AxisDirection source, AxisDirection target) {
        int tgt;
        int base = AxisDirection.NORTH.ordinal();
        int src = source.ordinal() - base;
        if (src >= 0 && src < 16 && (tgt = target.ordinal() - base) >= 0 && tgt < 16) {
            if ((tgt = src - tgt) < -8) {
                tgt += 16;
            } else if (tgt > 8) {
                tgt -= 16;
            }
            return tgt;
        }
        return Integer.MIN_VALUE;
    }

    public static boolean perpendicular(AxisDirection first, AxisDirection second) {
        return Math.abs(Math.abs(DefaultCoordinateSystemAxis.getAngle(first, second)) - 90.0) <= 1.0E-10;
    }

    final DefaultCoordinateSystemAxis usingUnit(Unit<?> newUnit) throws IllegalArgumentException {
        if (this.unit.equals(newUnit)) {
            return this;
        }
        if (this.unit.isCompatible(newUnit)) {
            return new DefaultCoordinateSystemAxis(DefaultCoordinateSystemAxis.getProperties(this, null), this.abbreviation, this.direction, newUnit, this.minimum, this.maximum, this.rangeMeaning);
        }
        throw new IllegalArgumentException(MessageFormat.format("Incompatible unit: {0}", newUnit));
    }

    @Override
    public boolean nameMatches(String name) {
        if (super.nameMatches(name)) {
            return true;
        }
        CoordinateSystemAxis type = ALIASES.get(name.trim().toLowerCase());
        return type != null && type == ALIASES.get(this.getName().getCode().trim().toLowerCase());
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            return this.equals((DefaultCoordinateSystemAxis)object, compareMetadata, true);
        }
        return false;
    }

    final boolean equals(DefaultCoordinateSystemAxis that, boolean compareMetadata, boolean compareUnit) {
        if (compareMetadata) {
            if (!Utilities.equals((Object)this.abbreviation, (Object)that.abbreviation) || !Utilities.equals((Object)this.rangeMeaning, (Object)that.rangeMeaning) || Double.doubleToLongBits(this.minimum) != Double.doubleToLongBits(that.minimum) || Double.doubleToLongBits(this.maximum) != Double.doubleToLongBits(that.maximum)) {
                return false;
            }
        } else {
            String thisName;
            String thatName = that.getName().getCode();
            if (!this.nameMatches(thatName) && !DefaultCoordinateSystemAxis.nameMatches((IdentifiedObject)that, thisName = this.getName().getCode())) {
                if (!compareUnit) {
                    return false;
                }
                if (!DefaultCoordinateSystemAxis.nameMatchesXY(thatName, thisName) && !DefaultCoordinateSystemAxis.nameMatchesXY(thisName, thatName)) {
                    return false;
                }
            }
        }
        return Utilities.equals((Object)this.direction, (Object)that.direction) && (!compareUnit || Utilities.equals(this.unit, that.unit));
    }

    @Override
    public int hashCode() {
        int code = 1684127127;
        code = code * 37 + this.abbreviation.hashCode();
        code = code * 37 + this.direction.hashCode();
        code = code * 37 + this.unit.hashCode();
        return code;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        formatter.append((CodeList)this.direction);
        return "AXIS";
    }

    static {
        DefaultCoordinateSystemAxis.ALTITUDE.opposite = DEPTH = new DefaultCoordinateSystemAxis(44, "d", AxisDirection.DOWN, SI.METRE);
        DefaultCoordinateSystemAxis.DEPTH.opposite = ALTITUDE;
        GEOCENTRIC_RADIUS = new DefaultCoordinateSystemAxis(78, "r", AxisDirection.UP, SI.METRE);
        SPHERICAL_LONGITUDE = new DefaultCoordinateSystemAxis(206, "\u03a9", AxisDirection.EAST, NonSI.DEGREE_ANGLE);
        SPHERICAL_LATITUDE = new DefaultCoordinateSystemAxis(205, "\u03b8", AxisDirection.NORTH, NonSI.DEGREE_ANGLE);
        X = new DefaultCoordinateSystemAxis(-1, "x", AxisDirection.EAST, SI.METRE);
        Y = new DefaultCoordinateSystemAxis(-1, "y", AxisDirection.NORTH, SI.METRE);
        Z = new DefaultCoordinateSystemAxis(-1, "z", AxisDirection.UP, SI.METRE);
        GEOCENTRIC_X = new DefaultCoordinateSystemAxis(80, "X", AxisDirection.OTHER, SI.METRE);
        GEOCENTRIC_Y = new DefaultCoordinateSystemAxis(81, "Y", AxisDirection.EAST, SI.METRE);
        GEOCENTRIC_Z = new DefaultCoordinateSystemAxis(82, "Z", AxisDirection.NORTH, SI.METRE);
        EASTING = new DefaultCoordinateSystemAxis(55, "E", AxisDirection.EAST, SI.METRE);
        DefaultCoordinateSystemAxis.EASTING.opposite = WESTING = new DefaultCoordinateSystemAxis(244, "W", AxisDirection.WEST, SI.METRE);
        DefaultCoordinateSystemAxis.WESTING.opposite = EASTING;
        NORTHING = new DefaultCoordinateSystemAxis(150, "N", AxisDirection.NORTH, SI.METRE);
        DefaultCoordinateSystemAxis.NORTHING.opposite = SOUTHING = new DefaultCoordinateSystemAxis(203, "S", AxisDirection.SOUTH, SI.METRE);
        DefaultCoordinateSystemAxis.SOUTHING.opposite = NORTHING;
        TIME = new DefaultCoordinateSystemAxis(218, "t", AxisDirection.FUTURE, SI.DAY);
        COLUMN = new DefaultCoordinateSystemAxis(25, "i", AxisDirection.COLUMN_POSITIVE, AbstractUnit.ONE);
        ROW = new DefaultCoordinateSystemAxis(187, "j", AxisDirection.ROW_POSITIVE, AbstractUnit.ONE);
        DISPLAY_X = new DefaultCoordinateSystemAxis(-1, "x", AxisDirection.DISPLAY_RIGHT, AbstractUnit.ONE);
        DISPLAY_Y = new DefaultCoordinateSystemAxis(-1, "y", AxisDirection.DISPLAY_DOWN, AbstractUnit.ONE);
        ALIASES = new HashMap<String, CoordinateSystemAxis>(12);
        ALIASES.put("lat", GEODETIC_LATITUDE);
        ALIASES.put("latitude", GEODETIC_LATITUDE);
        ALIASES.put("geodetic latitude", GEODETIC_LATITUDE);
        ALIASES.put("lon", GEODETIC_LONGITUDE);
        ALIASES.put("long", GEODETIC_LONGITUDE);
        ALIASES.put("longitude", GEODETIC_LONGITUDE);
        ALIASES.put("geodetic longitude", GEODETIC_LONGITUDE);
    }
}

