/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import org.geotools.api.metadata.extent.Extent;
import org.geotools.api.metadata.quality.PositionalAccuracy;
import org.geotools.api.metadata.quality.QuantitativeResult;
import org.geotools.api.metadata.quality.Result;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.ConcatenatedOperation;
import org.geotools.api.referencing.operation.ConicProjection;
import org.geotools.api.referencing.operation.Conversion;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CylindricalProjection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Operation;
import org.geotools.api.referencing.operation.PlanarProjection;
import org.geotools.api.referencing.operation.Projection;
import org.geotools.api.referencing.operation.Transformation;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.Record;
import org.geotools.metadata.iso.quality.PositionalAccuracyImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.Utilities;
import si.uom.SI;

public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    public static final PositionalAccuracy[] EMPTY_ACCURACY_ARRAY = new PositionalAccuracy[0];
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    protected final CoordinateReferenceSystem sourceCRS;
    protected final CoordinateReferenceSystem targetCRS;
    final String operationVersion;
    private final Collection<PositionalAccuracy> coordinateOperationAccuracy;
    protected final Extent domainOfValidity;
    private final InternationalString scope;
    protected final MathTransform transform;

    AbstractCoordinateOperation(Conversion definition, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super((IdentifiedObject)definition);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.operationVersion = definition.getOperationVersion();
        this.coordinateOperationAccuracy = definition.getCoordinateOperationAccuracy();
        this.domainOfValidity = definition.getDomainOfValidity();
        this.scope = definition.getScope();
        this.transform = transform;
    }

    public AbstractCoordinateOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        this(properties, new HashMap<String, Object>(), sourceCRS, targetCRS, transform);
    }

    private AbstractCoordinateOperation(Map<String, ?> properties, Map<String, Object> subProperties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, MathTransform transform) {
        super(properties, subProperties, LOCALIZABLES);
        this.domainOfValidity = (Extent)subProperties.get("domainOfValidity");
        this.scope = (InternationalString)subProperties.get("scope");
        this.operationVersion = (String)subProperties.get("operationVersion");
        Object[] positionalAccuracy = (PositionalAccuracy[])subProperties.get("coordinateOperationAccuracy");
        if (positionalAccuracy == null || positionalAccuracy.length == 0) {
            positionalAccuracy = null;
        } else {
            positionalAccuracy = (PositionalAccuracy[])positionalAccuracy.clone();
            for (int i = 0; i < positionalAccuracy.length; ++i) {
                AbstractCoordinateOperation.ensureNonNull("coordinateOperationAccuracy", positionalAccuracy, i);
            }
        }
        this.coordinateOperationAccuracy = AbstractCoordinateOperation.asSet(positionalAccuracy);
        this.sourceCRS = sourceCRS;
        this.targetCRS = targetCRS;
        this.transform = transform;
        this.validate();
    }

    void validate() throws IllegalArgumentException {
        AbstractCoordinateOperation.ensureNonNull("sourceCRS", this.transform);
        AbstractCoordinateOperation.ensureNonNull("targetCRS", this.transform);
        AbstractCoordinateOperation.ensureNonNull("transform", this.transform);
        AbstractCoordinateOperation.checkDimension("sourceCRS", this.sourceCRS, this.transform.getSourceDimensions());
        AbstractCoordinateOperation.checkDimension("targetCRS", this.targetCRS, this.transform.getTargetDimensions());
    }

    private static void checkDimension(String name, CoordinateReferenceSystem crs, int expected) {
        int actual = crs.getCoordinateSystem().getDimension();
        if (actual != expected) {
            throw new IllegalArgumentException(MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", name, actual, expected));
        }
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    public String getOperationVersion() {
        return this.operationVersion;
    }

    public Collection<PositionalAccuracy> getCoordinateOperationAccuracy() {
        if (this.coordinateOperationAccuracy == null) {
            return Collections.emptySet();
        }
        return this.coordinateOperationAccuracy;
    }

    public double getAccuracy() {
        return AbstractCoordinateOperation.getAccuracy0(this);
    }

    public static double getAccuracy(CoordinateOperation operation) {
        if (operation instanceof AbstractCoordinateOperation) {
            return ((AbstractCoordinateOperation)operation).getAccuracy();
        }
        return AbstractCoordinateOperation.getAccuracy0(operation);
    }

    private static double getAccuracy0(CoordinateOperation operation) {
        Collection accuracies = operation.getCoordinateOperationAccuracy();
        if (accuracies != null) {
            for (PositionalAccuracy accuracy : accuracies) {
                if (accuracy == null) continue;
                for (Result result : accuracy.getResults()) {
                    Unit unit;
                    QuantitativeResult quantity;
                    Collection records;
                    if (!(result instanceof QuantitativeResult) || (records = (quantity = (QuantitativeResult)result).getValues()) == null || (unit = quantity.getValueUnit()) == null || !SI.METRE.isCompatible(unit)) continue;
                    for (Record record : records) {
                        for (Object value : record.getAttributes().values()) {
                            if (!(value instanceof Number)) continue;
                            double v = ((Number)value).doubleValue();
                            v = unit.getConverterTo(SI.METRE).convert(v);
                            return v;
                        }
                    }
                }
            }
        }
        if (operation instanceof Conversion) {
            return 0.0;
        }
        if (operation instanceof Transformation) {
            if (!accuracies.contains(PositionalAccuracyImpl.DATUM_SHIFT_OMITTED) && accuracies.contains(PositionalAccuracyImpl.DATUM_SHIFT_APPLIED)) {
                return 25.0;
            }
            return 1000.0;
        }
        double accuracy = Double.NaN;
        if (operation instanceof ConcatenatedOperation) {
            List components = ((ConcatenatedOperation)operation).getOperations();
            for (Object component : components) {
                double candidate = Math.abs(AbstractCoordinateOperation.getAccuracy((CoordinateOperation)component));
                if (Double.isNaN(candidate)) continue;
                if (Double.isNaN(accuracy)) {
                    accuracy = candidate;
                    continue;
                }
                accuracy += candidate;
            }
        }
        return accuracy;
    }

    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    public InternationalString getScope() {
        return this.scope;
    }

    public MathTransform getMathTransform() {
        return this.transform;
    }

    public static Class<? extends CoordinateOperation> getType(CoordinateOperation object) {
        if (object instanceof Transformation) {
            return Transformation.class;
        }
        if (object instanceof ConicProjection) {
            return ConicProjection.class;
        }
        if (object instanceof CylindricalProjection) {
            return CylindricalProjection.class;
        }
        if (object instanceof PlanarProjection) {
            return PlanarProjection.class;
        }
        if (object instanceof Projection) {
            return Projection.class;
        }
        if (object instanceof Conversion) {
            return Conversion.class;
        }
        if (object instanceof Operation) {
            return Operation.class;
        }
        return CoordinateOperation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            AbstractCoordinateOperation that = (AbstractCoordinateOperation)object;
            if (AbstractCoordinateOperation.equals((IdentifiedObject)this.sourceCRS, (IdentifiedObject)that.sourceCRS, compareMetadata) && Utilities.equals((Object)this.transform, (Object)that.transform)) {
                if (!(!compareMetadata || Utilities.equals((Object)this.domainOfValidity, (Object)that.domainOfValidity) && Utilities.equals((Object)this.scope, (Object)that.scope) && Utilities.equals(this.coordinateOperationAccuracy, that.coordinateOperationAccuracy))) {
                    return false;
                }
                Boolean comparing = AbstractDerivedCRS._COMPARING.get();
                if (comparing != null && comparing.booleanValue()) {
                    return true;
                }
                try {
                    AbstractDerivedCRS._COMPARING.set(Boolean.TRUE);
                    boolean bl = AbstractCoordinateOperation.equals((IdentifiedObject)this.targetCRS, (IdentifiedObject)that.targetCRS, compareMetadata);
                    return bl;
                }
                finally {
                    AbstractDerivedCRS._COMPARING.set(Boolean.FALSE);
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = -598790243;
        if (this.sourceCRS != null) {
            code ^= this.sourceCRS.hashCode();
        }
        if (this.targetCRS != null) {
            code ^= this.targetCRS.hashCode();
        }
        if (this.transform != null) {
            code ^= this.transform.hashCode();
        }
        return code;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        AbstractCoordinateOperation.append(formatter, (IdentifiedObject)this.sourceCRS, "SOURCE");
        AbstractCoordinateOperation.append(formatter, (IdentifiedObject)this.targetCRS, "TARGET");
        return super.formatWKT(formatter);
    }

    static void append(Formatter formatter, IdentifiedObject object, final String type) {
        if (object != null) {
            HashMap<String, String> properties = new HashMap<String, String>(4);
            properties.put("name", formatter.getName(object));
            properties.put("identifiers", (String)formatter.getIdentifier(object));
            formatter.append(new AbstractIdentifiedObject(properties){

                @Override
                protected String formatWKT(Formatter formatter) {
                    return type;
                }
            });
        }
    }
}

