/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.util.logging.Level;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.PlanarProjection;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.EquatorialOrthographic;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ObliqueOrthographic;
import org.geotools.referencing.operation.projection.PolarOrthographic;

public abstract class Orthographic
extends MapProjection {
    private static final long serialVersionUID = -6489939032996419868L;
    private static final double EPSILON = 1.0E-6;

    protected Orthographic(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public static final class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 3180410512573499562L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Orthographic"), new NamedIdentifier(Citations.GEOTIFF, "CT_Orthographic"), new NamedIdentifier(Citations.ESRI, "Orthographic"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)160))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<PlanarProjection> getOperationType() {
            return PlanarProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            double latitudeOfOrigin = Math.abs(MapProjection.AbstractProvider.doubleValue(LATITUDE_OF_ORIGIN, parameters));
            if (!Provider.isSpherical(parameters)) {
                MapProjection.LOGGER.log(Level.FINE, "GeoTools Orthographic is defined only on the sphere, we're going to use spherical equations even if the projection is using an ellipsoid");
            }
            if (Math.abs(latitudeOfOrigin - 1.5707963267948966) < 1.0E-6) {
                return new PolarOrthographic(parameters);
            }
            if (latitudeOfOrigin < 1.0E-6) {
                return new EquatorialOrthographic(parameters);
            }
            return new ObliqueOrthographic(parameters);
        }
    }
}

