/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.geotools.referencing.operation.projection.Stereographic;
import si.uom.NonSI;

public class PolarStereographic
extends Stereographic {
    private static final long serialVersionUID = -6635298308431138524L;
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    private static final double EPSILON = 1.0E-8;
    private final double k0;
    final double standardParallel;
    final boolean southPole;
    private final boolean poleForced;

    PolarStereographic(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor, Boolean forceSouthPole) throws ParameterNotFoundException {
        super(parameters, descriptor);
        ParameterDescriptor trueScaleDescriptor = Boolean.TRUE.equals(forceSouthPole) ? ProviderSouth.STANDARD_PARALLEL : ProviderNorth.STANDARD_PARALLEL;
        List expected = descriptor.descriptors();
        double latitudeTrueScale = this.isExpectedParameter(expected, trueScaleDescriptor) ? this.doubleValue(expected, trueScaleDescriptor, parameters) : (this.latitudeOfOrigin < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
        PolarStereographic.ensureLatitudeInRange(trueScaleDescriptor, latitudeTrueScale, true);
        boolean bl = this.poleForced = forceSouthPole != null;
        if (this.poleForced) {
            this.southPole = forceSouthPole;
            latitudeTrueScale = Math.abs(latitudeTrueScale);
            if (this.southPole) {
                latitudeTrueScale = -latitudeTrueScale;
            }
        } else {
            this.southPole = latitudeTrueScale < 0.0;
        }
        this.latitudeOfOrigin = this.southPole ? -1.5707963267948966 : 1.5707963267948966;
        this.standardParallel = latitudeTrueScale;
        if (Math.abs((latitudeTrueScale = Math.abs(latitudeTrueScale)) - 1.5707963267948966) >= 1.0E-8) {
            double t = Math.sin(latitudeTrueScale);
            this.k0 = this.msfn(t, Math.cos(latitudeTrueScale)) / this.tsfn(latitudeTrueScale, t);
        } else {
            this.k0 = 2.0 / Math.sqrt(Math.pow(1.0 + this.excentricity, 1.0 + this.excentricity) * Math.pow(1.0 - this.excentricity, 1.0 - this.excentricity));
        }
    }

    @Override
    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double sinlat = Math.sin(y);
        double coslon = Math.cos(x);
        double sinlon = Math.sin(x);
        if (this.southPole) {
            double rho = this.k0 * this.tsfn(-y, -sinlat);
            x = rho * sinlon;
            y = rho * coslon;
        } else {
            double rho = this.k0 * this.tsfn(y, sinlat);
            x = rho * sinlon;
            y = -rho * coslon;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double phi;
        double rho;
        block3: {
            rho = Math.hypot(x, y);
            if (this.southPole) {
                y = -y;
            }
            double t = rho / this.k0;
            double halfe = this.excentricity / 2.0;
            double phi0 = 0.0;
            int i = 15;
            do {
                double esinphi;
                if (Math.abs((phi = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - (esinphi = this.excentricity * Math.sin(phi0))) / (1.0 + esinphi), halfe))) - phi0) < 1.0E-10) break block3;
                phi0 = phi;
            } while (--i >= 0);
            throw new ProjectionException("Transformation doesn't convergence.");
        }
        x = Math.abs(rho) < 1.0E-8 ? 0.0 : Math.atan2(x, -y);
        y = this.southPole ? -phi : phi;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterDescriptor trueScaleDescriptor = this.poleForced ? (this.southPole ? ProviderSouth.STANDARD_PARALLEL : ProviderNorth.STANDARD_PARALLEL) : ProviderB.STANDARD_PARALLEL;
        ParameterValueGroup values = super.getParameterValues();
        List expected = this.getParameterDescriptors().descriptors();
        this.set(expected, trueScaleDescriptor, values, this.standardParallel);
        return values;
    }

    @Override
    public int hashCode() {
        long code = Double.doubleToLongBits(this.k0);
        return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            PolarStereographic that = (PolarStereographic)object;
            return this.southPole == that.southPole && PolarStereographic.equals(this.k0, that.k0) && PolarStereographic.equals(this.standardParallel, that.standardParallel);
        }
        return false;
    }

    public static final class ProviderSouth
    extends Stereographic.Provider {
        private static final long serialVersionUID = 6537800238416448564L;
        public static final ParameterDescriptor STANDARD_PARALLEL = ProviderSouth.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Standard_Parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of standard parallel")}, -90.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = ProviderSouth.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Stereographic_South_Pole"), new NamedIdentifier(Citations.GEOTOOLS, Stereographic.Provider.NAME)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, STANDARD_PARALLEL, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public ProviderSouth() {
            super(PARAMETERS);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            if (ProviderSouth.isSpherical(parameters)) {
                return new Spherical(parameters, PARAMETERS, Boolean.TRUE);
            }
            return new PolarStereographic(parameters, PARAMETERS, Boolean.TRUE);
        }
    }

    public static final class ProviderNorth
    extends Stereographic.Provider {
        private static final long serialVersionUID = 657493908431273866L;
        public static final ParameterDescriptor STANDARD_PARALLEL = ProviderNorth.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Standard_Parallel_1"), new NamedIdentifier(Citations.EPSG, "Latitude of standard parallel")}, 90.0, -90.0, 90.0, NonSI.DEGREE_ANGLE);
        static final ParameterDescriptorGroup PARAMETERS = ProviderNorth.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.ESRI, "Stereographic_North_Pole"), new NamedIdentifier(Citations.GEOTOOLS, Stereographic.Provider.NAME)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, STANDARD_PARALLEL, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public ProviderNorth() {
            super(PARAMETERS);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            if (ProviderNorth.isSpherical(parameters)) {
                return new Spherical(parameters, PARAMETERS, Boolean.FALSE);
            }
            return new PolarStereographic(parameters, PARAMETERS, Boolean.FALSE);
        }
    }

    public static final class ProviderB
    extends Stereographic.Provider {
        private static final long serialVersionUID = 5188231050523249971L;
        public static final ParameterDescriptor STANDARD_PARALLEL = ProviderNorth.STANDARD_PARALLEL;
        static final ParameterDescriptorGroup PARAMETERS = ProviderB.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Polar Stereographic (variant B)"), new NamedIdentifier(Citations.EPSG, "9829"), new NamedIdentifier(Citations.GEOTOOLS, Stereographic.Provider.NAME)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, STANDARD_PARALLEL, FALSE_EASTING, FALSE_NORTHING});

        public ProviderB() {
            super(PARAMETERS);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            if (ProviderB.isSpherical(parameters)) {
                return new Spherical(parameters, PARAMETERS, null);
            }
            return new Series(parameters, PARAMETERS, null);
        }
    }

    public static final class ProviderA
    extends Stereographic.Provider {
        private static final long serialVersionUID = 9124091259039220308L;
        static final ParameterDescriptorGroup PARAMETERS = ProviderA.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Polar_Stereographic"), new NamedIdentifier(Citations.EPSG, "Polar Stereographic (variant A)"), new NamedIdentifier(Citations.EPSG, "9810"), new NamedIdentifier(Citations.GEOTIFF, "CT_PolarStereographic"), new NamedIdentifier(Citations.GEOTOOLS, Stereographic.Provider.NAME)}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public ProviderA() {
            super(PARAMETERS);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            if (ProviderA.isSpherical(parameters)) {
                return new Spherical(parameters, PARAMETERS, null);
            }
            return new Series(parameters, PARAMETERS, null);
        }
    }

    static final class Series
    extends PolarStereographic {
        private static final long serialVersionUID = 2795404156883313290L;
        private final double A;
        private final double B;
        private double C;
        private double D;
        private final double k0;

        Series(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor, Boolean forceSouthPole) throws ParameterNotFoundException {
            super(parameters, descriptor, forceSouthPole);
            double e4 = this.excentricitySquared * this.excentricitySquared;
            double e6 = e4 * this.excentricitySquared;
            double e8 = e4 * e4;
            this.C = 0.058333333333333334 * e6 + 0.07232142857142858 * e8;
            this.D = 0.026531498015873015 * e8;
            this.A = this.excentricitySquared / 2.0 + 0.20833333333333334 * e4 + e6 / 12.0 + 0.03611111111111111 * e8 - this.C;
            this.B = 2.0 * (0.14583333333333334 * e4 + 0.12083333333333333 * e6 + 0.07039930555555556 * e8) - 4.0 * this.D;
            this.C *= 4.0;
            this.D *= 8.0;
            double latTrueScale = Math.abs(this.standardParallel);
            if (Math.abs(latTrueScale - 1.5707963267948966) >= 1.0E-8) {
                double t = Math.sin(latTrueScale);
                this.k0 = this.msfn(t, Math.cos(latTrueScale)) * Math.sqrt(Math.pow(1.0 + this.excentricity, 1.0 + this.excentricity) * Math.pow(1.0 - this.excentricity, 1.0 - this.excentricity)) / (2.0 * this.tsfn(latTrueScale, t));
            } else {
                this.k0 = 1.0;
            }
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            assert ((ptDst = super.inverseTransformNormalized(x, y, ptDst)) != null);
            double rho = Math.hypot(x, y);
            if (this.southPole) {
                y = -y;
            }
            double t = rho / this.k0 * Math.sqrt(Math.pow(1.0 + this.excentricity, 1.0 + this.excentricity) * Math.pow(1.0 - this.excentricity, 1.0 - this.excentricity)) / 2.0;
            double chi = 1.5707963267948966 - 2.0 * Math.atan(t);
            x = Math.abs(rho) < 1.0E-8 ? 0.0 : Math.atan2(x, -y);
            double sin2chi = Math.sin(2.0 * chi);
            double cos2chi = Math.cos(2.0 * chi);
            y = chi + sin2chi * (this.A + cos2chi * (this.B + cos2chi * (this.C + this.D * cos2chi)));
            double d = y = this.southPole ? -y : y;
            assert (Series.checkInverseTransform(x, y, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }
    }

    static final class Spherical
    extends PolarStereographic {
        private static final long serialVersionUID = 1655096575897215547L;
        private final double k0;

        Spherical(ParameterValueGroup parameters, ParameterDescriptorGroup descriptor, Boolean forceSouthPole) throws ParameterNotFoundException {
            super(parameters, descriptor, forceSouthPole);
            this.ensureSpherical();
            double phi = Math.abs(this.standardParallel);
            this.k0 = Math.abs(phi - 1.5707963267948966) >= 1.0E-8 ? 1.0 + Math.sin(phi) : 2.0;
        }

        @Override
        protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            assert ((ptDst = super.transformNormalized(x, y, ptDst)) != null);
            double coslat = Math.cos(y);
            double sinlat = Math.sin(y);
            double coslon = Math.cos(x);
            double sinlon = Math.sin(x);
            if (this.southPole) {
                if (Math.abs(1.0 - sinlat) < 1.0E-8) {
                    throw new ProjectionException("Numerical value tend toward infinity.");
                }
                double f = this.k0 * coslat / (1.0 - sinlat);
                x = f * sinlon;
                y = f * coslon;
            } else {
                if (Math.abs(1.0 + sinlat) < 1.0E-8) {
                    throw new ProjectionException("Numerical value tend toward infinity.");
                }
                double f = this.k0 * coslat / (1.0 + sinlat);
                x = f * sinlon;
                y = -f * coslon;
            }
            assert (Spherical.checkTransform(x, y, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            assert ((ptDst = super.inverseTransformNormalized(x, y, ptDst)) != null);
            double rho = Math.hypot(x, y);
            if (!this.southPole) {
                y = -y;
            }
            double d = x = Math.abs(x) < 1.0E-8 && Math.abs(y) < 1.0E-8 ? 0.0 : Math.atan2(x, y);
            if (Math.abs(rho) < 1.0E-8) {
                y = this.latitudeOfOrigin;
            } else {
                double c = 2.0 * Math.atan(rho / this.k0);
                double cosc = Math.cos(c);
                double d2 = y = this.southPole ? Math.asin(-cosc) : Math.asin(cosc);
            }
            assert (Spherical.checkInverseTransform(x, y, ptDst));
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }
    }
}

