/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform1D;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect;

final class ConcatenatedTransformDirect1D
extends ConcatenatedTransformDirect
implements MathTransform1D {
    private static final long serialVersionUID = 1064398659892864966L;
    private final MathTransform1D transform1;
    private final MathTransform1D transform2;

    public ConcatenatedTransformDirect1D(MathTransform1D transform1, MathTransform1D transform2) {
        super((MathTransform)transform1, (MathTransform)transform2);
        this.transform1 = transform1;
        this.transform2 = transform2;
    }

    @Override
    boolean isValid() {
        return super.isValid() && this.getSourceDimensions() == 1 && this.getTargetDimensions() == 1;
    }

    public double transform(double value) throws TransformException {
        return this.transform2.transform(this.transform1.transform(value));
    }

    public double derivative(double value) throws TransformException {
        double value1 = this.transform1.derivative(value);
        double value2 = this.transform2.derivative(this.transform1.transform(value));
        return value2 * value1;
    }

    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return (MathTransform1D)super.inverse();
    }
}

