/**
 * @author sbarthon
 * @date 26/11/21
 * @version 1.0.0
 * @project SIEau
 * @table agri_declarations_mat_maj
 */

# --- !Ups
CREATE TABLE IF NOT EXISTS AGRI_COMPTA_SERVICES (
                                                    idService bigint,
                                                    identifiantTechnique character varying(25),
    codeProduit character varying(25),
    designation text,
    dateDebut timestamp with time zone,
    dateFin timestamp with time zone,
    dateMaj timestamp with time zone,
                          loginMaj character varying(25)
    );
CREATE UNIQUE INDEX IF NOT EXISTS pk_agri_compta_services ON AGRI_COMPTA_SERVICES (idService);
CREATE TABLE IF NOT EXISTS AGRI_EXPLOITATIONS_COMPTA  (
                                                          codeExploitation bigint,
                                                          idService bigint,
                                                          dateDebut timestamp with time zone,
                                                          dateFin timestamp with time zone,
                                                          occurence bigint,
                                                          unite  bigint,
                                                          quantite integer,
                                                          commentaire text,
                                                          dateMaj timestamp with time zone,
                                                          loginMaj character varying(25)
    );
CREATE INDEX IF NOT EXISTS pk_agri_exploitations_compta ON agri_exploitations_compta (codeExploitation);
delete from codes_sandre where champ='COMPTA.OCCURENCE';
insert into codes_sandre values ('COMPTA.OCCURENCE',0, 'Inconnu');
insert into codes_sandre values ('COMPTA.OCCURENCE',1, 'Unitaire');
insert into codes_sandre values ('COMPTA.OCCURENCE',2, 'Journalière');
insert into codes_sandre values ('COMPTA.OCCURENCE',3, 'Hebdomadaire');
insert into codes_sandre values ('COMPTA.OCCURENCE',4, 'Mensuelle');
insert into codes_sandre values ('COMPTA.OCCURENCE',5, 'Annuelle');
delete from codes_sandre where champ='COMPTA.UNITE';
insert into codes_sandre values ('COMPTA.UNITE',0, 'Inconnu');
insert into codes_sandre values ('COMPTA.UNITE',1, 'Nb jours');
insert into codes_sandre values ('COMPTA.UNITE',2, 'Nb mois');
insert into codes_sandre values ('COMPTA.UNITE',3, 'Nb services');

# --- !Downs