/**
 * @author sbarthon
 * @date 08/12/21
 * @version 1.0.0
 * @project SIEau
 * @table chroniques_pluvio
 */

# --- !Ups
create table aep_captages(
    idCaptage integer,
    identifiant character varying(25),
    nom character varying(255),
    bassin integer, -- codes_sandre AGENCES
    departement integer,
    codeBNPE varchar(25),
    typeprelevement integer, -- codes_sandre TYPE_PRELEVEMENT
    ouvrageSDAGE boolean,
    ouvrageGrenelle boolean,
    codeMe character varying(25),
    numAAC  character varying(25),
    etatEtude integer, -- codes_sandre ETAT_DOSSIER
    etatDiagnosticPression integer, -- codes_sandre ETAT_DOSSIER
    etatPlanAction integer, -- codes_sandre ETAT_PLAN
    problematique  character varying(255),
    surfaceAAC double precision);

create unique index pk_aep_captages on aep_captages (idcaptage);

insert into codes_sandre values ('ETAT_DOSSIER',0,'Inconnu');
insert into codes_sandre values ('ETAT_DOSSIER',1,'En cours');
insert into codes_sandre values ('ETAT_DOSSIER',2,'Finie');
insert into codes_sandre values ('ETAT_DOSSIER',3,'Archivée');
insert into codes_sandre values ('ETAT_PLAN',0,'Inconnu');
insert into codes_sandre values ('ETAT_PLAN',1,'A l''étude');
insert into codes_sandre values ('ETAT_PLAN',2,'Plan élaboré');
insert into codes_sandre values ('AGENCES',1,'Adour Garonne');
insert into codes_sandre values ('AGENCES',2,'Artois Picardis');
insert into codes_sandre values ('AGENCES',3,'Loire Bretagne');
insert into codes_sandre values ('AGENCES',4,'Rhin Meuse');
insert into codes_sandre values ('AGENCES',5,'Rhône Méditerranée Corse');
insert into codes_sandre values ('AGENCES',6,'Seine Normandie');

create table aep_captages_points(
    idCaptage integer,
    codeBSS character varying(25),
    maitreOuvrage integer,
    pointPrincipal boolean
);
create unique index pk_aep_captages_points on aep_captages_points (idcaptage, codeBSS);

# --- !Downs
