/**
 * @author sbarthon
 * @date 20/12/21
 * @version 1.0.0
 * @project SIEau
 * @table chroniques_pluvio
 */

# --- !Ups

ALTER TABLE aep_captages DROP COLUMN IF EXISTS codeinstallation;
ALTER TABLE aep_captages DROP COLUMN IF EXISTS siteproduction;
ALTER TABLE aep_captages DROP COLUMN IF EXISTS codeaac;
ALTER TABLE aep_captages DROP COLUMN IF EXISTS origineprelevement;
ALTER TABLE aep_captages DROP COLUMN IF EXISTS qmoyj;
ALTER TABLE aep_captages DROP COLUMN IF EXISTS natureeau;
ALTER TABLE aep_captages DROP COLUMN IF EXISTS codeentitehydro;


ALTER TABLE aep_captages add column if not exists idCaptage integer;
ALTER TABLE aep_captages add column if not exists identifiant character varying(25);
ALTER TABLE aep_captages add column if not exists nom character varying(255);
ALTER TABLE aep_captages add column if not exists bassin integer; -- codes_sandre AGENCES
ALTER TABLE aep_captages add column if not exists departement integer;
ALTER TABLE aep_captages add column if not exists codeBNPE varchar(25);
ALTER TABLE aep_captages add column if not exists typeprelevement integer; -- codes_sandre TYPE_PRELEVEMENT
ALTER TABLE aep_captages add column if not exists ouvrageSDAGE boolean;
ALTER TABLE aep_captages add column if not exists ouvrageGrenelle boolean;
ALTER TABLE aep_captages add column if not exists codeMe character varying(25);
ALTER TABLE aep_captages add column if not exists numAAC  character varying(25);
ALTER TABLE aep_captages add column if not exists etatEtude integer; -- codes_sandre ETAT_DOSSIER
ALTER TABLE aep_captages add column if not exists etatDiagnosticPression integer; -- codes_sandre ETAT_DOSSIER
ALTER TABLE aep_captages add column if not exists  etatPlanAction integer; -- codes_sandre ETAT_PLAN
ALTER TABLE aep_captages add column if not exists problematique  character varying(255);
ALTER TABLE aep_captages add column if not exists surfaceAAC double precision;

create unique index pk_aep_captages on aep_captages (idcaptage);

insert into codes_sandre values ('ETAT_DOSSIER',0,'Inconnu');
insert into codes_sandre values ('ETAT_DOSSIER',1,'En cours');
insert into codes_sandre values ('ETAT_DOSSIER',2,'Finie');
insert into codes_sandre values ('ETAT_DOSSIER',3,'Archivée');
insert into codes_sandre values ('ETAT_PLAN',0,'Inconnu');
insert into codes_sandre values ('ETAT_PLAN',1,'A l''étude');
insert into codes_sandre values ('ETAT_PLAN',2,'Plan élaboré');
insert into codes_sandre values ('AGENCES',1,'Adour Garonne');
insert into codes_sandre values ('AGENCES',2,'Artois Picardis');
insert into codes_sandre values ('AGENCES',3,'Loire Bretagne');
insert into codes_sandre values ('AGENCES',4,'Rhin Meuse');
insert into codes_sandre values ('AGENCES',5,'Rhône Méditerranée Corse');
insert into codes_sandre values ('AGENCES',6,'Seine Normandie');

create table aep_captages_points(
    idCaptage integer,
    codeBSS character varying(25),
    maitreOuvrage integer,
    pointPrincipal boolean
);
create unique index pk_aep_captages_points on aep_captages_points (idcaptage, codeBSS);

# --- !Downs
