/**
 * @author tpasquet
 * @date 27/12/21
 * @version 1.0.0
 * @project SIEau
 * @table chroniques_hydro
 */

# --- !Ups
drop table if exists chroniques_hydro;
create table chroniques_hydro
(
    codestation               bigint                   not null,
    typeid                    integer                  not null,
    datemesure                timestamp with time zone not null,
    valeurmesure              real                     not null,
    valeurngf                 real,
    cotechronique             real,
    valeurmesurecorrigee      real,
    valeurngfcorrigee         real,
    modemesure                integer,
    statutmesure              integer,
    qualificationmesure       integer,
    naturemesure              varchar(1),
    pointinitial              integer,
    referencealtimetrique     real,
    repere                    real,
    coderesponsablevalidation integer,
    codegestionnaire          integer,
    codeproducteur            integer,
    jobexecutionid            bigint,
    datecreation              timestamp with time zone,
    datemaj                   timestamp with time zone,
    loginmaj                  varchar(25)
);

create unique index chroniques_hydro_codestation_typeid_datemesure_idx
    on chroniques_hydro (codestation, typeid, datemesure);


drop table if exists chroniques_hydro_suppr;
create table chroniques_hydro_suppr
(
    codestation               bigint                   not null,
    typeid                    integer                  not null,
    datemesure                timestamp with time zone not null,
    valeurmesure              real                     not null,
    valeurngf                 real,
    cotechronique             real,
    valeurmesurecorrigee      real,
    valeurngfcorrigee         real,
    modemesure                integer,
    statutmesure              integer,
    qualificationmesure       integer,
    naturemesure              varchar(1),
    pointinitial              integer,
    referencealtimetrique     real,
    repere                    real,
    coderesponsablevalidation integer,
    codegestionnaire          integer,
    codeproducteur            integer,
    jobexecutionid            bigint,
    datecreation              timestamp with time zone,
    datemaj                   timestamp with time zone,
    loginmaj                  varchar(25)
);

create unique index chroniques_hydro_suppr_codestation_typeid_datemesure_idx
    on chroniques_hydro_suppr (codestation, typeid, datemesure);

drop table if exists chroniques_hydro_calcul;
create table chroniques_hydro_calcul
(
    codestation    integer,
    typeid         integer,
    datemesure     timestamp with time zone,
    valeurmesure   real,
    pointinitial   integer,
    datecreation   timestamp with time zone,
    idmodele       integer,
    idindicateur   integer,
    incertitudemin real,
    incertitudemax real,
    classe         integer,
    tendance       integer
);

create index ind_chroniques_hydro_calcul
    on chroniques_hydro_calcul (codestation, typeid);




# --- !Downs
