/**
 * @author tpasquet
 * @date 31/12/21
 * @version 1.0.0
 * @project SIEau
 * @table getallhydromeasures
 */

# --- !Ups
create or replace function getallhydromeasures(p_stationids integer[], p_filtreid character varying, p_codegestionnaire integer, p_loginmaj character varying, p_job_execution_id integer) returns double precision
    language plpgsql
as
$$
DECLARE
my_cursor_measures 				      REFCURSOR;;
    my_cursor_stations              REFCURSOR;;
    measure 							          RECORD;;
    v_requete 						          VARCHAR (2000);;
    v_requete_curseur					  VARCHAR (2000);;
    v_requete_count				          VARCHAR (2000);;
    d_count 							          double precision;;
    d_count_ch						          double precision;;
    d_count_chb 						        double precision;;
    d_count_chbs 						        double precision;;
    d_count_chbc 						        double precision;;
    d_count_repere					        double precision;;
    d_count_intervenant				      double precision;;
    d_count_modif                   double precision;;
    v_codehydro 						          VARCHAR (20);;
    d_j 								            double precision;;
    i_codestation                integer;;
    v_requete_filtre    				    VARCHAR (2000);;
    v_rupture                       VARCHAR (100);;
    v_dateEtHeure                   VARCHAR(100);;
    d_id_job                        double precision;;
    b_integration                   boolean;;

BEGIN

    v_requete := '';;
    d_count := 0;;
    d_count_ch := 0;;
    d_count_chb := 0;;
    d_count_chbs := 0;;
    d_count_chbc := 0;;
    d_count_repere := 0;;
    d_count_intervenant := 0;;
    d_count_modif := 0;;
    d_id_job := 0;;
    b_integration := true;;

/* Table de logs */
DROP TABLE IF EXISTS ebonneau_logs;;
CREATE TABLE ebonneau_logs (id double precision, commentaire text, valeur text, execution_timestamp timestamp, station varchar(255), job_execution_id integer);;

/*RAISE NOTICE 'Initialisation du traitement;;*/
INSERT INTO ebonneau_logs VALUES(d_id_job, 'Initialisation du traitement', null, now(), null, p_job_execution_id);;
d_id_job := d_id_job +1;;

/* Liste des dates à exclures */
DROP TABLE IF EXISTS date_a_exclure;;
CREATE TABLE date_a_exclure(date varchar);;
insert into date_a_exclure VALUES ('26/03/2000 02:00:00'),
                                  ('25/03/2001 02:00:00'),
                                  ('31/03/2002 02:00:00'),
                                  ('30/03/2003 02:00:00'),
                                  ('28/03/2004 02:00:00'),
                                  ('27/03/2005 02:00:00'),
                                  ('26/03/2006 02:00:00'),
                                  ('25/03/2007 02:00:00'),
                                  ('30/03/2008 02:00:00'),
                                  ('29/03/2009 02:00:00'),
                                  ('28/03/2010 02:00:00'),
                                  ('27/03/2011 02:00:00'),
                                  ('25/03/2012 02:00:00'),
                                  ('31/03/2013 02:00:00'),
                                  ('30/03/2014 02:00:00'),
                                  ('29/03/2015 02:00:00'),
                                  ('27/03/2016 02:00:00'),
                                  ('26/03/2017 02:00:00'),
                                  ('25/03/2018 02:00:00'),
                                  ('31/03/2019 02:00:00'),
                                  ('29/03/2020 02:00:00');;

IF p_stationIds is not null THEN
        OPEN my_cursor_stations FOR SELECT codestation FROM stations_hydro WHERE codestation = ANY(p_stationIds);;
ELSE
        IF p_filtreId is not null THEN
SELECT selectionfiltre INTO v_requete_filtre FROM utilisateurs_listes
WHERE module = 'SIH'
  AND codeliste = p_filtreId;;
OPEN my_cursor_stations FOR EXECUTE v_requete_filtre;;
ELSE
            OPEN my_cursor_stations FOR SELECT codestation FROM stations_hydro /*where codestation = 1*/;;
END IF;;
END IF;;

    LOOP
FETCH my_cursor_stations INTO i_codestation;;
        EXIT WHEN NOT FOUND;;

/* Récupération du codehydro de la station */
SELECT codehydro INTO v_codehydro FROM stations_hydro
WHERE codestation = i_codestation;;

--RAISE NOTICE 'Traitement de la station %', v_codehydro;;
INSERT INTO ebonneau_logs VALUES(d_id_job, 'Traitement de la station', null, now(), v_codehydro, p_job_execution_id);;

d_id_job := d_id_job +1;;

        IF v_codehydro <> '' THEN

            --RAISE NOTICE 'Suppression des données existantes dans les tables de destination';;
            INSERT INTO ebonneau_logs VALUES(d_id_job, 'Suppression des données existantes dans les tables de destination', null, now(), v_codehydro, p_job_execution_id);;
            d_id_job := d_id_job +1;;

DELETE FROM chroniques_hydro WHERE codestation=i_codestation;;
DELETE FROM chroniques_hydro_suppr WHERE codestation=i_codestation;;

--RAISE NOTICE 'ETAPE 1: Intégration des données brutes hydro_<id>_brute';;
INSERT INTO ebonneau_logs VALUES(d_id_job, 'ETAPE 1: Intégration des données brutes', null, now(), v_codehydro, p_job_execution_id);;
d_id_job := d_id_job +1;;

            v_requete_curseur := 'SELECT datecreation, heure, valeur, debit, ';;
            v_requete_curseur := v_requete_curseur || ' vitesse,';;
            v_requete_curseur := v_requete_curseur || ' continuite, modeobtention, cast(precision as double precision) as precision, validite, qualification';;
            v_requete_curseur := v_requete_curseur || ' from hydro_' || i_codestation || '_brute ORDER BY datecreation ASC, heure ASC';;

            d_j := 0;;
            v_rupture := '0';;

BEGIN
EXECUTE v_requete_curseur;;
b_integration := true;;
EXCEPTION
                WHEN undefined_table THEN
                    --RAISE NOTICE '[UNDEFINED TABLE] Error on STEP 1 during table select : %', v_codehydro;;
                    INSERT INTO ebonneau_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on STEP 1 on getting data', v_requete_curseur, now(), v_codehydro, p_job_execution_id);;
                    d_id_job := d_id_job +1;;
                    b_integration := false;;
WHEN OTHERS THEN
                    --RAISE NOTICE '[OTHERS] Error % on STEP 1 during table select : %', SQLERRM, v_codehydro;;
                    INSERT INTO ebonneau_logs VALUES(d_id_job, '[OTHERS] Error '|| SQLERRM ||' on STEP 1 on getting data', v_requete_curseur, now(), v_codehydro, p_job_execution_id);;
                    d_id_job := d_id_job +1;;
                    b_integration := false;;
end;;

            IF b_integration = true THEN
                OPEN my_cursor_measures FOR EXECUTE v_requete_curseur;;
                LOOP
FETCH my_cursor_measures into measure;;
                    EXIT WHEN NOT FOUND;;

                    v_requete := '';;
                    IF measure.valeur is not null THEN
--PLUIE
                        v_requete := 'insert into chroniques_hydro (codestation,typeid,datemesure,valeurmesure,valeurmesurecorrigee,modemesure,statutmesure,qualificationmesure,naturemesure,pointinitial,coderesponsablevalidation,codegestionnaire,codeproducteur,jobexecutionid,datecreation,datemaj,loginmaj) values ';;
                        v_requete := v_requete || '(';;
                        v_requete := v_requete || i_codestation || ', ';;
--RAISE NOTICE 'CB i_codestation : %', i_codestation;;
                        v_requete := v_requete || '4, ';; /* pluie */
                        IF measure.datecreation is null OR measure.heure is null THEN
                            v_requete := v_requete || 'null, ';;
ELSE
                            v_dateEtHeure := to_char(measure.datecreation, 'DD/MM/YYYY') ||' '||to_char(measure.heure, 'HH24:MI:SS');;
END IF;;
                        v_requete := v_requete || '''' || v_dateEtHeure || ''', ';;
                        v_requete := v_requete || measure.valeur || ', ';;
                        v_requete := v_requete || 'null, ';; /* valeurmesurecorrigée */
                        IF measure.modeobtention = 'A' THEN
                            v_requete := v_requete || '1, ';;  /* mode mesure */
                        ELSEIF measure.modeobtention = 'M' THEN
                            v_requete := v_requete || '2, ';;  /* mode mesure */
ELSE
                            v_requete := v_requete || '0, ';;  /* mode mesure */
END IF;;
--RAISE NOTICE 'CB measure.modeobtention : %', measure.modeobtention;;
                        IF measure.validite = '' or measure.validite is null THEN
                            v_requete := v_requete || '1, ';; /* statutMesure brute */
ELSE
                            v_requete := v_requete || measure.validite || ', ';; /* statutMesure */
END IF;;
--RAISE NOTICE 'CB measure.validite : %', measure.validite;;
                        IF measure.qualification = '' or measure.qualification is null THEN
                            v_requete := v_requete || '4, ';; /* qualificationMesure non qualifiée */
ELSE
                            v_requete := v_requete || measure.qualification || ', ';; /* qualification */
END IF;;
                        v_requete := v_requete || 'null, ';;   /* natureMesure non renseignée */
                        IF d_j = 0 THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
                            v_rupture := measure.continuite || '';;
                        ELSEIF v_rupture = '1' THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
ELSE
                            v_requete := v_requete || '2, ';;  /* point continu */
END IF;;
--RAISE NOTICE 'CB d_j : %', d_j;;
                        v_rupture := measure.continuite || '';;
                        v_requete := v_requete || 'null, ';;  /* codeReponsableValidation */
                        v_requete := v_requete || 'null, ';;  /* codeGestionnaire */
                        v_requete := v_requete || 'null, ';;  /* codeProducteur */
                        v_requete := v_requete || 'null, ';;  /* jobExecutionId */
                        v_requete := v_requete || 'null, ';;  /* dateCreation */
                        v_requete := v_requete || 'null, ';;  /* dateMaj */
                        v_requete := v_requete || 'null ';;  /* loginMaj */
                        v_requete := v_requete || ')';;

BEGIN
                            --RAISE NOTICE 'REQUETE 1 : %', v_requete;;
                            IF v_requete is not null THEN
                                EXECUTE v_requete;;
                                d_j := d_j + 1;;
ELSE
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[NO REQUEST] Error on STEP 1 on valeur : ' || measure, v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END IF;;
EXCEPTION
                            WHEN undefined_table THEN
                                --RAISE NOTICE '[UNDEFINED TABLE] Error on STEP 1 during table insert : %', v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on STEP 1 during table insert valeur', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
WHEN OTHERS THEN
                                --RAISE NOTICE '[OTHERS] Error % on STEP 1 during table insert : %', SQLERRM, v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[OTHERS] Error '|| SQLERRM ||' on STEP 1 during table insert valeur', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END;;
END IF;;

                    IF measure.debit is not null THEN
--PLUIE
                        v_requete := 'insert into chroniques_hydro (codestation,typeid,datemesure,valeurmesure,valeurmesurecorrigee,modemesure,statutmesure,qualificationmesure,naturemesure,pointinitial,coderesponsablevalidation,codegestionnaire,codeproducteur,jobexecutionid,datecreation,datemaj,loginmaj) values ';;
                        v_requete := v_requete || '(';;
                        v_requete := v_requete || i_codestation || ', ';;
--RAISE NOTICE 'CB i_codestation : %', i_codestation;;
                        v_requete := v_requete || '5, ';; /* Débit */
                        IF measure.datecreation is null OR measure.heure is null THEN
                            v_requete := v_requete || 'null, ';;
ELSE
                            v_dateEtHeure := to_char(measure.datecreation, 'DD/MM/YYYY') ||' '||to_char(measure.heure, 'HH24:MI:SS');;
END IF;;
                        v_requete := v_requete || '''' || v_dateEtHeure || ''', ';;
                        v_requete := v_requete || measure.debit || ', ';;
                        v_requete := v_requete || 'null, ';; /* valeurmesurecorrigée */
                        IF measure.modeobtention = 'A' THEN
                            v_requete := v_requete || '1, ';;  /* mode mesure */
                        ELSEIF measure.modeobtention = 'M' THEN
                            v_requete := v_requete || '2, ';;  /* mode mesure */
ELSE
                            v_requete := v_requete || '0, ';;  /* mode mesure */
END IF;;
--RAISE NOTICE 'CB measure.modeobtention : %', measure.modeobtention;;
                        IF measure.validite = '' or measure.validite is null THEN
                            v_requete := v_requete || '1, ';; /* statutMesure brute */
ELSE
                            v_requete := v_requete || measure.validite || ', ';; /* statutMesure */
END IF;;
--RAISE NOTICE 'CB measure.validite : %', measure.validite;;
                        IF measure.qualification = '' or measure.qualification is null THEN
                            v_requete := v_requete || '4, ';; /* qualificationMesure non qualifiée */
ELSE
                            v_requete := v_requete || measure.qualification || ', ';; /* qualification */
END IF;;
                        v_requete := v_requete || 'null, ';;   /* natureMesure non renseignée */
                        IF d_j = 0 THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
                            v_rupture := measure.continuite || '';;
                        ELSEIF v_rupture = '1' THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
ELSE
                            v_requete := v_requete || '2, ';;  /* point continu */
END IF;;
--RAISE NOTICE 'CB d_j : %', d_j;;
                        v_rupture := measure.continuite || '';;
                        v_requete := v_requete || 'null, ';;  /* codeReponsableValidation */
                        v_requete := v_requete || 'null, ';;  /* codeGestionnaire */
                        v_requete := v_requete || 'null, ';;  /* codeProducteur */
                        v_requete := v_requete || 'null, ';;  /* jobExecutionId */
                        v_requete := v_requete || 'null, ';;  /* dateCreation */
                        v_requete := v_requete || 'null, ';;  /* dateMaj */
                        v_requete := v_requete || 'null ';;  /* loginMaj */
                        v_requete := v_requete || ')';;

BEGIN
                            --RAISE NOTICE 'REQUETE 1 : %', v_requete;;
                            IF v_requete is not null THEN
                                EXECUTE v_requete;;
                                d_j := d_j + 1;;
ELSE
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[NO REQUEST] Error on STEP 1 on debit : ' || measure, v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END IF;;
EXCEPTION
                            WHEN undefined_table THEN
                                --RAISE NOTICE '[UNDEFINED TABLE] Error on STEP 1 during table insert : %', v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on STEP 1 during table insert debit', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
WHEN OTHERS THEN
                                --RAISE NOTICE '[OTHERS] Error % on STEP 1 during table insert : %', SQLERRM, v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[OTHERS] Error '|| SQLERRM ||' on STEP 1 during table insert debit', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END;;
END IF;;

                    IF measure.vitesse is not null THEN
--PLUIE
                        v_requete := 'insert into chroniques_hydro (codestation,typeid,datemesure,valeurmesure,valeurmesurecorrigee,modemesure,statutmesure,qualificationmesure,naturemesure,pointinitial,coderesponsablevalidation,codegestionnaire,codeproducteur,jobexecutionid,datecreation,datemaj,loginmaj) values ';;
                        v_requete := v_requete || '(';;
                        v_requete := v_requete || i_codestation || ', ';;
--RAISE NOTICE 'CB i_codestation : %', i_codestation;;
                        v_requete := v_requete || '6, ';; /* vitesse */
                        IF measure.datecreation is null OR measure.heure is null THEN
                            v_requete := v_requete || 'null, ';;
ELSE
                            v_dateEtHeure := to_char(measure.datecreation, 'DD/MM/YYYY') ||' '||to_char(measure.heure, 'HH24:MI:SS');;
END IF;;
                        v_requete := v_requete || '''' || v_dateEtHeure || ''', ';;
                        v_requete := v_requete || measure.valeur || ', ';;
                        v_requete := v_requete || 'null, ';; /* valeurmesurecorrigée */
                        IF measure.modeobtention = 'A' THEN
                            v_requete := v_requete || '1, ';;  /* mode mesure */
                        ELSEIF measure.modeobtention = 'M' THEN
                            v_requete := v_requete || '2, ';;  /* mode mesure */
ELSE
                            v_requete := v_requete || '0, ';;  /* mode mesure */
END IF;;
--RAISE NOTICE 'CB measure.modeobtention : %', measure.modeobtention;;
                        IF measure.validite = '' or measure.validite is null THEN
                            v_requete := v_requete || '1, ';; /* statutMesure brute */
ELSE
                            v_requete := v_requete || measure.validite || ', ';; /* statutMesure */
END IF;;
--RAISE NOTICE 'CB measure.validite : %', measure.validite;;
                        IF measure.qualification = '' or measure.qualification is null THEN
                            v_requete := v_requete || '4, ';; /* qualificationMesure non qualifiée */
ELSE
                            v_requete := v_requete || measure.qualification || ', ';; /* qualification */
END IF;;
                        v_requete := v_requete || 'null, ';;   /* natureMesure non renseignée */
                        IF d_j = 0 THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
                            v_rupture := measure.continuite || '';;
                        ELSEIF v_rupture = '1' THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
ELSE
                            v_requete := v_requete || '2, ';;  /* point continu */
END IF;;
--RAISE NOTICE 'CB d_j : %', d_j;;
                        v_rupture := measure.continuite || '';;
                        v_requete := v_requete || 'null, ';;  /* codeReponsableValidation */
                        v_requete := v_requete || 'null, ';;  /* codeGestionnaire */
                        v_requete := v_requete || 'null, ';;  /* codeProducteur */
                        v_requete := v_requete || 'null, ';;  /* jobExecutionId */
                        v_requete := v_requete || 'null, ';;  /* dateCreation */
                        v_requete := v_requete || 'null, ';;  /* dateMaj */
                        v_requete := v_requete || 'null ';;  /* loginMaj */
                        v_requete := v_requete || ')';;

BEGIN
                            --RAISE NOTICE 'REQUETE 1 : %', v_requete;;
                            IF v_requete is not null THEN
                                EXECUTE v_requete;;
                                d_j := d_j + 1;;
ELSE
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[NO REQUEST] Error on STEP 1 on vitesse : ' || measure, v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END IF;;
EXCEPTION
                            WHEN undefined_table THEN
                                --RAISE NOTICE '[UNDEFINED TABLE] Error on STEP 1 during table insert : %', v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on STEP 1 during table insert vitesse', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
WHEN OTHERS THEN
                                --RAISE NOTICE '[OTHERS] Error % on STEP 1 during table insert : %', SQLERRM, v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[OTHERS] Error '|| SQLERRM ||' on STEP 1 during table insert vitesse', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END;;
END IF;;

END LOOP;;
                d_count_ch := d_j;;
/*RAISE NOTICE 'Nombre de données dans chronique : %', d_count_ch;;*/
INSERT INTO ebonneau_logs VALUES(d_id_job, 'Nombre de données dans chronique : '|| d_count_ch, null, now(), v_codehydro, p_job_execution_id);;
d_id_job := d_id_job +1;;
CLOSE my_cursor_measures;;
END IF;;

--ETAPE 2 ------------------------------------------------------------------------------------------------------------------

            --RAISE NOTICE 'ETAPE 2: Intégration des données hydro_<id>';;
INSERT INTO ebonneau_logs VALUES(d_id_job, 'ETAPE 2: Intégration des données hydro_<id>', null, now(), v_codehydro, p_job_execution_id);;
d_id_job := d_id_job +1;;

            v_requete_curseur := 'SELECT datecreation, heure, valeur, debit, ';;
            v_requete_curseur := v_requete_curseur || ' vitesse,';;
            v_requete_curseur := v_requete_curseur || ' continuite, modeobtention, cast(precision as double precision) as precision, validite, qualification';;
            v_requete_curseur := v_requete_curseur || ' from hydro_' || i_codestation || ' ORDER BY datecreation ASC, heure ASC';;

            d_j := 0;;
            v_rupture := '0';;

BEGIN
EXECUTE v_requete_curseur;;
b_integration := true;;
EXCEPTION
                WHEN undefined_table THEN
                    --RAISE NOTICE '[UNDEFINED TABLE] Error on STEP 2 during table select : %', v_codehydro;;
                    INSERT INTO ebonneau_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on STEP 2 on getting data', v_requete_curseur, now(), v_codehydro, p_job_execution_id);;
                    d_id_job := d_id_job +1;;
                    b_integration := false;;
WHEN OTHERS THEN
                    --RAISE NOTICE '[OTHERS] Error % on STEP 2 during table select : %', SQLERRM, v_codehydro;;
                    INSERT INTO ebonneau_logs VALUES(d_id_job, '[OTHERS] Error '|| SQLERRM ||' on STEP 2 on getting data', v_requete_curseur, now(), v_codehydro, p_job_execution_id);;
                    d_id_job := d_id_job +1;;
                    b_integration := false;;
end;;

            IF b_integration = true THEN
                OPEN my_cursor_measures FOR EXECUTE v_requete_curseur;;
                LOOP
FETCH my_cursor_measures into measure;;
                    EXIT WHEN NOT FOUND;;

                    v_requete := '';;
                    IF measure.valeur is not null THEN
--PLUIE
                        v_requete := 'insert into chroniques_hydro (codestation,typeid,datemesure,valeurmesure,valeurmesurecorrigee,modemesure,statutmesure,qualificationmesure,naturemesure,pointinitial,coderesponsablevalidation,codegestionnaire,codeproducteur,jobexecutionid,datecreation,datemaj,loginmaj) values ';;
                        v_requete := v_requete || '(';;
                        v_requete := v_requete || i_codestation || ', ';;
--RAISE NOTICE 'CB i_codestation : %', i_codestation;;
                        v_requete := v_requete || '4, ';; /* pluie */
                        IF measure.datecreation is null OR measure.heure is null THEN
                            v_requete := v_requete || 'null, ';;
ELSE
                            v_dateEtHeure := to_char(measure.datecreation, 'DD/MM/YYYY') ||' '||to_char(measure.heure, 'HH24:MI:SS');;
END IF;;
                        v_requete := v_requete || '''' || v_dateEtHeure || ''', ';;
                        v_requete := v_requete || measure.valeur || ', ';;
                        v_requete := v_requete || 'null, ';; /* valeurmesurecorrigée */
                        IF measure.modeobtention = 'A' THEN
                            v_requete := v_requete || '1, ';;  /* mode mesure */
                        ELSEIF measure.modeobtention = 'M' THEN
                            v_requete := v_requete || '2, ';;  /* mode mesure */
ELSE
                            v_requete := v_requete || '0, ';;  /* mode mesure */
END IF;;
--RAISE NOTICE 'CB measure.modeobtention : %', measure.modeobtention;;
                        IF measure.validite = '' or measure.validite is null THEN
                            v_requete := v_requete || '1, ';; /* statutMesure brute */
ELSE
                            v_requete := v_requete || measure.validite || ', ';; /* statutMesure */
END IF;;
--RAISE NOTICE 'CB measure.validite : %', measure.validite;;
                        IF measure.qualification = '' or measure.qualification is null THEN
                            v_requete := v_requete || '4, ';; /* qualificationMesure non qualifiée */
ELSE
                            v_requete := v_requete || measure.qualification || ', ';; /* qualification */
END IF;;
                        v_requete := v_requete || 'null, ';;   /* natureMesure non renseignée */
                        IF d_j = 0 THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
                            v_rupture := measure.continuite || '';;
                        ELSEIF v_rupture = '1' THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
ELSE
                            v_requete := v_requete || '2, ';;  /* point continu */
END IF;;
--RAISE NOTICE 'CB d_j : %', d_j;;
                        v_rupture := measure.continuite || '';;
                        v_requete := v_requete || 'null, ';;  /* codeReponsableValidation */
                        v_requete := v_requete || 'null, ';;  /* codeGestionnaire */
                        v_requete := v_requete || 'null, ';;  /* codeProducteur */
                        v_requete := v_requete || 'null, ';;  /* jobExecutionId */
                        v_requete := v_requete || 'null, ';;  /* dateCreation */
                        v_requete := v_requete || 'null, ';;  /* dateMaj */
                        v_requete := v_requete || 'null ';;  /* loginMaj */
                        v_requete := v_requete || ')';;

BEGIN
                            --RAISE NOTICE 'REQUETE 2 : %', v_requete;;
                            IF v_requete is not null THEN
                                EXECUTE v_requete;;
                                d_j := d_j + 1;;
ELSE
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[NO REQUEST] Error on STEP 2 on valeur : ' || measure, v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END IF;;
EXCEPTION
                            WHEN undefined_table THEN
                                --RAISE NOTICE '[UNDEFINED TABLE] Error on STEP 1 during table insert : %', v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on STEP 2 during table insert valeur', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
WHEN OTHERS THEN
                                --RAISE NOTICE '[OTHERS] Error % on STEP 1 during table insert : %', SQLERRM, v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[OTHERS] Error '|| SQLERRM ||' on STEP 2 during table insert valeur', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END;;
END IF;;

                    IF measure.debit is not null THEN
--PLUIE
                        v_requete := 'insert into chroniques_hydro (codestation,typeid,datemesure,valeurmesure,valeurmesurecorrigee,modemesure,statutmesure,qualificationmesure,naturemesure,pointinitial,coderesponsablevalidation,codegestionnaire,codeproducteur,jobexecutionid,datecreation,datemaj,loginmaj) values ';;
                        v_requete := v_requete || '(';;
                        v_requete := v_requete || i_codestation || ', ';;
--RAISE NOTICE 'CB i_codestation : %', i_codestation;;
                        v_requete := v_requete || '5, ';; /* Débit */
                        IF measure.datecreation is null OR measure.heure is null THEN
                            v_requete := v_requete || 'null, ';;
ELSE
                            v_dateEtHeure := to_char(measure.datecreation, 'DD/MM/YYYY') ||' '||to_char(measure.heure, 'HH24:MI:SS');;
END IF;;
                        v_requete := v_requete || '''' || v_dateEtHeure || ''', ';;
                        v_requete := v_requete || measure.debit || ', ';;
                        v_requete := v_requete || 'null, ';; /* valeurmesurecorrigée */
                        IF measure.modeobtention = 'A' THEN
                            v_requete := v_requete || '1, ';;  /* mode mesure */
                        ELSEIF measure.modeobtention = 'M' THEN
                            v_requete := v_requete || '2, ';;  /* mode mesure */
ELSE
                            v_requete := v_requete || '0, ';;  /* mode mesure */
END IF;;
--RAISE NOTICE 'CB measure.modeobtention : %', measure.modeobtention;;
                        IF measure.validite = '' or measure.validite is null THEN
                            v_requete := v_requete || '1, ';; /* statutMesure brute */
ELSE
                            v_requete := v_requete || measure.validite || ', ';; /* statutMesure */
END IF;;
--RAISE NOTICE 'CB measure.validite : %', measure.validite;;
                        IF measure.qualification = '' or measure.qualification is null THEN
                            v_requete := v_requete || '4, ';; /* qualificationMesure non qualifiée */
ELSE
                            v_requete := v_requete || measure.qualification || ', ';; /* qualification */
END IF;;
                        v_requete := v_requete || 'null, ';;   /* natureMesure non renseignée */
                        IF d_j = 0 THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
                            v_rupture := measure.continuite || '';;
                        ELSEIF v_rupture = '1' THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
ELSE
                            v_requete := v_requete || '2, ';;  /* point continu */
END IF;;
--RAISE NOTICE 'CB d_j : %', d_j;;
                        v_rupture := measure.continuite || '';;
                        v_requete := v_requete || 'null, ';;  /* codeReponsableValidation */
                        v_requete := v_requete || 'null, ';;  /* codeGestionnaire */
                        v_requete := v_requete || 'null, ';;  /* codeProducteur */
                        v_requete := v_requete || 'null, ';;  /* jobExecutionId */
                        v_requete := v_requete || 'null, ';;  /* dateCreation */
                        v_requete := v_requete || 'null, ';;  /* dateMaj */
                        v_requete := v_requete || 'null ';;  /* loginMaj */
                        v_requete := v_requete || ')';;

BEGIN
                            --RAISE NOTICE 'REQUETE 2 : %', v_requete;;
                            IF v_requete is not null THEN
                                EXECUTE v_requete;;
                                d_j := d_j + 1;;
ELSE
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[NO REQUEST] Error on STEP 2 on debit : ' || measure, v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END IF;;
EXCEPTION
                            WHEN undefined_table THEN
                                --RAISE NOTICE '[UNDEFINED TABLE] Error on STEP 1 during table insert : %', v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on STEP 2 during table insert debit', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
WHEN OTHERS THEN
                                --RAISE NOTICE '[OTHERS] Error % on STEP 2 during table insert : %', SQLERRM, v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[OTHERS] Error '|| SQLERRM ||' on STEP 2 during table insert debit', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END;;
END IF;;

                    IF measure.vitesse is not null THEN
--PLUIE
                        v_requete := 'insert into chroniques_hydro (codestation,typeid,datemesure,valeurmesure,valeurmesurecorrigee,modemesure,statutmesure,qualificationmesure,naturemesure,pointinitial,coderesponsablevalidation,codegestionnaire,codeproducteur,jobexecutionid,datecreation,datemaj,loginmaj) values ';;
                        v_requete := v_requete || '(';;
                        v_requete := v_requete || i_codestation || ', ';;
--RAISE NOTICE 'CB i_codestation : %', i_codestation;;
                        v_requete := v_requete || '6, ';; /* vitesse */
                        IF measure.datecreation is null OR measure.heure is null THEN
                            v_requete := v_requete || 'null, ';;
ELSE
                            v_dateEtHeure := to_char(measure.datecreation, 'DD/MM/YYYY') ||' '||to_char(measure.heure, 'HH24:MI:SS');;
END IF;;
                        v_requete := v_requete || '''' || v_dateEtHeure || ''', ';;
                        v_requete := v_requete || measure.valeur || ', ';;
                        v_requete := v_requete || 'null, ';; /* valeurmesurecorrigée */
                        IF measure.modeobtention = 'A' THEN
                            v_requete := v_requete || '1, ';;  /* mode mesure */
                        ELSEIF measure.modeobtention = 'M' THEN
                            v_requete := v_requete || '2, ';;  /* mode mesure */
ELSE
                            v_requete := v_requete || '0, ';;  /* mode mesure */
END IF;;
--RAISE NOTICE 'CB measure.modeobtention : %', measure.modeobtention;;
                        IF measure.validite = '' or measure.validite is null THEN
                            v_requete := v_requete || '1, ';; /* statutMesure brute */
ELSE
                            v_requete := v_requete || measure.validite || ', ';; /* statutMesure */
END IF;;
--RAISE NOTICE 'CB measure.validite : %', measure.validite;;
                        IF measure.qualification = '' or measure.qualification is null THEN
                            v_requete := v_requete || '4, ';; /* qualificationMesure non qualifiée */
ELSE
                            v_requete := v_requete || measure.qualification || ', ';; /* qualification */
END IF;;
                        v_requete := v_requete || 'null, ';;   /* natureMesure non renseignée */
                        IF d_j = 0 THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
                            v_rupture := measure.continuite || '';;
                        ELSEIF v_rupture = '1' THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
ELSE
                            v_requete := v_requete || '2, ';;  /* point continu */
END IF;;
--RAISE NOTICE 'CB d_j : %', d_j;;
                        v_rupture := measure.continuite || '';;
                        v_requete := v_requete || 'null, ';;  /* codeReponsableValidation */
                        v_requete := v_requete || 'null, ';;  /* codeGestionnaire */
                        v_requete := v_requete || 'null, ';;  /* codeProducteur */
                        v_requete := v_requete || 'null, ';;  /* jobExecutionId */
                        v_requete := v_requete || 'null, ';;  /* dateCreation */
                        v_requete := v_requete || 'null, ';;  /* dateMaj */
                        v_requete := v_requete || 'null ';;  /* loginMaj */
                        v_requete := v_requete || ')';;

BEGIN
                            --RAISE NOTICE 'REQUETE 2 : %', v_requete;;
                            IF v_requete is not null THEN
                                EXECUTE v_requete;;
                                d_j := d_j + 1;;
ELSE
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[NO REQUEST] Error on STEP 2 on vitesse : ' || measure, v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END IF;;
EXCEPTION
                            WHEN undefined_table THEN
                                --RAISE NOTICE '[UNDEFINED TABLE] Error on STEP 2 during table insert : %', v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on STEP 2 during table insert vitesse', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
WHEN OTHERS THEN
                                --RAISE NOTICE '[OTHERS] Error % on STEP 2 during table insert : %', SQLERRM, v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[OTHERS] Error '|| SQLERRM ||' on STEP 2 during table insert vitesse', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END;;
END IF;;

END LOOP;;
                d_count_ch := d_j;;
/*RAISE NOTICE 'Nombre de données dans chronique : %', d_count_ch;;*/
INSERT INTO ebonneau_logs VALUES(d_id_job, 'Nombre de données dans chronique : '|| d_count_ch, null, now(), v_codehydro, p_job_execution_id);;
d_id_job := d_id_job +1;;
CLOSE my_cursor_measures;;
END IF;;

--ETAPE 3 ----------------------------------------------------------------------------------------------------------

            --RAISE NOTICE 'ETAPE 3: Intégration des données complémentaires hydro_<id>_data';;
INSERT INTO ebonneau_logs VALUES(d_id_job, 'ETAPE 3: Intégration des données complémentaires', null, now(), v_codehydro, p_job_execution_id);;
d_id_job := d_id_job +1;;

            v_requete_curseur := 'SELECT datecreation, heure, valeur,';;
            v_requete_curseur := v_requete_curseur || ' continuite, modeobtention, cast(precision as double precision) as precision, validite, qualification, type';;
            v_requete_curseur := v_requete_curseur || ' from hydro_' || i_codestation || '_data ORDER BY datecreation ASC, heure ASC';;

            d_j := 0;;
            v_rupture := '0';;

BEGIN
EXECUTE v_requete_curseur;;
b_integration := true;;
EXCEPTION
                WHEN undefined_table THEN
                    --RAISE NOTICE '[UNDEFINED TABLE] Error on STEP 3 during table select : %', v_codehydro;;
                    INSERT INTO ebonneau_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on STEP 3 on getting data', v_requete_curseur, now(), v_codehydro, p_job_execution_id);;
                    d_id_job := d_id_job +1;;
                    b_integration := false;;
WHEN OTHERS THEN
                    --RAISE NOTICE '[OTHERS] Error % on STEP 3 during table select : %', SQLERRM, v_codehydro;;
                    INSERT INTO ebonneau_logs VALUES(d_id_job, '[OTHERS] Error '|| SQLERRM ||' on STEP 3 on getting data', v_requete_curseur, now(), v_codehydro, p_job_execution_id);;
                    d_id_job := d_id_job +1;;
                    b_integration := false;;
end;;

            IF b_integration = true THEN
                OPEN my_cursor_measures FOR EXECUTE v_requete_curseur;;
                LOOP
FETCH my_cursor_measures into measure;;
                    EXIT WHEN NOT FOUND;;

                    v_requete := '';;
                    IF measure.valeur is not null AND measure.type is not null THEN
--PLUIE
                        v_requete := 'insert into chroniques_hydro (codestation,typeid,datemesure,valeurmesure,valeurmesurecorrigee,modemesure,statutmesure,qualificationmesure,naturemesure,pointinitial,coderesponsablevalidation,codegestionnaire,codeproducteur,jobexecutionid,datecreation,datemaj,loginmaj) values ';;
                        v_requete := v_requete || '(';;
                        v_requete := v_requete || i_codestation || ', ';;
--RAISE NOTICE 'CB i_codestation : %', i_codestation;;
                        v_requete := v_requete || measure.type || ', ';; /* donnée complémentaire */
                        IF measure.datecreation is null OR measure.heure is null THEN
                            v_requete := v_requete || 'null, ';;
ELSE
                            v_dateEtHeure := to_char(measure.datecreation, 'DD/MM/YYYY') ||' '||to_char(measure.heure, 'HH24:MI:SS');;
END IF;;
                        v_requete := v_requete || '''' || v_dateEtHeure || ''', ';;
                        v_requete := v_requete || measure.valeur || ', ';;
                        v_requete := v_requete || 'null, ';; /* valeurmesurecorrigée */
                        IF measure.modeobtention = 'A' THEN
                            v_requete := v_requete || '1, ';;  /* mode mesure */
                        ELSEIF measure.modeobtention = 'M' THEN
                            v_requete := v_requete || '2, ';;  /* mode mesure */
ELSE
                            v_requete := v_requete || '0, ';;  /* mode mesure */
END IF;;
--RAISE NOTICE 'CB measure.modeobtention : %', measure.modeobtention;;
                        IF measure.validite = '' or measure.validite is null THEN
                            v_requete := v_requete || '1, ';; /* statutMesure brute */
ELSE
                            v_requete := v_requete || measure.validite || ', ';; /* statutMesure */
END IF;;
--RAISE NOTICE 'CB measure.validite : %', measure.validite;;
                        IF measure.qualification = '' or measure.qualification is null THEN
                            v_requete := v_requete || '4, ';; /* qualificationMesure non qualifiée */
ELSE
                            v_requete := v_requete || measure.qualification || ', ';; /* qualification */
END IF;;
                        v_requete := v_requete || 'null, ';;   /* natureMesure non renseignée */
                        IF d_j = 0 THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
                            v_rupture := measure.continuite || '';;
                        ELSEIF v_rupture = '1' THEN
                            v_requete := v_requete || '1, ';;  /* point initial */
ELSE
                            v_requete := v_requete || '2, ';;  /* point continu */
END IF;;
--RAISE NOTICE 'CB d_j : %', d_j;;
                        v_rupture := measure.continuite || '';;
                        v_requete := v_requete || 'null, ';;  /* codeReponsableValidation */
                        v_requete := v_requete || 'null, ';;  /* codeGestionnaire */
                        v_requete := v_requete || 'null, ';;  /* codeProducteur */
                        v_requete := v_requete || 'null, ';;  /* jobExecutionId */
                        v_requete := v_requete || 'null, ';;  /* dateCreation */
                        v_requete := v_requete || 'null, ';;  /* dateMaj */
                        v_requete := v_requete || 'null ';;  /* loginMaj */
                        v_requete := v_requete || ')';;

BEGIN
                            --RAISE NOTICE 'REQUETE 3 : %', v_requete;;
                            IF v_requete is not null THEN
                                EXECUTE v_requete;;
                                d_j := d_j + 1;;
ELSE
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[NO REQUEST] Error on STEP 3 on valeur : ' || measure, v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END IF;;
EXCEPTION
                            WHEN undefined_table THEN
                                --RAISE NOTICE '[UNDEFINED TABLE] Error on STEP 3 during table insert : %', v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[UNDEFINED TABLE] Error on STEP 3 during table insert valeur', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
WHEN OTHERS THEN
                                --RAISE NOTICE '[OTHERS] Error % on STEP 3 during table insert : %', SQLERRM, v_codehydro;;
                                INSERT INTO ebonneau_logs VALUES(d_id_job, '[OTHERS] Error '|| SQLERRM ||' on STEP 3 during table insert valeur', v_requete, now(), v_codehydro, p_job_execution_id);;
                                d_id_job := d_id_job +1;;
END;;
END IF;;

END LOOP;;
                d_count_ch := d_j;;
/*RAISE NOTICE 'Nombre de données dans chronique : %', d_count_ch;;*/
INSERT INTO ebonneau_logs VALUES(d_id_job, 'Nombre de données dans chronique : '|| d_count_ch, null, now(), v_codehydro, p_job_execution_id);;
d_id_job := d_id_job +1;;
CLOSE my_cursor_measures;;
END IF;;

-- ETAPE 4 ----------------------------------------------------------------------------------------------------------------------


/*RAISE NOTICE 'ETAPE 4 : Mise à jour des intervenants';;*/
INSERT INTO ebonneau_logs VALUES(d_id_job, 'ETAPE 4 : Mise à jour des intervenants', null, now(), v_codehydro, p_job_execution_id);;
d_id_job := d_id_job +1;;

UPDATE chroniques_hydro
set coderesponsablevalidation = p_codegestionnaire,
    codegestionnaire = p_codegestionnaire,
    codeproducteur = p_codegestionnaire,
    loginmaj = p_loginmaj,
    datemaj= now()
where codestation = i_codestation;;

GET DIAGNOSTICS d_count_intervenant := ROW_COUNT ;;
--RAISE NOTICE 'Nombre des intervenants mis à jour dans chroniques_hydro : %', d_count_intervenant;;
INSERT INTO ebonneau_logs VALUES(d_id_job, 'Nombre des intervenants mis à jour dans chroniques_hydro : ' ||d_count_intervenant, null, now(), v_codehydro, p_job_execution_id);;
d_id_job := d_id_job +1;;
            d_count_intervenant := 0;;

            --RAISE NOTICE 'ETAPE 5 : Journalisation de la bascule';;
INSERT INTO ebonneau_logs VALUES(d_id_job, 'ETAPE 5 : Journalisation de la bascule', null, now(), v_codehydro, p_job_execution_id);;
d_id_job := d_id_job +1;;

INSERT INTO journal VALUES (now(), 0, 'Migration chroniques hydro', p_loginmaj, null, null, 'SIH', v_codehydro);;
--RAISE NOTICE 'Station traitée : %', v_codehydro;;
INSERT INTO ebonneau_logs VALUES(d_id_job, 'Station traitée :  ' || v_codehydro, null, now(), v_codehydro, p_job_execution_id);;
d_id_job := d_id_job +1;;

            d_count := d_count + 1;;

END IF;;

END LOOP;;
CLOSE my_cursor_stations;;
/* RAISE NOTICE 'Nombre de stations traitées  : %', d_count;; */
INSERT INTO ebonneau_logs VALUES(d_id_job, 'Nombre de stations traitées  : '||d_count, null, now(), v_codehydro, p_job_execution_id);;
RETURN d_count;;
END;;
$$;;


# --- !Downs
