/**
 * @author jro
 * @date 19/01/22
 * @version 1.0.0
 * @project SIEau
 * @table f_calculebesoin
 */

# --- !Ups

create or replace function f_calculebesoin(p_idculture bigint, p_surface double precision, p_uge bigint, p_modeirrigation bigint, p_typesol bigint, p_profondeursol bigint, p_nbrotations integer, p_sollicitationpoint bigint, p_annee integer) returns real
   language plpgsql
as $$
DECLARE
v_besoin REAL;;
   v_critereSol BOOLEAN;;
   v_coef REAL;;
   v_uge BIGINT;;
BEGIN

   -- Récupération du besoin de la culture en fonction du code de sous uge s'il existe sinon c'est le code de l'UGE
   IF p_uge is not null THEN
select besoin into v_besoin from AGRI_cultures_ventilations where cid=p_idCulture and codeuge=p_uge and codestatut=2 and annee<=p_annee;;
select critereSol into v_critereSol from AGRI_cultures_ventilations where cid=p_idCulture and codeuge=p_uge and codestatut=2 and annee<=p_annee order by annee desc limit 1;;
IF v_besoin is null THEN
         -- Pas de besoin avec le code sous UGE, vérifier si un paramétrage existe pour le code UGE
select parent into v_uge from aep_uge where codeuge=p_uge;;
IF v_uge is not null THEN
select besoin into v_besoin from AGRI_cultures_ventilations where cid=p_idCulture and codeuge=v_uge and codestatut=2 and annee<=p_annee order by annee desc limit 1;;
select critereSol into v_critereSol from AGRI_cultures_ventilations where cid=p_idCulture and codeuge=v_uge and codestatut=2 and annee<=p_annee order by annee desc limit 1;;
END IF;;
END IF ;;

END IF;;
   -- Si pas d'UGE spécifique, on récupère le besoin par défaut de la culture
   if v_besoin is null THEN
select besoin into v_besoin from AGRI_cultures_ventilations where cid=p_idCulture and codeuge is null and codestatut=2 and annee<=p_annee order by annee desc limit 1;;
select critereSol into v_critereSol from AGRI_cultures_ventilations where cid=p_idCulture and codestatut=2 and annee<=p_annee order by annee desc limit 1;;
END IF;;
   raise notice 'v_besoin culture: %', v_besoin;;

   -- Application à la surface
   v_besoin := v_besoin * p_surface;;
   raise notice 'v_besoin culture/surface: %', v_besoin;;

   -- Application du coefficient de mode d'irrigation
   v_coef :=100;;
select pourcentage into v_coef from agri_usages_adm_mode_irrigation where codeModeIrrigation = p_modeIrrigation and statut=2 and annee<=p_annee order by annee desc limit 1;;
IF v_coef is null THEN
      v_coef := 100;;
END IF;;
   v_besoin := v_besoin * v_coef / 100;;
   raise notice 'irrigation coef: %', v_coef;;
   raise notice 'v_besoin irrigation: %', v_besoin;;

   if v_critereSol is null or v_critereSol then
      -- Application du coefficient du type de sol
      v_coef :=100;;
select pourcentage into v_coef from agri_usages_adm_type_sol where codeTypeSol = p_typeSol and statut=2 and annee<=p_annee order by annee desc limit 1;;
IF v_coef is null THEN
         v_coef := 100;;
END IF;;
      v_besoin := v_besoin * v_coef / 100;;
      raise notice 'type sol coef: %', v_coef;;
      raise notice 'v_besoin type sol: %', v_besoin;;

      -- Application du coefficient de la profondeur de sol
      v_coef :=100;;
select pourcentage into v_coef from agri_usages_adm_prof_sol where codeProfSol = p_profondeurSol and statut=2 and annee<=p_annee order by annee desc limit 1;;
IF v_coef is null THEN
         v_coef := 100;;
END IF;;
      v_besoin := v_besoin * v_coef / 100;;
      raise notice 'prof sol coef: %', v_coef;;
      raise notice 'v_besoin prof sol: %', v_besoin;;
END IF;;

   -- Application du coefficient de rotations culturales
   IF p_nbRotations is not null THEN
      v_coef := p_nbRotations * 100;;
      v_besoin := v_besoin * v_coef / 100;;
      raise notice 'prof sol coef: %', v_coef;;
      raise notice 'v_besoin prof sol: %', v_besoin;;
END IF;;

   -- Application du coefficient de sollicitation
   v_coef :=100;;
   IF p_SollicitationPoint is not null THEN
select pourcentage into v_coef from agri_usages_adm_sollicitation where codeSollication = p_SollicitationPoint and statut=2 and annee<=p_annee order by annee desc limit 1;;
IF v_coef is null THEN
         v_coef := 100;;
END IF;;
      v_besoin := v_besoin * v_coef / 100;;
END IF;;

   raise notice 'v_besoin: %', v_besoin;;
   v_besoin := ROUND(0.45 + (v_besoin/10)) * 10;;
   raise notice 'v_besoin arrondi: %', v_besoin;;

RETURN v_besoin;;
END;;
$$;;

# --- !Downs
