/**
 * @author Stéphane
 * @date 10/03/2022
 * @version 1.0.0
 * @project SIEau
 * @function f_calc_dernier_index
 */
# --- !Ups
create or replace function f_calc_dernier_index(p_idCapteur INTEGER, p_dateFin TIMESTAMP with time zone)
returns REAL
language plpgsql
as $$
DECLARE
	v_dateIndex2 TIMESTAMP with time zone;;
	v_index2 REAL;;

BEGIN

	p_dateFin = date_trunc('day', p_dateFin) + INTERVAL '1 day';;
	raise notice 'f_calc_dernier_index date fin: %', p_dateFin;;

	-- Dernier index connu
	select dateMesure, mesure into v_dateIndex2, v_index2 from MAT_CHRONIQUES where idmateriel=p_idCapteur and typemesure=2 and dateMesure<p_dateFin ORDER BY dateMesure DESC LIMIT 1;;
	raise notice 'f_calc_dernier_index : % - %', v_dateIndex2, v_index2;;

	RETURN v_index2;;
END;;
$$
;

# --- !Downs
