/**
 * @author Stéphane
 * @date 10/03/2022
 * @version 1.0.0
 * @project SIEau
 * @function f_calc_premier_index
 */
# --- !Ups
create or replace function f_calc_premier_index(p_idCapteur INTEGER, p_dateDebut TIMESTAMP with time zone)
returns REAL
language plpgsql
as $$
DECLARE
	v_dateIndex1 TIMESTAMP with time zone;;
	v_index1 REAL;;

BEGIN
	-- Premier index connu
	p_dateDebut = date_trunc('day', p_dateDebut) + INTERVAL '1 day';;
	raise notice 'f_calc_premier_index date début: %', p_dateDebut;;

	select dateMesure, mesure into v_dateIndex1, v_index1 from MAT_CHRONIQUES where idmateriel=p_idCapteur and typemesure=2 and dateMesure<p_dateDebut ORDER BY dateMesure DESC LIMIT 1;;
	raise notice 'f_calc_premier_index  : % - %', v_dateIndex1, v_index1;;

	RETURN v_index1;;
END;;
$$
;

# --- !Downs
