/**
 * @author tpa
 * @date 11/04/2022
 * @version 1.0.0
 * @project SIEau
 * @table piezometres_modeles
 */
# --- !Ups
drop table if exists piezometres_modeles;
drop table if exists pluviometres_modeles;
drop table if exists station_hydro_modeles;
create table piezometres_modeles
(
    codepiezometre    integer,
    idmodele          integer,
    typemodele        varchar(255),
    typeid            integer,
    nom               varchar(255),
    codestatut        integer,
    recalculauto      boolean,
    datecreation      timestamp with time zone,
    datemaj           timestamp with time zone,
    loginmaj          varchar(255),
    parametres        text,
    objectif          integer,
    horizon           integer,
    indiceconfiance   double precision,
    datecalcul        timestamp with time zone,
    couleur           varchar(10),
    pardefaut         boolean,
    idscenario        integer,
    annescenario      integer,
    afficherdashboard boolean,
    affichersituation boolean,
    afficheralerte    boolean,
    jobexecutionid    bigint
);
create index ind_piezometres_modeles
    on piezometres_modeles (codepiezometre, idmodele);

create table pluviometres_modeles
(
    codepluviometre    integer,
    idmodele          integer,
    typemodele        varchar(255),
    typeid            integer,
    nom               varchar(255),
    codestatut        integer,
    recalculauto      boolean,
    datecreation      timestamp with time zone,
    datemaj           timestamp with time zone,
    loginmaj          varchar(255),
    parametres        text,
    objectif          integer,
    horizon           integer,
    indiceconfiance   double precision,
    datecalcul        timestamp with time zone,
    couleur           varchar(10),
    pardefaut         boolean,
    idscenario        integer,
    annescenario      integer,
    afficherdashboard boolean,
    affichersituation boolean,
    afficheralerte    boolean,
    jobexecutionid    bigint
);
create index ind_pluviometres_modeles
    on pluviometres_modeles (codepluviometre, idmodele);

create table station_hydro_modeles
(
    codestation    integer,
    idmodele          integer,
    typemodele        varchar(255),
    typeid            integer,
    nom               varchar(255),
    codestatut        integer,
    recalculauto      boolean,
    datecreation      timestamp with time zone,
    datemaj           timestamp with time zone,
    loginmaj          varchar(255),
    parametres        text,
    objectif          integer,
    horizon           integer,
    indiceconfiance   double precision,
    datecalcul        timestamp with time zone,
    couleur           varchar(10),
    pardefaut         boolean,
    idscenario        integer,
    annescenario      integer,
    afficherdashboard boolean,
    affichersituation boolean,
    afficheralerte    boolean,
    jobexecutionid    bigint
);
create index ind_station_hydro_modeles
    on station_hydro_modeles (codestation, idmodele);

# --- !Downs
