 * @author pminot
 * @date 16/06/2022
 * @version 1.0.0
 * @project SIEau
 * @table agri_compta_exploitation_services and agri_tour_eau_plages
 * @fonction script PL-SQL : f_calc_variables_services
 */

# --- !Ups

alter table agri_tour_eau_plages drop column if exists nbplages;
alter table agri_tour_eau_plages drop column if exists heuredebut;
alter table agri_tour_eau_plages drop column if exists plages;
alter table agri_tour_eau_plages add column plages text;

-- Table: public.agri_exploitations_compta_variables

DROP TABLE if exists agri_exploitations_compta_variables;
CREATE TABLE agri_exploitations_compta_variables
(
    codeexploitation bigint,
    idservice bigint,
    datecalcul timestamp without time zone,
    quantite bigint
);

-- Index: pk_agri_exploitations_compta_variables

CREATE UNIQUE INDEX if not exists pk_agri_exploitations_compta_variables
    ON agri_exploitations_compta_variables USING btree
    (codeexploitation ASC NULLS LAST, idservice ASC NULLS LAST, datecalcul ASC NULLS LAST)
    TABLESPACE pg_default;

-- FUNCTION: public.f_calc_variables_services(bigint, timestamp with time zone)

CREATE OR REPLACE FUNCTION f_calc_variables_services(
	p_idexploitation bigint,
	p_datecalcul timestamp with time zone)
    RETURNS boolean
    LANGUAGE 'plpgsql'

    COST 100
    VOLATILE
AS $BODY$
DECLARE
	v_rec_services RECORD;;
	v_nbPoints INTEGER;;
	v_retour BOOLEAN;;
BEGIN

	v_retour := true;;

	-- Service actif
	raise notice 'calcul pour l''exploitation  : %', p_idExploitation;;
	DELETE FROM agri_exploitations_compta_variables WHERE codeExploitation=p_idExploitation AND date(dateCalcul)=date(p_dateCalcul);;

	FOR v_rec_services
	IN SELECT idService, dateDebut FROM agri_exploitations_compta WHERE codeExploitation=p_idExploitation AND (dateDebut is null or dateDebut<=p_dateCalcul) AND (dateFin is null or dateFin>=p_dateCalcul)
	LOOP
		raise notice 'calcul pour le service  : %', v_rec_services.idService;;

		-- Incription à facturer si premère année d'exploitation
		IF v_rec_services.idService IN (1, 3) THEN
			raise notice 'Inscription : %', v_rec_services.dateDebut;;
			IF v_rec_services.dateDebut IS NULL OR date('year',v_rec_services.dateDebut)=date_part('year',p_dateCalcul) THEN
				INSERT INTO agri_exploitations_compta_variables VALUES (p_idExploitation, v_rec_services.idService, date(p_dateCalcul), 1);;
			END IF;;
		END IF;;


		-- Frais de fonctionnement en fonction du nombre de points utilisés à date de calcul
		IF v_rec_services.idService IN (2, 4) THEN
			raise notice 'fonctionnement : %', v_rec_services.dateDebut;;
			SELECT count(codeinstallation) INTO v_NbPoints FROM agri_exploitations_points_prelevements WHERE codeexploitation=p_idExploitation AND (codeEtat=1 or codeEtat is null) AND (dateFin is null or dateFin>=p_dateCalcul);;
			IF v_nbPoints > 0 THEN
				INSERT INTO agri_exploitations_compta_variables VALUES (p_idExploitation, v_rec_services.idService, date(p_dateCalcul), v_nbPoints);;
			END IF;;
		END IF;;

		-- Redevance partie forfaitaire: facturée si enquête remplie
		IF v_rec_services.idService IN (5, 6, 7) THEN
			raise notice 'Redevance partie forfaitaire : %', v_rec_services.dateDebut;;
			SELECT COUNT(agri_declarations.id) INTO v_nbPoints FROM agri_declarations INNER JOIN agri_enquetes ON (agri_declarations.enqueteid=agri_enquetes.id) WHERE codeexploitation = p_idExploitation AND annee=date_part('year',p_dateCalcul) AND derniereEtape>=3;;
			IF v_nbPoints > 0 THEN
				INSERT INTO agri_exploitations_compta_variables VALUES (p_idExploitation, v_rec_services.idService, date(p_dateCalcul), 1);;
			END IF;;
		END IF;;


		-- Redevance partie variable: facturée si enquête remplie avec point utilisé
		IF v_rec_services.idService IN (8, 9, 10) THEN
			raise notice 'Redevance partie variable : %', v_rec_services.dateDebut;;
			SELECT COUNT(agri_declarations_pt_prel.codeInstallation) INTO v_nbPoints FROM agri_declarations_pt_prel  INNER JOIN agri_enquetes on (agri_declarations_pt_prel.enqueteid=agri_enquetes.id) WHERE codeexploitation =p_idExploitation and annee=date_part('year',p_dateCalcul) and codeEtat=1;;
			IF v_nbPoints > 0 THEN
				INSERT INTO agri_exploitations_compta_variables VALUES (p_idExploitation, v_rec_services.idService, date(p_dateCalcul), v_nbPoints);;
			END IF;;
		END IF;;

		-- IF v_rec_services.idService NOT IN (1, 2, 3, 4) THEN
		--	v_retour := false;;
		--	raise notice 'Le service : % n''a pas de règle de calcul' , v_rec_services.idService;;
		--END IF;;

	END LOOP;;

	RETURN v_retour;;
END;;
$BODY$;
