/**
 * @author tpa
 * @date 06/09/2022
 * @version 1.0.0
 * @project SIEau
 * @table chroniques_analyses
 */
# --- !Ups
create table chroniques_analyses
(
    codequalitometre       double precision,
    numanalyse             double precision,
    numprelevement         double precision,
    codeoperation          double precision,
    dateanalyse            timestamp with time zone,
    codeparametre          varchar(5),
    codeunite              varchar(5),
    resultat               double precision,
    coderemarque           varchar(2),
    codelieu              varchar(1),
    limitequantification  real,
    limitedetection       real,
    seuilsaturation       real,
    codequalification      varchar(1),
    statutmesure           varchar(1),
    codefraction          varchar(5),
    codemethode            varchar(5),
    codelabo              double precision,
    referencelabo         varchar(100),
    numechantillon        integer,
    accreditation         varchar(1),
    codedifficulte        varchar(1),
    commentaireanalyse    text,
    commentaireresultat   text,
    incertitudeanalytique real,
    codesolvant           varchar(5),
    methodeextraction     varchar(5),
    rendementextraction   real,
    volumefiltre          real,
    coderesponsable       integer,
    resultatref           real,
    jobexecutionid        bigint,
    datecreation          timestamp with time zone,
    datemaj               timestamp with time zone,
    loginmaj              varchar(255)
);

create unique index chroniques_analyses_pk
    on chroniques_analyses (codequalitometre, numanalyse, numprelevement);

create index chroniques_analyses_codequalitometre_idx
    on chroniques_analyses (codequalitometre);

create index chroniques_analyses_codeparametre_idx
    on chroniques_analyses (codeparametre);



# --- !Downs

