/**
 * @author amr
 * @date 30/09/2022
 * @version 1.0.0
 * @project SIEau
 * @table qualitometres_listes
 */
# --- !Ups


CREATE TABLE public.qualitometres_listes (
    codequalitometre float8 ,
	codeoperation float8 NULL,
	codeliste float8 NULL,
	indice float8 NULL,
	codetaxon varchar(6) NULL,
	denombrementa float8 NULL,
	pourcentagea float8 NULL,
	denombrementb float8 NULL,
	pourcentageb float8 NULL,
	denombrementc float8 NULL,
	pourcentagec float8 NULL,
	codeunite float8 NULL,
	codedeveloppement float8 NULL,
	coderemarque float8 NULL,
	codeconfiance float8 NULL,
	densite float8 NULL,
	codecalculindice float8 NULL,
	denombrementc2 float8 NULL,
	denombrementp1 float8 NULL,
	denombrementp2 float8 NULL,
	denombrementp3 float8 NULL,
	denombrementp4 float8 NULL,
	denombrementp5 float8 NULL,
	denombrementp6 float8 NULL,
	denombrementp7 float8 NULL,
	denombrementp8 float8 NULL,
	denombrementp9 float8 NULL,
	denombrementp10 float8 NULL,
	denombrementp11 float8 NULL,
	denombrementp12 float8 NULL
);


create index qualitometres_listes_idx
    on qualitometres_listes (codequalitometre);

create index qualitometres_listes_idx2
    on qualitometres_listes (codequalitometre,codeoperation);


CREATE OR REPLACE FUNCTION public.getQualityListe()
 RETURNS double precision
 LANGUAGE plpgsql
AS $function$
DECLARE
  my_cursor_station REFCURSOR;;
  stations RECORD;;
  v_requete VARCHAR (5000);;
  d_count double precision;;
  v_station  double precision;;
BEGIN
  OPEN my_cursor_station for select q.codequalitometre,cast (q.codequalitometre  as varchar) as id from qualitometres q;;
  delete from chroniques_analyses;;
  RAISE NOTICE '## PURGE DES DONNEES QUALITY LISTE ##';;
  LOOP
    FETCH my_cursor_station into stations;;
    EXIT WHEN NOT FOUND;;
    begin
	  execute 'select count(*) from qualitometres_liste_'|| stations.id INTO d_count;;
      RAISE NOTICE '############# STATION % : %', stations, d_count;;
     EXCEPTION
      WHEN undefined_table THEN
        d_count := 0;;
        RAISE NOTICE '[UNDEFINED TABLE] Error on table count on table % : %', stations.codequalitometre, SQLERRM;;
      WHEN OTHERS THEN
        d_count := 0;;
        RAISE NOTICE '[OTHERS] Error on table count on table % : %', stations.codequalitometre, SQLERRM;;
    END;;
    IF d_count > 0 THEN
      	v_requete := 'insert into qualitometres_listes (	codequalitometre  ,codeoperation ,codeliste,	indice ,	codetaxon ,	denombrementa ,	pourcentagea ,	denombrementb ,	pourcentageb ,	' ||
      	' denombrementc ,	pourcentagec ,	codeunite ,	codedeveloppement ,	coderemarque ,	codeconfiance ,	densite ,	codecalculindice ,	denombrementc2 ,	denombrementp1 ,	denombrementp2 ,denombrementp3 ,' ||
      	' denombrementp4 ,	denombrementp5 ,	denombrementp6 ,	denombrementp7 ,	denombrementp8 ,	denombrementp9 ,	denombrementp10 ,	denombrementp11 ,	denombrementp12 ) ' ||
        ' select distinct '|| stations.codequalitometre || ' , codeoperation ,codeliste,	indice ,	codetaxon ,	denombrementa ,	pourcentagea ,	denombrementb ,	pourcentageb ,	' ||
      	' denombrementc ,	pourcentagec ,	codeunite ,	codedeveloppement ,	coderemarque ,	codeconfiance ,	densite ,	codecalculindice ,	denombrementc2 ,	denombrementp1 ,	denombrementp2 ,denombrementp3 ,' ||
      	' denombrementp4 ,	denombrementp5 ,	denombrementp6 ,	denombrementp7 ,	denombrementp8 ,	denombrementp9 ,	denombrementp10 ,	denombrementp11 ,	denombrementp12 ' ||
        ' from qualitometres_liste_'|| stations.id  ;;
      BEGIN
        --RAISE NOTICE '%',v_requete;;
        execute v_requete;;
        EXCEPTION
        WHEN undefined_table THEN
          RAISE NOTICE '[UNDEFINED TABLE] Error on table insert on table % : %', stations.codequalitometre, SQLERRM;;
        WHEN OTHERS THEN
          RAISE NOTICE '[OTHERS] Error on table insert on table % : %', stations.codequalitometre, SQLERRM;;
      END;;
    END IF;;
  end loop;;
  select count(*) into d_count from qualitometres_listes;;
  CLOSE my_cursor_station;;
  RETURN d_count;;
END;;
$function$
;

select getQualityListe();


# --- !Downs

