/**
 * @author jro
 * @date 24/10/2022
 * @version 1.0.0
 * @project SIEau
 * @table mat_chroniques
 * @fonction script PL-SQL : f_calc_volume_reel and f_calc_premier_index
 */

# --- !Ups

drop function if exists f_calc_volume_reel(p_idCapteur INTEGER, p_coeffLecture DOUBLE PRECISION, p_dateDebut TIMESTAMP with time zone, p_dateFin TIMESTAMP with time zone) ;

create function f_calc_volume_reel(p_idCapteur INTEGER, p_coeffLecture DOUBLE PRECISION, p_dateDebut TIMESTAMP with time zone, p_dateFin TIMESTAMP with time zone)
returns REAL
language plpgsql
as $$
DECLARE
	v_dateIndex1 TIMESTAMP with time zone;;
	v_index1 REAL;;
	v_dateIndex2 TIMESTAMP with time zone;;
	v_index2 REAL;;
	v_total REAL;;
	recCompteurs RECORD;;

BEGIN
	-- Premier index connu
	p_dateDebut = date_trunc('day', p_dateDebut) + INTERVAL '1 day';;
	raise notice 'f_calc_volume_reel date début: %', p_dateDebut;;

	select dateMesure into v_dateIndex1 from MAT_CHRONIQUES where idmateriel=p_idCapteur and typemesure=2 and dateMesure<p_dateDebut ORDER BY dateMesure DESC LIMIT 1;;
	raise notice 'f_calc_volume_reel date index1 : %', v_dateIndex1;;
	IF v_dateIndex1 IS NULL THEN
		v_dateIndex1 := p_dateDebut;;
	END IF;;

	-- Dernier index connu
	select dateMesure into v_dateIndex2 from MAT_CHRONIQUES where idmateriel=p_idCapteur and typemesure=2 and dateMesure<=p_dateFin ORDER BY dateMesure DESC LIMIT 1;;
	raise notice 'f_calc_volume_reel date index2 : %', v_dateIndex2;;
	IF v_dateIndex2 IS NULL THEN
		v_dateIndex2 := p_dateFin;;
	END IF;;

	-- Parcoure de tous les index entre ces dates
	v_total := 0;;
	v_index1 := NULL;;
	v_index2 := NULL;;
	FOR recCompteurs IN SELECT dateMesure, mesure
		FROM MAT_CHRONIQUES
		WHERE idmateriel=p_idCapteur and typemesure=2 and dateMesure>=v_dateIndex1 and dateMesure<=v_dateIndex2 ORDER BY dateMesure asc
	LOOP
		IF recCompteurs.mesure IS NOT NULL THEN
			IF v_index1 IS NULL THEN
				raise notice '1ère lecture : %', recCompteurs.mesure;;
				v_index1 := recCompteurs.mesure;;
			ELSE
				v_index2 := recCompteurs.mesure;;
				IF v_index2 <= v_index1 THEN
					-- changement de compteurs ou remise à 0
					raise notice 'Changement de compteur : %', recCompteurs.dateMesure;;
					raise notice 'Compteur 1 : %', v_index1;;
					raise notice 'Compteur 2 : %', v_index2;;
					v_index1 := v_index2;;
					v_index2 := NULL;;
				ELSE
					v_total := v_total + (v_index2 - v_index1)*p_coeffLecture;;
					raise notice 'Total : %', v_total;;
					v_index1 := v_index2;;
					v_index2 := NULL;;
				END IF;;
			END IF;;
		END IF;;
	END LOOP;;

	RETURN v_total;;
END;;
$$
;

drop function if exists f_calc_volume_reel(p_idCapteur INTEGER, p_coeffLecture INTEGER, p_dateDebut TIMESTAMP with time zone, nbMoisRechercheDebut INTEGER, p_dateFin TIMESTAMP with time zone, nbMoisRechercheFin INTEGER) ;

create function f_calc_volume_reel(p_idCapteur INTEGER, p_coeffLecture INTEGER, p_dateDebut TIMESTAMP with time zone, nbMoisRechercheDebut INTEGER, p_dateFin TIMESTAMP with time zone, nbMoisRechercheFin INTEGER)
returns REAL
language plpgsql
as $$
DECLARE
	v_dateIndex1 TIMESTAMP with time zone;;
	v_dateLimitDebut TIMESTAMP with time zone;;
	v_dateLimitFin TIMESTAMP with time zone;;
	v_index1 REAL;;
	v_dateIndex2 TIMESTAMP with time zone;;
	v_index2 REAL;;
	v_total REAL;;
	recCompteurs RECORD;;

BEGIN
	-- Premier index connu
	p_dateDebut = date_trunc('day', p_dateDebut) + INTERVAL '1 day';;
	v_dateLimitDebut = p_dateDebut - INTERVAL  '1 MONTHS' * nbMoisRechercheDebut;;
	raise notice 'f_calc_volume_reel date début: %', p_dateDebut;;

	select dateMesure into v_dateIndex1
	from MAT_CHRONIQUES
	where idmateriel=p_idCapteur
	and typemesure=2
	AND dateMesure<p_dateDebut
	AND dateMesure>v_dateLimitDebut
	ORDER BY dateMesure DESC LIMIT 1;;
	raise notice 'f_calc_volume_reel date index1 : %', v_dateIndex1;;
	IF v_dateIndex1 IS NULL THEN
		v_dateIndex1 := p_dateDebut;;
	END IF;;

	-- Dernier index connu
	v_dateLimitFin = p_dateFin - INTERVAL  '1 MONTHS' * nbMoisRechercheFin;;
	select dateMesure into v_dateIndex2
	from MAT_CHRONIQUES
	where idmateriel=p_idCapteur
	and typemesure=2
	and dateMesure>=p_dateFin
	and dateMesure<=v_dateLimitFin
	ORDER BY dateMesure DESC LIMIT 1;;
	raise notice 'f_calc_volume_reel date index2 : %', v_dateIndex2;;
	IF v_dateIndex2 IS NULL THEN
		v_dateIndex2 := p_dateFin;;
	END IF;;

	-- Parcoure de tous les index entre ces dates
	v_total := 0;;
	v_index1 := NULL;;
	v_index2 := NULL;;
	FOR recCompteurs IN SELECT dateMesure, mesure
		FROM MAT_CHRONIQUES
		WHERE idmateriel=p_idCapteur and typemesure=2 and dateMesure>=v_dateIndex1 and dateMesure<=v_dateIndex2 ORDER BY dateMesure asc
	LOOP
		IF recCompteurs.mesure IS NOT NULL THEN
			IF v_index1 IS NULL THEN
				raise notice '1ère lecture : %', recCompteurs.mesure;;
				v_index1 := recCompteurs.mesure;;
			ELSE
				v_index2 := recCompteurs.mesure;;
				IF v_index2 <= v_index1 THEN
					-- changement de compteurs ou remise à 0
					raise notice 'Changement de compteur : %', recCompteurs.dateMesure;;
					raise notice 'Compteur 1 : %', v_index1;;
					raise notice 'Compteur 2 : %', v_index2;;
					v_index1 := v_index2;;
					v_index2 := NULL;;
				ELSE
					v_total := v_total + (v_index2 - v_index1)*p_coeffLecture;;
					raise notice 'Total : %', v_total;;
					v_index1 := v_index2;;
					v_index2 := NULL;;
				END IF;;
			END IF;;
		END IF;;
	END LOOP;;

	RETURN v_total;;
END;;
$$
;












drop function if exists f_calc_premier_index(p_idCapteur INTEGER, p_dateDebut TIMESTAMP with time zone) ;

create function f_calc_premier_index(p_idCapteur INTEGER, p_dateDebut TIMESTAMP with time zone)
returns REAL
language plpgsql
as $$
DECLARE
	v_dateIndex1 TIMESTAMP with time zone;;
	v_index1 REAL;;

BEGIN
	-- Premier index connu
	p_dateDebut = date_trunc('day', p_dateDebut) + INTERVAL '1 day';;
	raise notice 'f_calc_premier_index date début: %', p_dateDebut;;

	SELECT dateMesure, mesure INTO v_dateIndex1, v_index1
	FROM MAT_CHRONIQUES
	WHERE idmateriel=p_idCapteur AND typemesure=2 AND dateMesure<p_dateDebut
	ORDER BY dateMesure DESC LIMIT 1;;

	IF v_index1 IS NULL THEN
		SELECT dateMesure, mesure INTO v_dateIndex1, v_index1
		FROM MAT_CHRONIQUES
		WHERE idmateriel=p_idCapteur AND typemesure=2 AND dateMesure>=p_dateDebut AND datemesure<p_dateDebut + INTERVAL '1 year'
		ORDER BY dateMesure ASC LIMIT 1;;
	END IF;;
	raise notice 'f_calc_premier_index  : % - %', v_dateIndex1, v_index1;;

	RETURN v_index1;;
END;;
$$
;


drop function if exists f_calc_premier_index(p_idCapteur INTEGER, p_dateDebut TIMESTAMP with time zone, nbMoisRecherche INTEGER) ;

create function f_calc_premier_index(p_idCapteur INTEGER, p_dateDebut TIMESTAMP with time zone, nbMoisRecherche INTEGER)
returns REAL
language plpgsql
as $$
DECLARE
	v_dateIndex1 TIMESTAMP with time zone;;
	v_dateLimit TIMESTAMP with time zone;;
	v_index1 REAL;;

BEGIN
	-- Premier index connu
	p_dateDebut = date_trunc('day', p_dateDebut) + INTERVAL '1 DAY';;
	v_dateLimit = p_dateDebut - INTERVAL  '1 MONTHS' * nbMoisRecherche;;
	raise notice 'f_calc_premier_index date début: %', p_dateDebut;;
	raise notice 'f_calc_premier_index date max recherche: %', v_dateLimit;;

	SELECT dateMesure, mesure INTO v_dateIndex1, v_index1
	FROM MAT_CHRONIQUES
	WHERE idmateriel=p_idCapteur AND typemesure=2
	AND dateMesure<p_dateDebut
	AND dateMesure>v_dateLimit
	ORDER BY dateMesure DESC LIMIT 1;;

	IF v_index1 IS NULL THEN
		SELECT dateMesure, mesure INTO v_dateIndex1, v_index1
		FROM MAT_CHRONIQUES
		WHERE idmateriel=p_idCapteur AND typemesure=2 AND dateMesure>=p_dateDebut AND datemesure<p_dateDebut + INTERVAL '1 year'
		ORDER BY dateMesure ASC LIMIT 1;;
	END IF;;
	raise notice 'f_calc_premier_index  : % - %', v_dateIndex1, v_index1;;

	RETURN v_index1;;
END;;
$$
;

# --- !Downs