/**
 * @author pminot
 * @date 21/11/2022
 * @version 1.0.0
 * @project SIEau
 * @table codes_sandre / inst_reservoir_gc / AEP_UDI / aep_unites_prod + alter modes_mesures_pk
 */

# --- !Ups

DROP index if EXISTS modes_mesures_pk;
create index modes_mesures_pk
   on modes_mesures (codepiezometre);

alter table inst_reservoir_gc add column codeUsage BIGINT;
alter table inst_reservoir_gc add column coteCrepine REAL;
alter table inst_reservoir_gc add column anneRenoInterieur INTEGER;
alter table inst_reservoir_gc add column anneeRenoExterieure INTEGER;
alter table inst_reservoir_gc add column typeBache BIGINT;

alter table aep_unites_prod add column surfaceBatie REAL;
alter table aep_unites_prod add column surfaceNonBatie REAL;
alter table aep_unites_prod add column dateRenovation TIMESTAMP WITH TIME ZONE;

alter table AEP_UDI add column syndicatMixte BOOLEAN;
alter table AEP_UDI add column adherent BOOLEAN;
alter table AEP_UDI add column anneeEntree INTEGER;
alter table AEP_UDI add column anneeSortie INTEGER;
alter table AEP_UDI add column longueurTraitee REAL;
alter table AEP_UDI add column branchementSSCompteur INTEGER;

insert into codes_sandre values ('RESERVOIRS.USAGES',1,'Distribution gravitaire');
insert into codes_sandre values ('RESERVOIRS.USAGES',2,'Distribution surpressée');
insert into codes_sandre values ('RESERVOIRS.USAGES',3,'Distribution reprise');
insert into codes_sandre values ('RESERVOIRS.USAGES',4,'Stockage eau brute');
insert into codes_sandre values ('RESERVOIRS.USAGES',5,'Autre');
insert into codes_sandre values ('BACHE.TYPE',1,'Reprise');
insert into codes_sandre values ('BACHE.TYPE',2,'Mixte');

# --- !Downs