/**
 * @author pminot
 * @date 25/04/2023
 * @version 1.0.0
 * @project SIEau
 * @table
 */

# --- !Ups

-- FUNCTION: public.fctdeleteinstallation(text)

create or replace function doEvolution249()
    RETURNS double precision
    LANGUAGE plpgsql
as $BODY$
begin
    IF (select exists (select * from pg_proc where proname = 'fctdeleteinstallation')) then
        CREATE OR REPLACE FUNCTION fctdeleteinstallation(
            pidentifiant text)
            RETURNS bigint
            LANGUAGE 'plpgsql'

            COST 100
            VOLATILE

        AS $BODY2$
        -- AQUASYS - P Minot - Mise à jour: 25/04/2023
        -- Fonction qui permet de supprimer une installation à partir de son identifiant
        -- Cette fonction est appelée à chaque connexion pour les installations à supprimer
        DECLARE
            vCodeInstallation	bigint;;
        BEGIN
                -- Récupération du code interne
            SELECT codeInstallation into vCodeInstallation FROM aep_installations where identifiant=pIdentifiant;;

            IF vCodeInstallation is not null THEN
                -- Suppression de tous les liens des installations
                raise notice 'Deleting %', vCodeInstallation;;
                delete from aep_installations where codeinstallation = vCodeInstallation;;
                delete from lien_installations_info_geo where codeinstallation = vCodeInstallation;;
                delete from inst_acces_ouvrage where codeinstallation = vCodeInstallation;;
                delete from inst_acces_site  where codeinstallation = vCodeInstallation;;
                delete from inst_acces_site_intervenants  where codeinstallation = vCodeInstallation;;
                delete from inst_analyses  where codeinstallation = vCodeInstallation;;
                --delete from inst_captage_equipements  where codeinstallation = vCodeInstallation;;
                --delete from inst_captage_gc  where codeinstallation = vCodeInstallation;;
                delete from inst_cavites  where codeinstallation = vCodeInstallation;;
                delete from inst_electricite_com  where codeinstallation = vCodeInstallation;;
                delete from inst_equipements_detail  where codeinstallation = vCodeInstallation;;
                delete from inst_forages  where codeinstallation = vCodeInstallation;;
                delete from inst_forages_essai_nappes  where codeinstallation = vCodeInstallation;;
                delete from inst_forages_essai_puits  where codeinstallation = vCodeInstallation;;
                delete from inst_obstacles  where codeinstallation = vCodeInstallation;;
                delete from inst_poste_relevage_equipements  where codeinstallation = vCodeInstallation;;
                delete from inst_poste_relevage_gc  where codeinstallation = vCodeInstallation;;
                delete from inst_prel_agri  where codeinstallation = vCodeInstallation;;
                delete from inst_prel_agri_ouvrages  where codeinstallation = vCodeInstallation;;
                delete from inst_prel_agri_reservoirs  where codeinstallation = vCodeInstallation;;
                delete from inst_preventions  where codeinstallation = vCodeInstallation;;
                delete from inst_reservoir_equipements  where codeinstallation = vCodeInstallation;;
                delete from inst_reservoir_gc  where codeinstallation = vCodeInstallation;;
                delete from inst_reservoir_radio  where codeinstallation = vCodeInstallation;;
                delete from inst_reservoir_securite  where codeinstallation = vCodeInstallation;;
                delete from inst_reservoir_zones  where codeinstallation = vCodeInstallation;;
                delete from inst_securite  where codeinstallation = vCodeInstallation;;
                delete from inst_securite_autre  where codeinstallation = vCodeInstallation;;
                delete from inst_securite_personnel  where codeinstallation = vCodeInstallation;;
                delete from inst_sites_indus  where codeinstallation = vCodeInstallation;;
                delete from inst_sols_pollues  where codeinstallation = vCodeInstallation;;
                delete from inst_step  where codeinstallation = vCodeInstallation;;
                delete from inst_step_communes  where codeinstallation = vCodeInstallation;;
                delete from inst_step_equipements  where codeinstallation = vCodeInstallation;;
                delete from inst_step_gc  where codeinstallation = vCodeInstallation;;
                delete from inst_batiments WHERE typebatiment =4 and codeinstallation = vCodeInstallation;;
                delete from inst_step_installations  where codeinstallation = vCodeInstallation;;
                delete from inst_st_pompage_aep  where codeinstallation = vCodeInstallation;;
                delete from inst_equipements_electro  where codeinstallation = vCodeInstallation;;
                delete from inst_st_pompage_aep_equipements_divers  where codeinstallation = vCodeInstallation;;
                delete from inst_st_traitement_gestion  where codeinstallation = vCodeInstallation;;
                delete from inst_visites_actions  where codeinstallation = vCodeInstallation;;
                delete from inst_visites_actions_doc  where codeinstallation = vCodeInstallation;;
                delete from inst_visites_inst_maj  where codeinstallation = vCodeInstallation;;

                delete from forages_commentaires  where codeinstallation = vCodeInstallation;;
                delete from forages_equipements  where codeinstallation = vCodeInstallation;;
                delete from forages_foration  where codeinstallation = vCodeInstallation;;
                delete from forages_gc  where codeinstallation = vCodeInstallation;;
                delete from forages_gestion  where codeinstallation = vCodeInstallation;;

            ELSE
                -- le code interne n'a pas pu être récupéré
                raise notice 'No installation was found with code %', pIdentifiant;;

            END IF;;
            RETURN vCodeInstallation;;
        END;;
        $BODY2$;;
    end if;;
    return 0;;
end;;
$BODY$;;
select doEvolution249();;

# --- !Downs