/**
 * @author tlaroche
 * @date 25/05/2023
 * @version 1.0.0
 * @project Myliaq
 * @table cms_modeles et cms et cms_modeles_stations et cms_modeles_obstacles et cms_modeles_maregraphes et cms_valeurs_stations et cms_valeurs_stations_evenements et cms_valeurs_obstacles et cms_valeurs_maregraphes
 */

# --- !Ups

create table cms_modeles (
	idModele INTEGER,
	categoryid INTEGER,
	titre CHARACTER VARYING(255),
	soustitre CHARACTER VARYING(255),
	planification CHARACTER VARYING(50),
	heureGeneration TIMESTAMP WITH TIME ZONE,
	heurePublication TIMESTAMP WITH TIME ZONE,
	destinataires TEXT,
	modeleDocument TEXT,
	dateDebut TIMESTAMP WITH TIME ZONE,
	dateFin TIMESTAMP WITH TIME ZONE,
	loginMaj CHARACTER VARYING(100),
	dateMaj TIMESTAMP WITH TIME ZONE,
	modelemail CHARACTER VARYING(50)
);

create unique index pk_cms_modeles on cms_modeles (idModele);

alter table cms add column modeleId INTEGER;

create table cms_modeles_stations (
	idModele INTEGER,
	stationid INTEGER,
	typeSite INTEGER,
	codeSite INTEGER,
	dataTypeId INTEGER,
	delaiAbsence INTEGER,
	codeinstallation INTEGER,
	ordre INTEGER
);

create unique index pk_cms_modeles_stations on cms_modeles_stations (idModele, stationid);

create table cms_modeles_obstacles (
	idModele INTEGER,
	obstacleid INTEGER,
	codeInstallation INTEGER,
	valeurDefaut TEXT,
	ordre INTEGER
);

create unique index pk_cms_modeles_obstacles on cms_modeles_obstacles (idModele, obstacleid);

create table cms_modeles_maregraphes (
	idModele INTEGER,
	maregrapheid INTEGER,
	codeStation INTEGER,
	ordre INTEGER
);

create unique index pk_cms_modeles_maregraphes on cms_modeles_maregraphes (idModele, maregrapheid);

create table cms_valeurs_stations (
	cmsid INTEGER,
	stationid INTEGER,
	typeSite INTEGER,
	codeSite INTEGER,
	dataTypeId INTEGER,
	dateValeur	TIMESTAMP WITH TIME ZONE,
	Valeur	REAL,
	Datemaj TIMESTAMP WITH TIME ZONE,
	Loginmaj CHARACTER VARYING(100)
);

create unique index pk_cms_valeurs_stations on cms_valeurs_stations (cmsid, stationid);

create table cms_valeurs_stations_evenements (
	cmsid INTEGER,
	stationid INTEGER,
	typeSite INTEGER,
	codeSite INTEGER,
	dateEvenement	TIMESTAMP WITH TIME ZONE,
	Commentaire TEXT,
	Datemaj TIMESTAMP WITH TIME ZONE,
	Loginmaj CHARACTER VARYING(100)
);

create unique index pk_cms_valeurs_stations_evenements on cms_valeurs_stations_evenements (cmsid, stationid);

create table cms_valeurs_obstacles (
	cmsid INTEGER,
	obstacleid INTEGER,
	codeInstallation INTEGER,
	valeur TEXT,
	ordre INTEGER
);

create unique index pk_cms_valeurs_obstacles on cms_valeurs_obstacles (cmsid, obstacleid);

create table cms_valeurs_maregraphes (
	cmsid INTEGER,
	maregrapheid INTEGER,
	codeStation INTEGER,
	coeffAM INTEGER,
	coeffPM INTEGER,
	hauteMerAM character varying(10),
	hauteMerPM character varying(10),
	basseMerAM character varying(10),
	basseMerPM character varying(10),
	ordre INTEGER
);

create unique index pk_cms_valeurs_maregraphes on cms_valeurs_maregraphes (cmsid, maregrapheid);

# --- !Downs