/**
 * @author pminot
 * @date 28/06/2022
 * @version 1.0.0
 * @project SIEau
 * @table aep_unites_prod_liens and lien_stations
 */

# --- !Ups

insert into aep_unites_prod_liens
	-- ressources
	(select prd.codeinstallation, 1, rs.id, 9 from (
		select distinct typestation, idstation, typestationliee, idstationliee identifiant, typelien
			from lien_stations where typestation = 5 and typestationliee = 9
		union
		select distinct typestationliee, idstationliee, typestation, idstation identifiant, typelien
			from lien_stations where typestationliee = 5 and typestation = 9
	) req
		inner join aep_unites_prod prd on (req.idstation = prd.identifiant)
		inner join ressources rs on (req.identifiant = rs.code)
	union
	-- hydrometres
	select prd.codeinstallation, 2, sh.codestation, 2 from (
		select distinct typestation, idstation, typestationliee, idstationliee identifiant, typelien
			from lien_stations where typestation = 5 and typestationliee = 2
		union
		select distinct typestationliee, idstationliee, typestation, idstation identifiant, typelien
			from lien_stations where typestationliee = 5 and typestation = 2
	) req
		inner join aep_unites_prod prd on (req.idstation = prd.identifiant)
		inner join stations_hydro sh on (req.identifiant = sh.codehydro)
	union
	-- piezometres
	select prd.codeinstallation, 3, pz.codepiezometre, 1 from (
		select distinct typestation, idstation, typestationliee, idstationliee identifiant, typelien
			from lien_stations where typestation = 5 and typestationliee = 1
		union
		select distinct typestationliee, idstationliee, typestation, idstation identifiant, typelien
			from lien_stations where typestationliee = 5 and typestation = 1
	) req
		inner join aep_unites_prod prd on (req.idstation = prd.identifiant)
		inner join piezometres pz on (req.identifiant = pz.codebss)
	union
	-- installation
	select prd.codeinstallation, 4, ist.codeinstallation, 7 from (
		select distinct typestation, idstation, typestationliee, idstationliee identifiant, typelien
			from lien_stations where typestation = 5 and typestationliee = 7
		union
		select distinct typestationliee, idstationliee, typestation, idstation identifiant, typelien
			from lien_stations where typestationliee = 5 and typestation = 7
	) req
		inner join aep_unites_prod prd on (req.idstation = prd.identifiant)
		inner join aep_installations ist on (req.identifiant = ist.identifiant)
	union
	-- qualitometres
	select prd.codeinstallation, 5, ql.codequalitometre, 3 from (
		select distinct typestation, idstation, typestationliee, idstationliee identifiant, typelien
			from lien_stations where typestation = 5 and typestationliee = 3
		union
		select distinct typestationliee, idstationliee, typestation, idstation identifiant, typelien
			from lien_stations where typestationliee = 5 and typestation = 3
	) req
		inner join aep_unites_prod prd on (req.idstation = prd.identifiant)
		inner join qualitometres ql on (req.identifiant = ql.codebss)
	union
	-- unites distri
	select prd.codeinstallation, 6, udi.codeinstallation, 6 from (
		select distinct typestation, idstation, typestationliee, idstationliee identifiant, typelien
			from lien_stations where typestation = 5 and typestationliee = 6
		union
		select distinct typestationliee, idstationliee, typestation, idstation identifiant, typelien
			from lien_stations where typestationliee = 5 and typestation = 6
	) req
		inner join aep_unites_prod prd on (req.idstation = prd.identifiant)
		inner join aep_udi udi on (req.identifiant = udi.identifiant)
	);

create table aep_unites_prod_liens_pmi as select distinct * from aep_unites_prod_liens;
drop table aep_unites_prod_liens;
create table aep_unites_prod_liens as select * from aep_unites_prod_liens_pmi;
drop table aep_unites_prod_liens_pmi;

# --- !Downs